/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.bit.BitStorage;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.MergedGenotypeCallTable;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.AlleleProbability;
import net.maizegenetics.dna.snp.score.Dosage;
import net.maizegenetics.dna.snp.score.ReferenceProbability;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.GeneralAnnotationStorage;

public class MergedGenotypeTable
implements GenotypeTable {
    private final GenotypeTable[] myGenotypeTables;
    private final GenotypeCallTable myGenotype;
    private final GenotypeCallTable[] myGenotypes;
    private final Map<Chromosome, GenotypeTable> myChromosomes = new HashMap<Chromosome, GenotypeTable>();
    private Chromosome[] myChromosomesList;
    private final TaxaList myTaxaList;
    private String[][] myAlleleStates;
    private PositionList myPositions = null;
    private boolean mergedMode = false;

    public MergedGenotypeTable(GenotypeTable[] genoTables, TaxaList taxaList, PositionList positionList) {
        this.myGenotypeTables = genoTables;
        this.myTaxaList = taxaList;
        this.myPositions = positionList;
        this.myGenotypes = new GenotypeCallTable[this.myGenotypeTables.length];
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            this.myGenotypes[i] = this.myGenotypeTables[i].genotypeMatrix();
        }
        int[][] taxonMap = new int[taxaList.size()][genoTables.length];
        for (int i = 0; i < this.myTaxaList.numberOfTaxa(); ++i) {
            int[] taxaIndexPerTable = new int[this.myGenotypeTables.length];
            for (int j = 0; j < taxaIndexPerTable.length; ++j) {
                taxaIndexPerTable[j] = this.myGenotypeTables[j].taxa().indexOf((Taxon)this.myTaxaList.get(i)) == -1 ? -1 : this.myGenotypeTables[j].taxa().indexOf((Taxon)this.myTaxaList.get(i));
            }
            taxonMap[i] = taxaIndexPerTable;
        }
        int[][] positionMap = new int[this.myPositions.size()][this.myGenotypeTables.length];
        for (int i = 0; i < positionMap.length; ++i) {
            int[] posIndexPerTable = new int[positionMap[i].length];
            for (int j = 0; j < posIndexPerTable.length; ++j) {
                posIndexPerTable[j] = this.myGenotypeTables[j].positions().indexOf(this.myPositions.get(i)) == -1 ? -1 : this.myGenotypeTables[j].positions().indexOf(this.myPositions.get(i));
            }
            positionMap[i] = posIndexPerTable;
        }
        this.myGenotype = MergedGenotypeCallTable.getInstance(this.myGenotypes, taxonMap, positionMap);
    }

    public static GenotypeTable getInstance(GenotypeTable[] genoTables, BiFunction taxaMergeRule, BiFunction positionMergeRule) {
        TaxaList txl = (TaxaList)taxaMergeRule.apply(genoTables[0].taxa(), genoTables[1].taxa());
        PositionList posList = (PositionList)positionMergeRule.apply(genoTables[0].positions(), genoTables[1].positions());
        return new MergedGenotypeTable(genoTables, txl, posList);
    }

    @Override
    public boolean hasGenotype() {
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            if (!this.myGenotypeTables[i].hasGenotype()) continue;
            return true;
        }
        return false;
    }

    @Override
    public GenotypeCallTable genotypeMatrix() {
        return this.myGenotype;
    }

    @Override
    public byte genotype(int taxon, int site) {
        return this.myGenotype.genotype(taxon, site);
    }

    @Override
    public byte[] genotypeArray(int taxon, int site) {
        return this.myGenotype.genotypeArray(taxon, site);
    }

    @Override
    public byte genotype(int taxon, Chromosome chromosome, int physicalPosition) {
        return this.myGenotype.genotype(taxon, this.myPositions.siteOfPhysicalPosition(physicalPosition, chromosome));
    }

    @Override
    public byte[] genotypeRange(int taxon, int startSite, int endSite) {
        return this.myGenotype.genotypeRange(taxon, startSite, endSite);
    }

    @Override
    public byte[] genotypeAllSites(int taxon) {
        return this.myGenotype.genotypeAllSites(taxon);
    }

    @Override
    public byte[] genotypeAllTaxa(int site) {
        byte[] genotypes = new byte[this.myTaxaList.numberOfTaxa()];
        for (int i = 0; i < genotypes.length; ++i) {
            genotypes[i] = this.myGenotype.genotype(i, site);
        }
        return genotypes;
    }

    @Override
    public BitSet allelePresenceForAllSites(int taxon, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("CombineGenotypeTable: getAllelePresenceForAllSites: This operation isn't possible as it spans multiple GenotypeTables.");
    }

    @Override
    public long[] allelePresenceForSitesBlock(int taxon, WHICH_ALLELE allele, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("CombineGenotypeTable: getAllelePresenceForSitesBlock: This operation isn't possible as it spans multiple GenotypeTables.");
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllSites(int taxon, boolean firstParent, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllTaxa(int site, boolean firstParent, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] haplotypeAllelePresenceForSitesBlock(int taxon, boolean firstParent, WHICH_ALLELE allele, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return this.myGenotype.genotypeAsString(taxon, site);
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        return this.myGenotype.genotypeAsStringRange(taxon, startSite, endSite);
    }

    @Override
    public String genotypeAsStringRow(int taxon) {
        return this.myGenotype.genotypeAsStringRow(taxon);
    }

    @Override
    public String[] genotypeAsStringArray(int taxon, int site) {
        return this.myGenotype.genotypeAsStringArray(taxon, site);
    }

    @Override
    public byte referenceAllele(int site) {
        return 15;
    }

    @Override
    public byte alternateAllele(int site) {
        return 15;
    }

    @Override
    public byte[] referenceAlleles(int startSite, int endSite) {
        return null;
    }

    @Override
    public byte[] referenceAlleleForAllSites() {
        return null;
    }

    @Override
    public boolean hasReference() {
        return false;
    }

    @Override
    public boolean isHeterozygous(int taxon, int site) {
        return false;
    }

    @Override
    public int heterozygousCount(int site) {
        return 0;
    }

    @Override
    public String siteName(int site) {
        return ((Position)this.myPositions.get(site)).getSNPID();
    }

    @Override
    public int numberOfSites() {
        return this.myPositions.size();
    }

    @Override
    public int chromosomeSiteCount(Chromosome chromosome) {
        return 0;
    }

    @Override
    public int[] firstLastSiteOfChromosome(Chromosome chromosome) {
        return null;
    }

    @Override
    public int numberOfTaxa() {
        return this.myTaxaList.size();
    }

    @Override
    public PositionList positions() {
        return this.myPositions;
    }

    @Override
    public int chromosomalPosition(int site) {
        return this.myPositions.chromosomalPosition(site);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome) {
        return this.myPositions.siteOfPhysicalPosition(physicalPosition, chromosome);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome, String snpName) {
        return this.myPositions.siteOfPhysicalPosition(physicalPosition, chromosome, snpName);
    }

    @Override
    public int[] physicalPositions() {
        return this.myPositions.physicalPositions();
    }

    @Override
    public String chromosomeName(int site) {
        return this.myPositions.chromosomeName(site);
    }

    @Override
    public Chromosome chromosome(int site) {
        return this.myPositions.chromosome(site);
    }

    @Override
    public Chromosome chromosome(String name) {
        return this.myPositions.chromosome(name);
    }

    @Override
    public Chromosome[] chromosomes() {
        return this.myPositions.chromosomes();
    }

    @Override
    public int numChromosomes() {
        return this.myPositions.numChromosomes();
    }

    @Override
    public int[] chromosomesOffsets() {
        return this.myPositions.chromosomesOffsets();
    }

    @Override
    public boolean hasDepth() {
        return false;
    }

    @Override
    public boolean hasAlleleProbabilities() {
        return false;
    }

    @Override
    public boolean hasReferenceProbablity() {
        return false;
    }

    @Override
    public boolean hasDosage() {
        return false;
    }

    @Override
    public Set<SiteScore.SITE_SCORE_TYPE> siteScoreTypes() {
        return null;
    }

    @Override
    public AlleleProbability alleleProbability() {
        return null;
    }

    @Override
    public float alleleProbability(int taxon, int site, SiteScore.SITE_SCORE_TYPE type) {
        return 0.0f;
    }

    @Override
    public ReferenceProbability referenceProbability() {
        return null;
    }

    @Override
    public float referenceProbability(int taxon, int site) {
        return 0.0f;
    }

    @Override
    public Dosage dosage() {
        return null;
    }

    @Override
    public byte dosage(int taxon, int site) {
        return 0;
    }

    @Override
    public int indelSize(int site) {
        return 0;
    }

    @Override
    public boolean isIndel(int site) {
        return false;
    }

    @Override
    public boolean isAllPolymorphic() {
        return false;
    }

    @Override
    public boolean isPolymorphic(int site) {
        return false;
    }

    @Override
    public byte majorAllele(int site) {
        return 0;
    }

    @Override
    public String majorAlleleAsString(int site) {
        return null;
    }

    @Override
    public byte minorAllele(int site) {
        return 0;
    }

    @Override
    public String minorAlleleAsString(int site) {
        return null;
    }

    @Override
    public byte[] minorAlleles(int site) {
        return null;
    }

    @Override
    public byte[] alleles(int site) {
        return this.myGenotype.alleles(site);
    }

    @Override
    public double minorAlleleFrequency(int site) {
        return 0.0;
    }

    @Override
    public double majorAlleleFrequency(int site) {
        return 0.0;
    }

    @Override
    public TaxaList taxa() {
        return this.myTaxaList;
    }

    @Override
    public String taxaName(int index) {
        return this.myTaxaList.taxaName(index);
    }

    @Override
    public String genomeVersion() {
        return null;
    }

    @Override
    public boolean isPositiveStrand(int site) {
        return false;
    }

    @Override
    public GenotypeTable[] compositeAlignments() {
        return null;
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        return this.myGenotype.allelesSortedByFrequency(site);
    }

    @Override
    public Object[][] genosSortedByFrequency(int site) {
        return null;
    }

    @Override
    public boolean isPhased() {
        return false;
    }

    @Override
    public boolean retainsRareAlleles() {
        return false;
    }

    @Override
    public String[][] alleleDefinitions() {
        return null;
    }

    @Override
    public String[] alleleDefinitions(int site) {
        return null;
    }

    @Override
    public String genotypeAsString(int site, byte value) {
        return null;
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return null;
    }

    @Override
    public int maxNumAlleles() {
        return 0;
    }

    @Override
    public int totalGametesNonMissingForSite(int site) {
        return 0;
    }

    @Override
    public int totalNonMissingForSite(int site) {
        return 0;
    }

    @Override
    public int minorAlleleCount(int site) {
        return 0;
    }

    @Override
    public int majorAlleleCount(int site) {
        return 0;
    }

    @Override
    public Object[][] genoCounts() {
        return null;
    }

    @Override
    public Object[][] majorMinorCounts() {
        return null;
    }

    @Override
    public int totalGametesNonMissingForTaxon(int taxon) {
        return 0;
    }

    @Override
    public int heterozygousCountForTaxon(int taxon) {
        return 0;
    }

    @Override
    public int totalNonMissingForTaxon(int taxon) {
        return 0;
    }

    @Override
    public AlleleDepth depth() {
        return null;
    }

    @Override
    public int[] depthForAlleles(int taxon, int site) {
        return null;
    }

    @Override
    public byte[] allelesBySortType(GenotypeTable.ALLELE_SORT_TYPE scope, int site) {
        return null;
    }

    @Override
    public BitSet allelePresenceForAllTaxa(int site, WHICH_ALLELE allele) {
        return null;
    }

    @Override
    public BitStorage bitStorage(WHICH_ALLELE allele) {
        return null;
    }

    @Override
    public GeneralAnnotationStorage annotations() {
        return null;
    }

    @Override
    public Stream<Byte> streamGenotype() {
        return null;
    }

    @Override
    public Stream<Byte> streamGenotype(int taxon) {
        return null;
    }

    @Override
    public boolean hasSiteTranslations() {
        return false;
    }

    @Override
    public int[] siteTranslations() {
        return null;
    }
}

