/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.Allele;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.GeneralAnnotationStorage;

public class SimpleAllele
implements Allele {
    private final byte myAllele;
    private final Position myPosition;
    private final GeneralAnnotationStorage myAnnotations;

    public SimpleAllele(byte myAllele, Position myPosition) {
        this.myAllele = myAllele;
        this.myPosition = myPosition;
        this.myAnnotations = GeneralAnnotationStorage.getBuilder().build();
    }

    @Override
    public Position position() {
        return this.myPosition;
    }

    @Override
    public byte allele() {
        return this.myAllele;
    }

    @Override
    public String alleleAsString() {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(this.myAllele);
    }

    @Override
    public GeneralAnnotation annotations() {
        return this.myAnnotations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleAllele that = (SimpleAllele)o;
        if (this.myAllele != that.myAllele) {
            return false;
        }
        return this.myPosition.equals(that.myPosition);
    }

    public int hashCode() {
        int result = this.myAllele;
        result = 31 * result + this.myPosition.hashCode();
        return result;
    }
}

