/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import net.maizegenetics.dna.snp.TranslateIndex;

public class Translate {
    private final TranslateIndex myTranslateTaxa;
    private final TranslateIndex myTranslateSite;

    Translate(TranslateIndex translateTaxa, TranslateIndex translateSite) {
        if (translateTaxa == null) {
            throw new IllegalArgumentException("Translate: init: translate taxa can't be null");
        }
        if (translateSite == null) {
            throw new IllegalArgumentException("Translate: init: translate site can't be null");
        }
        this.myTranslateTaxa = translateTaxa;
        this.myTranslateSite = translateSite;
    }

    public int taxon(int taxon) {
        return this.myTranslateTaxa.translate(taxon);
    }

    public int site(int site) {
        return this.myTranslateSite.translate(site);
    }

    public long taxonSite(int taxon, int site) {
        return (long)this.taxon(taxon) << 32 | (long)this.site(site);
    }

    public boolean hasSiteTranslations() {
        return this.myTranslateSite.hasTranslations();
    }

    public boolean hasTaxaTranslations() {
        return this.myTranslateTaxa.hasTranslations();
    }

    public int[] siteTranslations() {
        return this.myTranslateSite.getTranslations();
    }

    public int[] taxaTranslations() {
        return this.myTranslateTaxa.getTranslations();
    }

    TranslateIndex translateTaxa() {
        return this.myTranslateTaxa;
    }

    TranslateIndex translateSite() {
        return this.myTranslateSite;
    }

    public int numTaxa() {
        return this.myTranslateTaxa.numIndices();
    }

    public int numSites() {
        return this.myTranslateSite.numIndices();
    }
}

