/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.maizegenetics.dna.snp.TranslateIndex;
import net.maizegenetics.dna.snp.TranslateIndexRange;
import net.maizegenetics.dna.snp.TranslateIndexRedirect;
import net.maizegenetics.dna.snp.TranslateIndexRedirectUnordered;

public class TranslateIndexBuilder {
    private final TranslateIndex myBase;
    private final int myNumBaseIndices;
    private boolean myHasNegativeIndices = false;
    private boolean myIsUnordered = false;
    private final List<Integer> myIndicesToKeep = new ArrayList<Integer>();

    private TranslateIndexBuilder(int numBaseIndices) {
        this.myNumBaseIndices = numBaseIndices;
        this.myBase = null;
    }

    private TranslateIndexBuilder(TranslateIndex base) {
        this.myNumBaseIndices = base.numIndices();
        this.myBase = base;
    }

    public static TranslateIndexBuilder getInstance(int numBaseIndices) {
        return new TranslateIndexBuilder(numBaseIndices);
    }

    public static TranslateIndexBuilder getInstance(TranslateIndex base) {
        return new TranslateIndexBuilder(base);
    }

    public static TranslateIndexBuilder getInstance(int numBaseIndices, TranslateIndex base) {
        if (base == null) {
            return new TranslateIndexBuilder(numBaseIndices);
        }
        if (numBaseIndices != base.numIndices()) {
            throw new IllegalArgumentException("TranslateTaxaBuilder: getInstance: numBaseIndices: " + numBaseIndices + " should equal base: " + base.numIndices());
        }
        return new TranslateIndexBuilder(base);
    }

    public static TranslateIndex merge(TranslateIndex base, TranslateIndex translate) {
        if (base == null || translate == null) {
            throw new IllegalArgumentException("TranslateIndexBuilder: merge: base and translate can't be null");
        }
        if (!base.hasTranslations()) {
            return translate;
        }
        if (!translate.hasTranslations()) {
            return base;
        }
        int numIndices = translate.numIndices();
        int[] result = new int[numIndices];
        boolean ordered = true;
        int last = -1;
        for (int i = 0; i < numIndices; ++i) {
            int temp = translate.translate(i);
            if (temp == -1) {
                result[i] = -1;
                ordered = false;
                continue;
            }
            result[i] = base.translate(temp);
            if (result[i] <= last) {
                ordered = false;
            }
            last = result[i];
        }
        if (ordered) {
            if (TranslateIndexBuilder.isNoTranslation(result)) {
                if (base.numIndices() == numIndices && !base.hasTranslations()) {
                    return new TranslateIndex(numIndices, false);
                }
                return new TranslateIndex(numIndices, true);
            }
            return new TranslateIndexRedirect(result);
        }
        return new TranslateIndexRedirectUnordered(result);
    }

    public static TranslateIndex noTranslation(int numIndices) {
        return new TranslateIndex(numIndices, false);
    }

    public static TranslateIndex orderedTranslation(int[] indexRedirect, TranslateIndex base, int numBaseIndices) {
        int numIndices = indexRedirect.length;
        if (base == null) {
            int[] result = new int[numIndices];
            for (int i = 0; i < numIndices; ++i) {
                if (indexRedirect[i] < -1) {
                    throw new IllegalArgumentException("TranslateIndexBuilder: orderedTranslation: ordered translation can't contain negative indices.");
                }
                result[i] = indexRedirect[i];
            }
            Arrays.sort(result);
            if (TranslateIndexBuilder.isNoTranslation(result)) {
                if (numBaseIndices == numIndices) {
                    return new TranslateIndex(numIndices, false);
                }
                return new TranslateIndex(numIndices, true);
            }
            return new TranslateIndexRedirect(result);
        }
        if (base.numIndices() != numBaseIndices) {
            throw new IllegalArgumentException("TranslateIndexBuilder: orderedTranslation: number of indices in base translation: " + base.numIndices() + " should equal number of base indices: " + numBaseIndices);
        }
        int[] result = new int[numIndices];
        for (int i = 0; i < numIndices; ++i) {
            if (indexRedirect[i] < -1) {
                throw new IllegalArgumentException("TranslateIndexBuilder: orderedTranslation: ordered translation can't contain negative indices.");
            }
            result[i] = base.translate(indexRedirect[i]);
        }
        Arrays.sort(result);
        if (TranslateIndexBuilder.isNoTranslation(result)) {
            if (numBaseIndices == numIndices) {
                return new TranslateIndex(numIndices, false);
            }
            return new TranslateIndex(numIndices, true);
        }
        return new TranslateIndexRedirect(result);
    }

    public static TranslateIndex unorderedTranslation(int[] indicesNewOrder, TranslateIndex base) {
        int numIndices = indicesNewOrder.length;
        if (base == null) {
            int[] result = new int[numIndices];
            for (int i = 0; i < numIndices; ++i) {
                if (indicesNewOrder[i] == -1) {
                    result[i] = -1;
                    continue;
                }
                if (indicesNewOrder[i] < 0) {
                    throw new IllegalArgumentException("TranslateIndexBuilder: unorderedTranslation: only negative number allowed is -1.");
                }
                result[i] = indicesNewOrder[i];
            }
            return new TranslateIndexRedirectUnordered(result);
        }
        if (numIndices != base.numIndices()) {
            throw new IllegalStateException("TranslateIndexBuilder: unorderedTranslation: number of newly ordered indices: " + numIndices + " should equal base num indices: " + base.numIndices());
        }
        int[] result = new int[numIndices];
        for (int i = 0; i < numIndices; ++i) {
            if (indicesNewOrder[i] == -1) {
                result[i] = -1;
                continue;
            }
            if (indicesNewOrder[i] < 0) {
                throw new IllegalArgumentException("TranslateIndexBuilder: unorderedTranslation: only negative number allowed is -1.");
            }
            result[i] = base.translate(indicesNewOrder[i]);
        }
        return new TranslateIndexRedirectUnordered(result);
    }

    public static TranslateIndex range(int start, int end, TranslateIndex base, int numBaseIndices) {
        if (start < 0 || start > end) {
            throw new IllegalArgumentException();
        }
        if (base == null) {
            if (start == 0) {
                int len = end + 1;
                if (len == numBaseIndices) {
                    return new TranslateIndex(len, false);
                }
                return new TranslateIndex(len, true);
            }
            return new TranslateIndexRange(start, end);
        }
        if (base.numIndices() != numBaseIndices) {
            throw new IllegalArgumentException("TranslateIndexBuilder: range: number of indices in base translation: " + base.numIndices() + " should equal number of base indices: " + numBaseIndices);
        }
        return new TranslateIndexBuilder(base).keepIndices(start, end).build();
    }

    public TranslateIndexBuilder unordered() {
        this.myIsUnordered = true;
        return this;
    }

    public TranslateIndexBuilder keepIndex(int index) {
        if (index == -1) {
            this.myHasNegativeIndices = true;
        } else if (index < 0 || index >= this.myNumBaseIndices) {
            throw new IllegalArgumentException("TranslateIndexBuilder: keepIndex: index: " + index + " out of range: " + 0 + " to: " + (this.myNumBaseIndices - 1));
        }
        this.myIndicesToKeep.add(index);
        return this;
    }

    public TranslateIndexBuilder keepIndices(int start, int end) {
        if (start < 0 || start > end || end >= this.myNumBaseIndices) {
            throw new IllegalArgumentException();
        }
        for (int i = start; i <= end; ++i) {
            this.myIndicesToKeep.add(i);
        }
        return this;
    }

    public TranslateIndexBuilder keepIndices(int[] indices) {
        for (int current : indices) {
            this.keepIndex(current);
        }
        return this;
    }

    public int numIndices() {
        return this.myIndicesToKeep.size();
    }

    private static boolean isNoTranslation(int[] indices) {
        int len = indices.length;
        for (int i = 0; i < len; ++i) {
            if (i == indices[i]) continue;
            return false;
        }
        return true;
    }

    public TranslateIndex build() {
        int numIndicesToKeep = this.myIndicesToKeep.size();
        int[] indexRedirect = new int[numIndicesToKeep];
        if (this.myBase == null) {
            for (int i = 0; i < numIndicesToKeep; ++i) {
                indexRedirect[i] = this.myIndicesToKeep.get(i);
            }
        } else {
            for (int i = 0; i < numIndicesToKeep; ++i) {
                indexRedirect[i] = this.myBase.translate(this.myIndicesToKeep.get(i));
            }
        }
        if (this.myHasNegativeIndices || this.myIsUnordered) {
            return new TranslateIndexRedirectUnordered(indexRedirect);
        }
        Arrays.sort(indexRedirect);
        if (TranslateIndexBuilder.isNoTranslation(indexRedirect)) {
            if (this.myNumBaseIndices == indexRedirect.length) {
                return new TranslateIndex(this.myNumBaseIndices, false);
            }
            return new TranslateIndex(indexRedirect.length, true);
        }
        return new TranslateIndexRedirect(indexRedirect);
    }
}

