/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.byte2d;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.byte2d.AbstractByte2D;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.HDF5Utils;

public class HDF5Byte2D
extends AbstractByte2D {
    private static final int MAX_CACHE_SIZE = 65536;
    private static final int HDF5_BLOCK = 65536;
    private final Map<Long, byte[]> myCache = new LinkedHashMap<Long, byte[]>(98304){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, byte[]> eldest) {
            return this.size() > 65536;
        }
    };
    private final IHDF5Reader myReader;
    private final int myNumSites;
    private final TaxaList myTaxa;

    HDF5Byte2D(IHDF5Reader reader, SiteScore.SITE_SCORE_TYPE siteScoreType) {
        super(siteScoreType, reader.int32().getAttr("Genotypes", "numTaxa"), reader.int32().getAttr("Positions/", "numSites"));
        this.myReader = reader;
        this.myNumSites = reader.int32().getAttr("Positions/", "numSites");
        this.myTaxa = new TaxaListBuilder().buildFromHDF5(reader);
    }

    private static long getCacheKey(int taxon, int site) {
        return (long)taxon << 33;
    }

    private byte[] cacheValues(int taxon, long key) {
        byte[] data = HDF5Utils.getHDF5GenotypeSiteScores(this.myReader, this.myTaxa.taxaName(taxon), this.siteScoreType().name());
        if (data == null) {
            return null;
        }
        this.myCache.put(key, data);
        return data;
    }

    @Override
    public byte valueForAllele(int taxon, int site) {
        long key = HDF5Byte2D.getCacheKey(taxon, site);
        byte[] data = this.myCache.get(key);
        if (data == null) {
            data = this.cacheValues(taxon, key);
        }
        return data[site];
    }
}

