/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ForkJoinPool;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.Stats;

public class AlleleFreqCache {
    private static final int DEFAULT_MAX_NUM_ALLELES = 6;
    private static final int SHIFT_AMOUNT = 8;
    private static final int NUM_SITES_TO_CACHE = 256;
    public static final int SITE_BLOCK_MASK = -256;
    private final GenotypeCallTable myGenotype;
    private final int myMaxNumAlleles;
    private final Cache<Integer, int[][][]> myCachedAlleleFreqs;
    private final ForkJoinPool myThreadPool;
    public static final int UNKNOWN_COUNT = 0;
    public static final int UNKNOWN_GAMETE_COUNT = 1;
    public static final int HETEROZYGOUS_COUNT = 2;
    public static final int HOMOZYGOUS_COUNT = 3;
    private static final byte UNKNOWN_COUNT_BIT = 1;
    private static final byte UNKNOWN_SINGLE_GAMETE_COUNT_BIT = 2;
    private static final byte HETEROZYGOUS_COUNT_BIT = 4;
    private static final byte HOMOZYGOUS_COUNT_BIT = 8;
    private static final byte[] OTHER_COUNTS = new byte[256];
    private final CopyOnWriteArraySet<Integer> myCurrentlyProcessingBlocks = new CopyOnWriteArraySet();

    public AlleleFreqCache(GenotypeCallTable genotype, int maxNumAlleles) {
        this.myGenotype = genotype;
        this.myMaxNumAlleles = maxNumAlleles;
        this.myCachedAlleleFreqs = CacheBuilder.newBuilder().initialCapacity(this.myGenotype.numberOfSites() / 256).build();
        this.myThreadPool = ForkJoinPool.commonPool();
    }

    private static int getStartSite(int site) {
        return site & 0xFFFFFF00;
    }

    private int[][] getCachedAlleleFreq(int site) {
        int startSite = AlleleFreqCache.getStartSite(site);
        int[][][] result = (int[][][])this.myCachedAlleleFreqs.getIfPresent((Object)startSite);
        if (result == null) {
            this.startLookAhead(startSite);
            if (site == startSite) {
                this.startLookAhead(startSite + 256);
                this.startLookAhead(startSite + 512);
                this.startLookAhead(startSite + 768);
            }
            return this.alleleFreq(site);
        }
        return result[site - startSite];
    }

    public int[][] getAllelesSortedByFrequency(int site) {
        return this.getCachedAlleleFreq(site);
    }

    private int[][][] calculateAlleleFreq(int site) {
        int startSite = AlleleFreqCache.getStartSite(site);
        int numSites = Math.min(256, this.myGenotype.numberOfSites() - startSite);
        int[][][] alleleCounts = new int[numSites][][];
        for (int s = 0; s < numSites; ++s) {
            alleleCounts[s] = this.alleleFreq(startSite + s);
        }
        this.myCachedAlleleFreqs.put((Object)startSite, (Object)alleleCounts);
        return alleleCounts;
    }

    private int[][] alleleFreq(int site) {
        return AlleleFreqCache.alleleFreq(this.myGenotype.genotypeForAllTaxa(site), this.myMaxNumAlleles);
    }

    public static int[][] allelesSortedByFrequencyNucleotide(byte[] data) {
        return AlleleFreqCache.alleleFreq(data, 6);
    }

    private static int[][] alleleFreq(byte[] data, int maxNumAlleles) {
        int numTaxa = data.length;
        int[] alleleFreq = new int[maxNumAlleles];
        for (int taxon = 0; taxon < numTaxa; ++taxon) {
            if ((data[taxon] >>> 4 & 0xF) < maxNumAlleles) {
                int n = data[taxon] >>> 4 & 0xF;
                alleleFreq[n] = alleleFreq[n] + 1;
            }
            if ((data[taxon] & 0xF) >= maxNumAlleles) continue;
            int n = data[taxon] & 0xF;
            alleleFreq[n] = alleleFreq[n] + 1;
        }
        for (int i = 0; i < maxNumAlleles; i = (int)((byte)(i + 1))) {
            alleleFreq[i] = alleleFreq[i] << 4 | maxNumAlleles - 1 - i;
        }
        int numAlleles = AlleleFreqCache.sort(alleleFreq, maxNumAlleles);
        int[][] alleleCounts = new int[2][numAlleles];
        for (int i = 0; i < numAlleles; ++i) {
            alleleCounts[0][i] = (byte)(5 - (0xF & alleleFreq[i]));
            alleleCounts[1][i] = alleleFreq[i] >>> 4;
        }
        return alleleCounts;
    }

    public static Stats allelesSortedByFrequencyAndCountsNucleotide(int index, byte[] data) {
        return AlleleFreqCache.alleleFreqCounts(index, data, 6);
    }

    private static Stats alleleFreqCounts(int index, byte[] data, int maxNumAlleles) {
        int i;
        int numGenotypes = data.length;
        int[] alleleFreq = new int[maxNumAlleles];
        int[] otherCounts = new int[4];
        for (i = 0; i < numGenotypes; ++i) {
            int count = Byte.toUnsignedInt(data[i]);
            otherCounts[0] = otherCounts[0] + (OTHER_COUNTS[count] & 1);
            otherCounts[1] = otherCounts[1] + ((OTHER_COUNTS[count] & 1) << 1);
            otherCounts[1] = otherCounts[1] + ((OTHER_COUNTS[count] & 2) >>> 1);
            otherCounts[2] = otherCounts[2] + ((OTHER_COUNTS[count] & 4) >>> 2);
            otherCounts[3] = otherCounts[3] + ((OTHER_COUNTS[count] & 8) >>> 3);
            if ((data[i] >>> 4 & 0xF) < maxNumAlleles) {
                int n = data[i] >>> 4 & 0xF;
                alleleFreq[n] = alleleFreq[n] + 1;
            }
            if ((data[i] & 0xF) >= maxNumAlleles) continue;
            int n = data[i] & 0xF;
            alleleFreq[n] = alleleFreq[n] + 1;
        }
        for (i = 0; i < maxNumAlleles; i = (int)((byte)(i + 1))) {
            alleleFreq[i] = alleleFreq[i] << 4 | maxNumAlleles - 1 - i;
        }
        int numAlleles = AlleleFreqCache.sort(alleleFreq, maxNumAlleles);
        int[][] alleleCounts = new int[2][numAlleles];
        for (int i2 = 0; i2 < numAlleles; ++i2) {
            alleleCounts[0][i2] = (byte)(5 - (0xF & alleleFreq[i2]));
            alleleCounts[1][i2] = alleleFreq[i2] >>> 4;
        }
        return Stats.getInstance(alleleCounts, otherCounts, numGenotypes, index);
    }

    private static int sort(int[] data, int maxNumAlleles) {
        int countNotZero = 0;
        for (int j = 0; j < maxNumAlleles - 1; ++j) {
            int imax = j;
            for (int i = j + 1; i < maxNumAlleles; ++i) {
                if (data[i] <= data[imax]) continue;
                imax = i;
            }
            if (data[imax] > 15) {
                int temp = data[j];
                data[j] = data[imax];
                data[imax] = temp;
                ++countNotZero;
                continue;
            }
            return countNotZero;
        }
        if (data[5] > 15) {
            ++countNotZero;
        }
        return countNotZero;
    }

    public static byte majorAllele(int[][] alleles) {
        if (alleles[0].length >= 1) {
            return (byte)alleles[0][0];
        }
        return 15;
    }

    public static double majorAlleleFrequency(int[][] alleles) {
        int numAlleles = alleles[0].length;
        if (numAlleles >= 1) {
            int totalNonMissing = 0;
            for (int i = 0; i < numAlleles; ++i) {
                totalNonMissing += alleles[1][i];
            }
            return (double)alleles[1][0] / (double)totalNonMissing;
        }
        return 0.0;
    }

    public static byte minorAllele(int[][] alleles) {
        if (alleles[0].length >= 2) {
            return (byte)alleles[0][1];
        }
        return 15;
    }

    public static double minorAlleleFrequency(int[][] alleles) {
        int numAlleles = alleles[0].length;
        if (numAlleles >= 2) {
            int totalNonMissing = 0;
            for (int i = 0; i < numAlleles; ++i) {
                totalNonMissing += alleles[1][i];
            }
            return (double)alleles[1][1] / (double)totalNonMissing;
        }
        return 0.0;
    }

    public static int totalGametesNonMissingForSite(int[][] alleles) {
        int numAlleles = alleles[0].length;
        int result = 0;
        for (int i = 0; i < numAlleles; ++i) {
            result += alleles[1][i];
        }
        return result;
    }

    public static double proportionHeterozygous(int[] counts, int totalCount) {
        return (double)counts[2] / (double)totalCount;
    }

    public static double proportionHeterozygous(byte[] data) {
        int numNotMissing = 0;
        int numHeterozygous = 0;
        for (byte current : data) {
            if (current == -1) continue;
            ++numNotMissing;
            if (!GenotypeTableUtils.isHeterozygous(current)) continue;
            ++numHeterozygous;
        }
        if (numNotMissing == 0) {
            return 0.0;
        }
        return (double)numHeterozygous / (double)numNotMissing;
    }

    private void startLookAhead(int site) {
        int startSite = AlleleFreqCache.getStartSite(site);
        if (startSite < this.myGenotype.numberOfSites() && this.myCachedAlleleFreqs.getIfPresent((Object)startSite) == null && this.myCurrentlyProcessingBlocks.add(startSite)) {
            this.myThreadPool.execute(new LookAheadSiteStats(startSite));
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            byte[] alleles;
            AlleleFreqCache.OTHER_COUNTS[i] = (byte)i == -1 ? 1 : ((alleles = GenotypeTableUtils.getDiploidValues((byte)i))[0] == 15 ? 2 : (alleles[1] == 15 ? 2 : (alleles[0] == alleles[1] ? 8 : 4)));
        }
    }

    private class LookAheadSiteStats
    implements Runnable {
        private final int myStartSite;

        public LookAheadSiteStats(int site) {
            this.myStartSite = AlleleFreqCache.getStartSite(site);
        }

        @Override
        public void run() {
            try {
                AlleleFreqCache.this.calculateAlleleFreq(this.myStartSite);
            }
            finally {
                AlleleFreqCache.this.myCurrentlyProcessingBlocks.remove(this.myStartSite);
            }
        }
    }
}

