/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Spliterator;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Tassel5HDF5Constants;
import org.apache.log4j.Logger;

class HDF5ByteGenotypeCallTable
extends AbstractGenotypeCallTable {
    private static final Logger myLogger = Logger.getLogger(HDF5ByteGenotypeCallTable.class);
    private static final int SHIFT_AMOUNT = 16;
    private final String[] genotypePaths;
    private static final int HDF5_GENOTYPE_BLOCK_SIZE = 65536;
    public static final int SITE_BLOCK_MASK = -65536;
    private final IHDF5Reader myHDF5Reader;
    private final LoadingCache<Long, byte[]> myGenoCache;
    private final CacheLoader<Long, byte[]> myGenoLoader = new CacheLoader<Long, byte[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] load(Long key) {
            byte[] data;
            long offset = HDF5ByteGenotypeCallTable.getSiteStartFromKey(key) << 16;
            IHDF5Reader iHDF5Reader = HDF5ByteGenotypeCallTable.this.myHDF5Reader;
            synchronized (iHDF5Reader) {
                data = HDF5ByteGenotypeCallTable.this.myHDF5Reader.int8().readArrayBlockWithOffset(HDF5ByteGenotypeCallTable.this.getTaxaGenoPath(HDF5ByteGenotypeCallTable.getTaxonFromKey(key)), 65536, offset);
            }
            return data;
        }
    };
    private final LoadingCache<Integer, SiteBlockAttr> mySiteAnnoCache;
    private final CacheLoader<Integer, SiteBlockAttr> siteAnnotLoader = new CacheLoader<Integer, SiteBlockAttr>(){
        int lastCachedStartSite = Integer.MIN_VALUE;
        int[][] af;
        byte[][] afOrder;
        float[] maf;
        float[] paf;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SiteBlockAttr load(Integer key) {
            int startSite = HDF5ByteGenotypeCallTable.getStartSite(key);
            int length = Math.min(65536, HDF5ByteGenotypeCallTable.this.numberOfSites() - startSite);
            System.out.println("Reading from HDF5 site anno:" + startSite);
            System.out.println("");
            IHDF5Reader iHDF5Reader = HDF5ByteGenotypeCallTable.this.myHDF5Reader;
            synchronized (iHDF5Reader) {
                this.af = HDF5ByteGenotypeCallTable.this.myHDF5Reader.int32().readMatrixBlockWithOffset("Genotypes/_Descriptors/AlleleCnt", 6, length, 0L, (long)startSite);
                this.afOrder = HDF5ByteGenotypeCallTable.this.myHDF5Reader.int8().readMatrixBlockWithOffset("Genotypes/_Descriptors/AlleleFreqOrder", 6, length, 0L, (long)startSite);
                this.maf = HDF5ByteGenotypeCallTable.this.myHDF5Reader.float32().readArrayBlockWithOffset("Genotypes/_Descriptors/MAF", length, (long)startSite);
                this.paf = HDF5ByteGenotypeCallTable.this.myHDF5Reader.float32().readArrayBlockWithOffset("Genotypes/_Descriptors/SiteCoverage", length, (long)startSite);
                this.lastCachedStartSite = startSite;
            }
            return new SiteBlockAttr(startSite, this.afOrder, this.af, this.maf, this.paf);
        }
    };

    private static long getCacheKey(int taxon, int site) {
        return ((long)taxon << 33) + (long)(site / 65536);
    }

    private static int getTaxonFromKey(long key) {
        return (int)(key >>> 33);
    }

    private static int getSiteStartFromKey(long key) {
        return (int)(key << 33 >>> 33);
    }

    private static int getStartSite(int site) {
        return site & 0xFFFF0000;
    }

    private String getTaxaGenoPath(int taxon) {
        return this.genotypePaths[taxon];
    }

    private HDF5ByteGenotypeCallTable(IHDF5Reader reader, int numTaxa, int numSites, boolean phased, String[][] alleleEncodings) {
        super(numTaxa, numSites, phased, alleleEncodings);
        this.genotypePaths = new String[numTaxa];
        TaxaList tL = new TaxaListBuilder().buildFromHDF5Genotypes(reader);
        for (int i = 0; i < numTaxa; ++i) {
            this.genotypePaths[i] = Tassel5HDF5Constants.getGenotypesCallsPath(tL.taxaName(i));
        }
        this.myHDF5Reader = reader;
        long oneThirdMemory = Runtime.getRuntime().maxMemory() / 196608L;
        long oneColumnBlockForEachProcess = numTaxa * Runtime.getRuntime().availableProcessors();
        this.myGenoCache = CacheBuilder.newBuilder().maximumSize(Math.min(oneThirdMemory, oneColumnBlockForEachProcess)).build(this.myGenoLoader);
        this.mySiteAnnoCache = CacheBuilder.newBuilder().maximumSize(150L).build(this.siteAnnotLoader);
    }

    static HDF5ByteGenotypeCallTable getInstance(IHDF5Reader reader) {
        if (!HDF5Utils.isHDF5GenotypeLocked(reader)) {
            throw new IllegalStateException("The Genotype module of this HDF5 file hasn't been locked, and therefore can't be opened for reading. This could occur if the file was created using the -ko (keep open) option when running the plugin ProductionSNPCallerPluginV2. Please check your file, close if appropriate, and try again.");
        }
        int numTaxa = reader.int32().getAttr("Genotypes/", "numTaxa");
        int numSites = reader.int32().getAttr("Positions/", "numSites");
        String[][] alleleEncodings = NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES;
        return new HDF5ByteGenotypeCallTable(reader, numTaxa, numSites, false, alleleEncodings);
    }

    @Override
    public byte genotype(int taxon, int site) {
        try {
            byte[] data = (byte[])this.myGenoCache.get((Object)HDF5ByteGenotypeCallTable.getCacheKey(taxon, site));
            return data[site % 65536];
        }
        catch (ExecutionException ex) {
            myLogger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("HDF5ByteGenotyeCallTable: getBase: Error getting base from cache: " + ex.getMessage());
        }
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(this.genotype(taxon, site));
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(value);
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        try {
            SiteBlockAttr sa = (SiteBlockAttr)this.mySiteAnnoCache.get((Object)HDF5ByteGenotypeCallTable.getStartSite(site));
            return sa.getAllelesSortedByFrequency(site);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Error in getMinorAlleleFrequency from cache");
        }
    }

    @Override
    public double minorAlleleFrequency(int site) {
        try {
            SiteBlockAttr sa = (SiteBlockAttr)this.mySiteAnnoCache.get((Object)HDF5ByteGenotypeCallTable.getStartSite(site));
            return sa.getMAF(site);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Error in getMinorAlleleFrequency from cache");
        }
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSiteOptimized() {
        return false;
    }

    @Override
    public Stream<Byte> stream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public Stream<Byte> stream(int taxon) {
        return StreamSupport.stream(new HDF5ByteGenotypeCallTableSpliterator(taxon, 0, this.numberOfSites(), taxon, this.numberOfSites()), true);
    }

    @Override
    public Spliterator<Byte> spliterator() {
        return new HDF5ByteGenotypeCallTableSpliterator(0, 0, this.numberOfSites(), this.numberOfTaxa() - 1, this.numberOfSites());
    }

    class HDF5ByteGenotypeCallTableSpliterator<T extends Byte>
    extends AbstractGenotypeCallTable.AbstractGenotypeCallTableSpliterator<Byte> {
        HDF5ByteGenotypeCallTableSpliterator(int taxaOrigin, int siteOrigin, int numSites, int taxaFence, int siteFence) {
            super(HDF5ByteGenotypeCallTable.this, taxaOrigin, siteOrigin, numSites, taxaFence, siteFence);
        }

        @Override
        public void forEachRemaining(Consumer<? super Byte> action) {
            int i;
            int endIndex;
            int startIndex;
            byte[] data;
            while (this.myTaxaOrigin < this.myTaxaFence) {
                while (this.mySiteOrigin < this.myNumSites) {
                    try {
                        data = (byte[])HDF5ByteGenotypeCallTable.this.myGenoCache.get((Object)HDF5ByteGenotypeCallTable.getCacheKey(this.myTaxaOrigin, this.mySiteOrigin));
                        startIndex = this.mySiteOrigin % 65536;
                        endIndex = data.length;
                        for (i = startIndex; i < endIndex; ++i) {
                            action.accept((Byte)data[i]);
                        }
                        this.mySiteOrigin += endIndex - startIndex;
                    }
                    catch (ExecutionException ex) {
                        myLogger.error((Object)ex.getMessage(), (Throwable)ex);
                        throw new IllegalStateException("HDF5ByteGenotyeCallTable: HDF5ByteGenotypeCallTableSpliterator: forEachRemaining: Error getting base from cache: " + ex.getMessage());
                    }
                }
                this.mySiteOrigin = 0;
                ++this.myTaxaOrigin;
            }
            while (this.mySiteOrigin < this.mySiteFence) {
                try {
                    data = (byte[])HDF5ByteGenotypeCallTable.this.myGenoCache.get((Object)HDF5ByteGenotypeCallTable.getCacheKey(this.myTaxaOrigin, this.mySiteOrigin));
                    startIndex = this.mySiteOrigin % 65536;
                    endIndex = Math.min(data.length, this.mySiteFence - this.mySiteOrigin);
                    for (i = startIndex; i < endIndex; ++i) {
                        action.accept((Byte)data[i]);
                    }
                    this.mySiteOrigin += endIndex - startIndex;
                }
                catch (ExecutionException ex) {
                    myLogger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new IllegalStateException("HDF5ByteGenotyeCallTable: HDF5ByteGenotypeCallTableSpliterator: forEachRemaining: Error getting base from cache: " + ex.getMessage());
                }
            }
        }

        @Override
        public Spliterator<Byte> trySplit() {
            long size = this.estimateSize();
            if (size > 65536L) {
                int loTaxa = this.myTaxaOrigin;
                int loSite = this.mySiteOrigin;
                int midTaxa = this.myTaxaOrigin;
                int midSite = this.mySiteOrigin;
                midTaxa = (int)((long)midTaxa + (size >>>= 1) / (long)this.myNumSites);
                if ((midSite = (int)((long)midSite + size % (long)this.myNumSites)) > this.myNumSites) {
                    ++midTaxa;
                    midSite -= this.myNumSites;
                }
                midSite -= midSite % 65536;
                this.myTaxaOrigin = midTaxa;
                this.mySiteOrigin = midSite;
                return new HDF5ByteGenotypeCallTableSpliterator<T>(loTaxa, loSite, this.myNumSites, midTaxa, midSite);
            }
            return null;
        }
    }

    private class SiteBlockAttr {
        private final int startSite;
        private final byte[][] myAlleleFreqOrder;
        private final int[][] myAlleleCnt;
        private final float[] maf;
        private final float[] siteCov;

        public SiteBlockAttr(int startSite, byte[][] myAlleleFreqOrder, int[][] myAlleleCnt, float[] maf, float[] siteCov) {
            this.startSite = startSite;
            this.myAlleleFreqOrder = myAlleleFreqOrder;
            this.myAlleleCnt = myAlleleCnt;
            this.maf = maf;
            this.siteCov = siteCov;
        }

        public int[][] getAllelesSortedByFrequency(int site) {
            int offset = site - this.startSite;
            int alleleCnt = 0;
            while (this.myAlleleFreqOrder[alleleCnt][offset] != 15) {
                ++alleleCnt;
            }
            int[][] result = new int[2][alleleCnt];
            for (int i = 0; i < alleleCnt; ++i) {
                result[0][i] = this.myAlleleFreqOrder[i][offset];
                result[1][i] = this.myAlleleCnt[result[0][i]][offset];
            }
            return result;
        }

        public float getMAF(int site) {
            return this.maf[site - this.startSite];
        }

        public float getSiteCoverage(int site) {
            return this.siteCov[site - this.startSite];
        }
    }
}

