/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import java.util.List;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;

public class HybridGenotypeCallTable
extends AbstractGenotypeCallTable {
    private final GenotypeCallTable myBase;
    private final int[] myFirstParents;
    private final int[] mySecondParents;

    public HybridGenotypeCallTable(GenotypeCallTable base, List<Integer> firstParents, List<Integer> secondParents) {
        super(firstParents.size(), base.numberOfSites(), base.isPhased(), base.alleleDefinitions());
        int numParents = firstParents.size();
        if (numParents != secondParents.size()) {
            throw new IllegalArgumentException("HybridGenotypeCallTable: init: number of first and second parents must be the same");
        }
        this.myFirstParents = new int[numParents];
        this.mySecondParents = new int[numParents];
        for (int i = 0; i < numParents; ++i) {
            this.myFirstParents[i] = firstParents.get(i);
            this.mySecondParents[i] = secondParents.get(i);
        }
        this.myBase = base;
    }

    @Override
    public byte genotype(int taxon, int site) {
        byte first = this.myBase.genotype(this.myFirstParents[taxon], site);
        byte second = this.myBase.genotype(this.mySecondParents[taxon], site);
        if (GenotypeTableUtils.isHomozygous(first) && GenotypeTableUtils.isHomozygous(second)) {
            return (byte)(first & 0xF0 | second & 0xF);
        }
        return -1;
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return this.myBase.diploidAsString(site, this.genotype(taxon, site));
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        return this.myBase.genotypeAsStringRange(taxon, startSite, endSite);
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return this.myBase.diploidAsString(site, value);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        this.myBase.transposeData(siteInnerLoop);
    }

    @Override
    public boolean isSiteOptimized() {
        return this.myBase.isSiteOptimized();
    }
}

