/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import net.maizegenetics.dna.snp.MaskMatrix;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.util.BitSet;

public class MaskGenotypeCallTable
extends AbstractGenotypeCallTable {
    private final GenotypeCallTable myBase;
    private final MaskMatrix myMask;

    public MaskGenotypeCallTable(GenotypeCallTable base, MaskMatrix mask) {
        super(base.numberOfTaxa(), base.numberOfSites(), base.isPhased(), base.alleleDefinitions());
        this.myBase = base;
        this.myMask = mask;
    }

    @Override
    public byte genotype(int taxon, int site) {
        if (this.myMask.get(taxon, site)) {
            return -1;
        }
        return this.myBase.genotype(taxon, site);
    }

    @Override
    public byte[] genotypeForAllTaxa(int site) {
        BitSet mask = this.myMask.maskForSite(site);
        byte[] result = this.myBase.genotypeForAllTaxa(site);
        for (int t = 0; t < this.numberOfTaxa(); ++t) {
            if (!mask.fastGet(t)) continue;
            result[t] = -1;
        }
        return result;
    }

    @Override
    public byte[] genotypeForAllSites(int taxon) {
        BitSet mask = this.myMask.maskForTaxon(taxon);
        byte[] result = this.myBase.genotypeForAllSites(taxon);
        for (int s = 0; s < this.numberOfSites(); ++s) {
            if (!mask.fastGet(s)) continue;
            result[s] = -1;
        }
        return result;
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return this.myBase.diploidAsString(site, this.genotype(taxon, site));
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        StringBuilder builder = new StringBuilder();
        for (int i = startSite; i < endSite; ++i) {
            builder.append(this.genotypeAsString(taxon, i));
        }
        return builder.toString();
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return this.myBase.diploidAsString(site, value);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        this.myBase.transposeData(siteInnerLoop);
    }

    @Override
    public boolean isSiteOptimized() {
        return this.myBase.isSiteOptimized();
    }
}

