/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class MaskedGenotypes {
    private final int myNumTaxa;
    private final int myNumSites;
    private final BitSet[] myMasks;

    public MaskedGenotypes(int numTaxa, int numSites) {
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
        this.myMasks = new BitSet[this.myNumTaxa];
        for (int t = 0; t < this.myNumTaxa; ++t) {
            this.myMasks[t] = new OpenBitSet(this.myNumSites);
        }
    }

    public void set(int taxon, int site) {
        this.myMasks[taxon].fastSet(site);
    }

    public boolean get(int taxon, int site) {
        return this.myMasks[taxon].fastGet(site);
    }
}

