/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import java.util.function.BiFunction;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;

public class MergedGenotypeCallTable
extends AbstractGenotypeCallTable {
    private final GenotypeCallTable[] myGenotypeCallTables;
    private int[][] taxonMap;
    private int[][] positionMap;
    private BiFunction<Integer, Integer, Byte> mergeCallFunction;

    private MergedGenotypeCallTable(GenotypeCallTable[] genotypeCallTables, int numTaxa, int numSites, boolean phased, String[][] alleleEncodings, int maxNumAlleles, int[][] taxonMap, int[][] positionMap) {
        super(numTaxa, numSites, phased, alleleEncodings, maxNumAlleles);
        this.myGenotypeCallTables = genotypeCallTables;
        this.taxonMap = taxonMap;
        this.positionMap = positionMap;
        this.mergeCallFunction = (taxon, site) -> this.myGenotypeCallTables[0].genotype(taxonMap[taxon][0], positionMap[site][0]);
    }

    public static GenotypeCallTable getInstance(GenotypeCallTable[] genotypeCallTables, int[][] taxonMap, int[][] positionMap) {
        String[][] alleleStates;
        if (genotypeCallTables == null || genotypeCallTables.length == 0) {
            throw new IllegalArgumentException("CombineGenotypeCallTable: getInstance: must provide genotype call tables.");
        }
        if (genotypeCallTables.length == 1) {
            return genotypeCallTables[0];
        }
        boolean allTheSame = true;
        String[][] encodings = genotypeCallTables[0].alleleDefinitions();
        if (encodings.length == 1) {
            for (int i = 1; i < genotypeCallTables.length; ++i) {
                String[][] current = genotypeCallTables[i].alleleDefinitions();
                if (current.length != 1 || encodings[0].length != current[0].length) {
                    allTheSame = false;
                    break;
                }
                for (int j = 0; j < encodings[0].length; ++j) {
                    if (current[0][j].equals(encodings[0][j])) continue;
                    allTheSame = false;
                    break;
                }
                if (allTheSame) {
                    continue;
                }
                break;
            }
        } else {
            allTheSame = false;
        }
        int totalSites = positionMap.length;
        if (allTheSame) {
            alleleStates = encodings;
        } else {
            String[][] result = new String[totalSites][];
            int count = 0;
            for (int i = 0; i < genotypeCallTables.length; ++i) {
                int n = genotypeCallTables[i].numberOfSites();
                for (int j = 0; j < n; ++j) {
                    result[count++] = genotypeCallTables[i].alleleDefinitions(j);
                }
            }
            alleleStates = result;
        }
        int numTaxa = taxonMap.length;
        boolean phased = genotypeCallTables[0].isPhased();
        int maxNumAlleles = genotypeCallTables[0].maxNumAlleles();
        for (int i = 1; i < genotypeCallTables.length; ++i) {
            if (phased != genotypeCallTables[i].isPhased()) {
                throw new IllegalArgumentException("CombineGenotypeCallTable: getInstance: phase is different.");
            }
            if (maxNumAlleles == genotypeCallTables[i].maxNumAlleles()) continue;
            throw new IllegalArgumentException("CombineGenotypeCallTable: getInstance: max number of alleles is different.");
        }
        return new MergedGenotypeCallTable(genotypeCallTables, numTaxa, totalSites, phased, alleleStates, maxNumAlleles, taxonMap, positionMap);
    }

    @Override
    public byte genotype(int taxon, int site) {
        return this.myGenotypeCallTables[0].genotype(this.taxonMap[taxon][0], this.positionMap[site][0]);
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return this.myGenotypeCallTables[0].genotypeAsString(this.taxonMap[taxon][0], this.positionMap[site][0]);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSiteOptimized() {
        return this.myGenotypeCallTables[0].isSiteOptimized();
    }

    @Override
    public byte[] genotypeArray(int taxon, int site) {
        return GenotypeTableUtils.getDiploidValues(this.genotype(taxon, site));
    }
}

