/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import net.maizegenetics.dna.snp.genotypecall.GenotypeMergeRule;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;

public class SetToNGenotypeMergeRule
implements GenotypeMergeRule {
    @Override
    public boolean isMergePossible() {
        return true;
    }

    @Override
    public byte mergeCalls(byte geno1, byte geno2) {
        if (geno1 == geno2) {
            return geno1;
        }
        if (geno1 == -1) {
            return geno2;
        }
        if (geno2 == -1) {
            return geno1;
        }
        return -1;
    }

    @Override
    public byte[] mergeWithDepth(byte[] geno1depths, byte[] geno2depths) {
        if (geno1depths.length != geno2depths.length) {
            throw new IllegalStateException("Depth arrays must be same length");
        }
        byte[] result = new byte[geno1depths.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AlleleDepthUtil.addByteDepths(geno1depths[i], geno2depths[i]);
        }
        return result;
    }

    @Override
    public byte callBasedOnDepth(byte[] genoDepths) {
        return this.callBasedOnDepth(AlleleDepthUtil.depthByteToInt(genoDepths));
    }

    @Override
    public byte callBasedOnDepth(int[] genoDepths) {
        int max = 0;
        int maxAllele = 15;
        int nextMax = 0;
        int nextMaxAllele = 15;
        for (int a = 0; a < genoDepths.length; ++a) {
            if (genoDepths[a] > max) {
                nextMax = max;
                nextMaxAllele = maxAllele;
                max = genoDepths[a];
                maxAllele = (byte)a;
                continue;
            }
            if (genoDepths[a] <= nextMax) continue;
            nextMax = genoDepths[a];
            nextMaxAllele = (byte)a;
        }
        if (nextMaxAllele == 15) {
            return (byte)(maxAllele << 4 | maxAllele);
        }
        return -1;
    }
}

