/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import com.google.common.collect.SetMultimap;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.util.ParsingUtils;
import java.io.File;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.LineIndexHapmapGenotypeCallTable;
import net.maizegenetics.dna.snp.io.BuilderFromHapMap;
import net.maizegenetics.dna.snp.io.LineIndex;
import net.maizegenetics.dna.snp.io.LineIndexBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class BuilderFromHapMapLIX {
    private static final Logger myLogger = Logger.getLogger(BuilderFromHapMapLIX.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final int NUM_HAPMAP_NON_TAXA_HEADERS = 11;
    private static final int SNPID_INDEX = 0;
    private static final int VARIANT_INDEX = 1;
    private static final int CHROMOSOME_INDEX = 2;
    private static final int POSITION_INDEX = 3;

    private BuilderFromHapMapLIX() {
    }

    public static GenotypeTable build(String hapmapFileBGZip) {
        return BuilderFromHapMapLIX.build(hapmapFileBGZip, ParsingUtils.appendToPath((String)hapmapFileBGZip, (String)".lix"));
    }

    public static GenotypeTable build(String hapmapFileBGZip, String indexFilename) {
        boolean isOneLetter;
        TaxaList taxaList;
        PositionList positionList;
        Tuple<LineIndex, String[]> indexPositionInfo;
        block24: {
            indexPositionInfo = LineIndexBuilder.readIndex(indexFilename);
            HashMap<String, Chromosome> chromosomeLookup = new HashMap<String, Chromosome>();
            PositionListBuilder positions = new PositionListBuilder();
            for (String current : (String[])indexPositionInfo.y) {
                int physicalPos;
                String[] tokens = current.split("\t");
                String chrName = tokens[2];
                Chromosome currChr = (Chromosome)chromosomeLookup.get(chrName);
                if (currChr == null) {
                    currChr = new Chromosome(new String(chrName));
                    chromosomeLookup.put(chrName, currChr);
                }
                String variants = tokens[1];
                try {
                    physicalPos = Integer.parseInt(tokens[3]);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("BuilderFromHapMapLIX: Position must be an integer: " + tokens[3]);
                }
                GeneralPosition.Builder positionBuilder = new GeneralPosition.Builder(currChr, physicalPos).snpName(tokens[0]).knownVariants(variants);
                byte glbMajor = NucleotideAlignmentConstants.getNucleotideDiploidByte(variants.charAt(0));
                positionBuilder.allele(WHICH_ALLELE.GlobalMajor, glbMajor);
                if (variants.length() == 3) {
                    byte glbMinor = NucleotideAlignmentConstants.getNucleotideDiploidByte(variants.charAt(2));
                    positionBuilder.allele(WHICH_ALLELE.GlobalMinor, glbMinor);
                }
                positions.add(positionBuilder.build());
            }
            positionList = positions.build();
            taxaList = null;
            isOneLetter = false;
            try (BlockCompressedInputStream reader = new BlockCompressedInputStream(new File(hapmapFileBGZip));){
                TreeMap<String, SetMultimap<String, String>> sampAnnoBuild = new TreeMap<String, SetMultimap<String, String>>();
                String currLine = reader.readLine();
                while (currLine != null && currLine.startsWith("##")) {
                    SetMultimap<String, String> mapOfAnno;
                    String taxaID;
                    String[] cat = currLine.split("=", 2);
                    if (cat.length < 2) continue;
                    if (cat[0].startsWith("##SAMPLE") && (taxaID = (String)(mapOfAnno = TaxaListIOUtils.parseVCFHeadersIntoMap(cat[1])).get((Object)"ID").iterator().next()) != null) {
                        sampAnnoBuild.put(taxaID, mapOfAnno);
                    }
                    currLine = reader.readLine();
                }
                taxaList = BuilderFromHapMap.processTaxa(currLine, sampAnnoBuild).build();
                int numTaxa = taxaList.numberOfTaxa();
                currLine = reader.readLine();
                String[] tokens = WHITESPACE_PATTERN.split(currLine, 12);
                if (tokens.length <= 11) {
                    throw new IllegalStateException("BuilderFromHapMapLIX: Header Incorrectly Formatted: See:\nhttps://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/Load/Load#markdown-header-hapmap");
                }
                double avg = (double)(tokens[11].length() + 1) / (double)numTaxa;
                if (avg > 1.99 && avg < 2.01) {
                    isOneLetter = true;
                    break block24;
                }
                if (avg > 2.99 && avg < 3.01) {
                    isOneLetter = false;
                    break block24;
                }
                throw new IllegalStateException("BuilderFromHapMapLIX: Genotype coded wrong use 1 or 2 letters per genotype.  Or first site has incorrect number of values.");
            }
            catch (Exception e) {
                throw new IllegalStateException("BuilderFromHapMapLIX: Problem opening file: " + hapmapFileBGZip + "\n" + e.getMessage());
            }
        }
        return GenotypeTableBuilder.getInstance(LineIndexHapmapGenotypeCallTable.getInstance(taxaList.numberOfTaxa(), positionList.numberOfSites(), false, isOneLetter, (LineIndex)indexPositionInfo.x, hapmapFileBGZip), positionList, taxaList);
    }
}

