/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class BuilderFromPLINK {
    private static final Logger myLogger = Logger.getLogger(BuilderFromPLINK.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final int NUM_PLINK_NON_SITE_HEADERS = 6;
    private final String myPedFile;
    private final String myMapFile;
    private final ProgressListener myProgressListener;
    private boolean mySortTaxaAlphabetically = false;
    private boolean mySortPositions = false;
    private static final int PLINK_MAP_CHROMOSOME_INDEX = 0;
    private static final int PLINK_MAP_SND_ID_INDEX = 1;
    private static final int PLINK_MAP_GENETIC_DISTANCE_INDEX = 2;
    private static final int PLINK_MAP_POSITION_INDEX = 3;
    private static final int NUM_PLINK_MAP_COLUMNS = 4;
    private static final int PLINK_PED_FAMILY_ID_INDEX = 0;
    private static final int PLINK_PED_INDIVIDUAL_ID_INDEX = 1;
    private static final int PLINK_PED_PATERNAL_ID_INDEX = 2;
    private static final int PLINK_PED_MATERNAL_ID_INDEX = 3;
    private static final int PLINK_PED_SEX_INDEX = 4;
    private static final int PLINK_PED_PHENOTYPE_INDEX = 5;
    private static final Map<String, Byte> PLINK_ALLELE_HASH = new HashMap<String, Byte>();
    private static final byte[] PLINK_ALLELE_ARRAY = new byte[256];

    private BuilderFromPLINK(String pedfile, String mapfile, ProgressListener listener) {
        this.myPedFile = pedfile;
        this.myMapFile = mapfile;
        this.myProgressListener = listener;
    }

    public static BuilderFromPLINK getBuilder(String pedfile, String mapfile, ProgressListener listener) {
        return new BuilderFromPLINK(pedfile, mapfile, listener);
    }

    /*
     * WARNING - void declaration
     */
    public GenotypeTable build() {
        GenotypeTable result = null;
        try {
            int numThreads = Runtime.getRuntime().availableProcessors();
            ExecutorService pool = Executors.newFixedThreadPool(numThreads);
            myLogger.info((Object)("Reading: " + this.myPedFile + " and " + this.myMapFile));
            PositionListBuilder posBuild = BuilderFromPLINK.processSites(this.myMapFile);
            myLogger.info((Object)("Number of sites: " + posBuild.size()));
            int numOfTaxa = Utils.getNumberLinesNotHashOrBlank(this.myPedFile);
            myLogger.info((Object)("Number of taxa: " + numOfTaxa));
            GenotypeCallTableBuilder genotypeCallTableBuilder = GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(numOfTaxa, posBuild.size());
            int linesAtTime = (int)Math.ceil(0x1000000 / posBuild.size());
            ArrayList<void> textLines = new ArrayList<void>(linesAtTime);
            ArrayList<Future<ProcessPLINKBlock>> futures = new ArrayList<Future<ProcessPLINKBlock>>();
            int numLines = 0;
            BufferedReader reader = Utils.getBufferedReader(this.myPedFile);
            Object object = null;
            try {
                void var13_15;
                String string = reader.readLine();
                while (var13_15 != null) {
                    textLines.add(var13_15);
                    if (++numLines % linesAtTime == 0) {
                        ProcessPLINKBlock processBlock = new ProcessPLINKBlock(textLines, genotypeCallTableBuilder, numLines - linesAtTime, numLines * 100 / numOfTaxa);
                        futures.add(pool.submit(processBlock));
                        textLines = new ArrayList(linesAtTime);
                    }
                    String string2 = reader.readLine();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            if (textLines.size() > 0) {
                ProcessPLINKBlock processBlock = new ProcessPLINKBlock(textLines, genotypeCallTableBuilder, numLines - textLines.size(), 100);
                futures.add(pool.submit(processBlock));
            }
            TaxaListBuilder taxaBuild = new TaxaListBuilder();
            for (Future future : futures) {
                ProcessPLINKBlock pb = (ProcessPLINKBlock)future.get();
                taxaBuild.addAll((Collection<Taxon>)pb.getBlockTaxa());
            }
            TaxaList taxaList = taxaBuild.build();
            pool.shutdown();
            if (!posBuild.validateOrdering()) {
                if (this.mySortPositions) {
                    posBuild.sortPositions(genotypeCallTableBuilder);
                    if (!posBuild.validateOrdering()) {
                        throw new IllegalStateException("BuilderFromPLINK: Ordering of PLINK failed.");
                    }
                } else {
                    throw new IllegalStateException("BuilderFromPLINK: Ordering incorrect. PLINK must be ordered by position.");
                }
            }
            GenotypeCallTable genotypeCallTable = genotypeCallTableBuilder.build();
            result = GenotypeTableBuilder.getInstance(genotypeCallTable, posBuild.build(), taxaList);
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("BuilderFromPLINK: build: problem processing: " + e.getMessage());
        }
        return result;
    }

    public BuilderFromPLINK sortTaxa() {
        this.mySortTaxaAlphabetically = true;
        return this;
    }

    public BuilderFromPLINK sortPositions() {
        this.mySortPositions = true;
        return this;
    }

    private static PositionListBuilder processSites(String mapfile) {
        HashMap<String, Chromosome> chromosomes = new HashMap<String, Chromosome>();
        ArrayList<GeneralPosition> positions = new ArrayList<GeneralPosition>();
        int lineNum = 1;
        try (BufferedReader reader = Utils.getBufferedReader(mapfile);){
            String line = reader.readLine();
            while (line != null) {
                String[] tokens = WHITESPACE_PATTERN.split(line);
                if (tokens.length < 4) {
                    throw new IllegalStateException("BuilderFromPLINK: processSites: Not all columns defined line : \"" + line + "\" of file: " + mapfile);
                }
                Chromosome chr = (Chromosome)chromosomes.get(tokens[0]);
                if (chr == null) {
                    chr = Chromosome.instance(new String(tokens[0]));
                    chromosomes.put(tokens[0], chr);
                }
                GeneralPosition current = new GeneralPosition.Builder(chr, Integer.parseInt(tokens[3])).snpName(new String(tokens[1])).build();
                positions.add(current);
                line = reader.readLine();
                ++lineNum;
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("BuilderFromPLINK: processSites: problem with: " + mapfile + " line: " + lineNum);
        }
        PositionListBuilder result = new PositionListBuilder();
        result.addAll(positions);
        return result;
    }

    public static byte getPLINKAlleleByte(char value) {
        try {
            return PLINK_ALLELE_ARRAY[value];
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("BuilderFromPLINK: getPLINKAlleleByte: unknown allele value: " + value);
        }
    }

    static {
        PLINK_ALLELE_HASH.put("A", (byte)0);
        PLINK_ALLELE_HASH.put("C", (byte)1);
        PLINK_ALLELE_HASH.put("G", (byte)2);
        PLINK_ALLELE_HASH.put("T", (byte)3);
        PLINK_ALLELE_HASH.put("+", (byte)4);
        PLINK_ALLELE_HASH.put("-", (byte)5);
        PLINK_ALLELE_HASH.put("N", (byte)15);
        PLINK_ALLELE_HASH.put("0", (byte)15);
        PLINK_ALLELE_HASH.put("1", (byte)0);
        PLINK_ALLELE_HASH.put("2", (byte)1);
        PLINK_ALLELE_HASH.put("3", (byte)2);
        PLINK_ALLELE_HASH.put("4", (byte)3);
        Arrays.fill(PLINK_ALLELE_ARRAY, (byte)6);
        for (Map.Entry<String, Byte> en : PLINK_ALLELE_HASH.entrySet()) {
            BuilderFromPLINK.PLINK_ALLELE_ARRAY[en.getKey().charAt((int)0)] = en.getValue();
        }
    }

    private class ProcessPLINKBlock
    implements Callable<ProcessPLINKBlock> {
        private final int myNumTaxaToProcess;
        private ArrayList<String> myTextLines;
        private final ArrayList<Taxon> myBlockTaxaList;
        private final GenotypeCallTableBuilder myBuilder;
        private final int myStartTaxon;
        private final int myProgress;

        private ProcessPLINKBlock(ArrayList<String> textLines, GenotypeCallTableBuilder builder, int startTaxon, int progress) {
            this.myNumTaxaToProcess = textLines.size();
            this.myTextLines = textLines;
            this.myBlockTaxaList = new ArrayList(this.myNumTaxaToProcess);
            this.myBuilder = builder;
            this.myStartTaxon = startTaxon;
            this.myProgress = progress;
        }

        @Override
        public ProcessPLINKBlock call() throws Exception {
            for (int t = 0; t < this.myNumTaxaToProcess; ++t) {
                String input = this.myTextLines.get(t);
                try {
                    String[] tokens = WHITESPACE_PATTERN.split(input, 7);
                    String taxonName = new String(tokens[1].trim());
                    Taxon taxon = new Taxon.Builder(taxonName).build();
                    this.myBlockTaxaList.add(taxon);
                    int taxonIndex = t + this.myStartTaxon;
                    int n = tokens[6].length();
                    for (int i = 0; i < n; i += 4) {
                        this.myBuilder.setBase(taxonIndex, i / 4, GenotypeTableUtils.getDiploidValue(BuilderFromPLINK.getPLINKAlleleByte(tokens[6].charAt(i)), BuilderFromPLINK.getPLINKAlleleByte(tokens[6].charAt(i + 2))));
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    myLogger.debug((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("BuilderFromPLINK: ProcessPLINKBlock: problem: to many genotypes in file: " + BuilderFromPLINK.this.myPedFile + " line: " + input.substring(0, Math.min(input.length(), 50)));
                }
                catch (Exception e) {
                    myLogger.debug((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("BuilderFromPLINK: ProcessPLINKBlock: problem: " + e.getMessage() + " file: " + BuilderFromPLINK.this.myPedFile + " line: " + input.substring(0, Math.min(input.length(), 50)));
                }
            }
            this.myTextLines = null;
            if (BuilderFromPLINK.this.myProgressListener != null) {
                BuilderFromPLINK.this.myProgressListener.progress(this.myProgress, null);
            }
            return this;
        }

        List<Taxon> getBlockTaxa() {
            return this.myBlockTaxaList;
        }
    }
}

