/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.LittleEndianOutputStream;
import htsjdk.tribble.util.ParsingUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.maizegenetics.dna.snp.io.LineIndex;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class LineIndexBuilder {
    private static final Logger myLogger = Logger.getLogger(LineIndexBuilder.class);
    public static final String LINE_INDEX_FILE_EXTENSION = ".lix";
    private static final byte[] MAGIC = new byte[]{76, 73, 88, 1};
    public static final int MAGIC_NUMBER;
    private char myCommentChar = (char)35;
    private int myNumHeaderLinesToSkip = 1;
    private int myNumColumnsPerRowToKeepInIndex = 0;
    private final String myFileToIndex;
    private final String myIdxFilename;

    public LineIndexBuilder(String fileToIndex) {
        this.myFileToIndex = fileToIndex;
        this.myIdxFilename = ParsingUtils.appendToPath((String)fileToIndex, (String)LINE_INDEX_FILE_EXTENSION);
    }

    public LineIndexBuilder commentChar(char commentChar) {
        this.myCommentChar = commentChar;
        return this;
    }

    public LineIndexBuilder numHeaderLinesToSkip(int numLines) {
        this.myNumHeaderLinesToSkip = numLines;
        return this;
    }

    public LineIndexBuilder numColumnsPerRowToKeepInIndex(int numColumns) {
        this.myNumColumnsPerRowToKeepInIndex = numColumns;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tuple<LineIndex, String[]> readIndex(String idxFilename) {
        try (LittleEndianInputStream input = new LittleEndianInputStream((InputStream)new BlockCompressedInputStream(new File(idxFilename)));){
            int magic = input.readInt();
            int commentChar = input.readInt();
            int numHeaderLinesToSkip = input.readInt();
            int numLinesPerInterval = input.readInt();
            int numRowsWithSavedColumns = input.readInt();
            String[] savedColumns = new String[numRowsWithSavedColumns];
            for (int i = 0; i < numRowsWithSavedColumns; ++i) {
                savedColumns[i] = input.readString();
            }
            int numVirtualFileOffsets = input.readInt();
            long[] virtualFileOffsets = new long[numVirtualFileOffsets];
            for (int i = 0; i < numVirtualFileOffsets; ++i) {
                virtualFileOffsets[i] = input.readLong();
            }
            LineIndex index = new LineIndex(magic, (char)commentChar, numHeaderLinesToSkip, numLinesPerInterval, virtualFileOffsets);
            Tuple<LineIndex, String[]> tuple = new Tuple<LineIndex, String[]>(index, savedColumns);
            return tuple;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void build() {
        try (LittleEndianOutputStream output = new LittleEndianOutputStream((OutputStream)new BlockCompressedOutputStream(this.myIdxFilename));){
            output.writeInt(MAGIC_NUMBER);
            output.writeInt((int)this.myCommentChar);
            output.writeInt(this.myNumHeaderLinesToSkip);
            output.writeInt(10);
            try (BlockCompressedInputStream input = new BlockCompressedInputStream(new File(this.myFileToIndex));){
                boolean notFinished = true;
                int linesSkipped = 0;
                while (notFinished) {
                    String str = input.readLine();
                    if (str.charAt(0) != this.myCommentChar) {
                        ++linesSkipped;
                    }
                    if (this.myNumHeaderLinesToSkip > linesSkipped) continue;
                    notFinished = false;
                }
                ArrayList<Long> virtualFileOffsets = new ArrayList<Long>();
                ArrayList<String> beginningColumnsPerRow = new ArrayList<String>();
                notFinished = true;
                block24: while (notFinished) {
                    virtualFileOffsets.add(input.getFilePointer());
                    for (int i = 0; i < 10; ++i) {
                        String string = input.readLine();
                        if (string == null) {
                            notFinished = false;
                            continue block24;
                        }
                        if (this.myNumColumnsPerRowToKeepInIndex <= 0) continue;
                        int n = this.myNumColumnsPerRowToKeepInIndex - 1;
                        int pos = string.indexOf(9);
                        while (n-- > 0 && pos != -1) {
                            pos = string.indexOf(9, pos + 1);
                        }
                        if (pos == -1) {
                            throw new IllegalStateException("LineIndexBuilder: build: " + this.myNumColumnsPerRowToKeepInIndex + " columns not found.");
                        }
                        beginningColumnsPerRow.add(string.substring(0, pos));
                    }
                }
                output.writeInt(beginningColumnsPerRow.size());
                for (String string : beginningColumnsPerRow) {
                    output.writeString(string);
                }
                output.writeInt(virtualFileOffsets.size());
                for (Long l : virtualFileOffsets) {
                    output.writeLong(l.longValue());
                }
            }
            catch (SAMFormatException se) {
                myLogger.debug((Object)se.getMessage(), (Throwable)se);
                throw new IllegalStateException("LineIndexBuilder: build: this file is not bgzipped: " + this.myFileToIndex + ": " + se.getMessage());
            }
            catch (Exception ex) {
                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                throw new IllegalStateException("LineIndexBuilder: build: problem creating index for file: " + this.myFileToIndex + ": " + ex.getMessage());
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("LineIndexBuilder: build: problem writing index file: " + this.myIdxFilename + ": " + e.getMessage());
        }
    }

    public static void buildHapmapIndex(String filename) {
        new LineIndexBuilder(filename).commentChar('#').numHeaderLinesToSkip(1).numColumnsPerRowToKeepInIndex(11).build();
    }

    static {
        ByteBuffer bb = ByteBuffer.allocate(MAGIC.length);
        bb.put(MAGIC);
        bb.flip();
        MAGIC_NUMBER = bb.order(ByteOrder.LITTLE_ENDIAN).getInt();
    }
}

