/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import java.io.BufferedWriter;
import java.text.NumberFormat;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.ReferenceProbability;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class SiteScoresIO {
    private static final Logger myLogger = Logger.getLogger(SiteScoresIO.class);
    private static final String DELIMITER = "\t";
    private static final NumberFormat DECIMAL_FORMAT = NumberFormat.getNumberInstance();

    private SiteScoresIO() {
    }

    public static String writeReferenceProbability(GenotypeTable genotypeTable, String filename) {
        filename = Utils.addSuffixIfNeeded(filename, ".txt");
        ReferenceProbability probability = genotypeTable.referenceProbability();
        if (probability == null) {
            throw new IllegalStateException("SiteScoresIO: writeReferenceProbability: this genotype table has no reference probability.");
        }
        try (BufferedWriter writer = Utils.getBufferedWriter(filename);){
            writer.write("<Numeric>\n");
            writer.write("<Marker>");
            PositionList positions = genotypeTable.positions();
            for (Position current : positions) {
                writer.write(DELIMITER);
                writer.write(current.getSNPID());
            }
            writer.write("\n");
            TaxaList taxa = genotypeTable.taxa();
            int n = probability.numTaxa();
            for (int r = 0; r < n; ++r) {
                writer.write(((Taxon)taxa.get(r)).getName());
                for (int i = 0; i < probability.numSites(); ++i) {
                    writer.write(DELIMITER);
                    float value = probability.value(r, i);
                    if (Float.isNaN(value)) {
                        writer.write("NA");
                        continue;
                    }
                    writer.write(DECIMAL_FORMAT.format(probability.value(r, i)));
                }
                writer.write("\n");
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("SiteScoresIO: writeReferenceProbability: problem saving file: " + filename);
        }
        return filename;
    }

    public static String writeDepth(GenotypeTable genotypeTable, String filename) {
        filename = Utils.addSuffixIfNeeded(filename, ".txt");
        AlleleDepth depth = genotypeTable.depth();
        if (depth == null) {
            throw new IllegalStateException("SiteScoresIO: writeDepth: this genotype table has no depth.");
        }
        try (BufferedWriter writer = Utils.getBufferedWriter(filename);){
            writer.write("Taxa");
            PositionList positions = genotypeTable.positions();
            for (Position current : positions) {
                writer.write(DELIMITER);
                writer.write(current.getSNPID());
            }
            writer.write("\n");
            TaxaList taxa = genotypeTable.taxa();
            int n = depth.numTaxa();
            for (int t = 0; t < n; ++t) {
                writer.write(((Taxon)taxa.get(t)).getName());
                int m = depth.numSites();
                for (int s = 0; s < m; ++s) {
                    byte allele2;
                    byte genotype = genotypeTable.genotype(t, s);
                    writer.write(DELIMITER);
                    int value = 0;
                    byte allele1 = (byte)(genotype >>> 4 & 0xF);
                    if (allele1 < 6) {
                        value = depth.depthForAllele(t, s, allele1);
                    }
                    if ((allele2 = (byte)(genotype & 0xF)) < 6 && allele2 != allele1) {
                        value += depth.depthForAllele(t, s, allele2);
                    }
                    writer.write(String.valueOf(value));
                }
                writer.write("\n");
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("SiteScoresIO: writeDepth: problem saving file: " + filename);
        }
        return filename;
    }

    static {
        DECIMAL_FORMAT.setMaximumFractionDigits(3);
    }
}

