/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import com.google.common.primitives.Ints;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class VCFUtil {
    private static final Logger myLogger = Logger.getLogger(VCFUtil.class);
    private static double error = 0.001;
    private static double v1 = Math.log10(1.0 - error * 3.0 / 4.0);
    private static double v2 = Math.log10(error / 4.0);
    private static double v3 = Math.log10(0.5 - error / 4.0);
    private static int[][][] myGenoScoreMap = new int[128][128][];
    public static final int VCF_DEFAULT_MAX_NUM_ALLELES = 3;

    private VCFUtil() {
    }

    public static int[] getScore(int i, int j) {
        if (i > 127 || j > 127) {
            return VCFUtil.calcScore(i, j);
        }
        return myGenoScoreMap[i][j];
    }

    private static int[] calcScore(int a, int b) {
        int[] results = new int[4];
        int n = a + b;
        int m = a;
        if (b > m) {
            m = b;
        }
        double fact = 0.0;
        if (n > m) {
            int i;
            for (i = n; i > m; --i) {
                fact += Math.log10(i);
            }
            for (i = 1; i <= n - m; ++i) {
                fact -= Math.log10(i);
            }
        }
        double aad = Math.pow(10.0, fact + (double)a * v1 + (double)b * v2);
        double abd = Math.pow(10.0, fact + (double)n * v3);
        double bbd = Math.pow(10.0, fact + (double)b * v1 + (double)a * v2);
        double md = aad;
        if (md < abd) {
            md = abd;
        }
        if (md < bbd) {
            md = bbd;
        }
        int gq = 0;
        if (aad + abd + bbd > 0.0) {
            gq = (int)(md / (aad + abd + bbd) * 100.0);
        }
        int aa = (int)(-10.0 * (fact + (double)a * v1 + (double)b * v2));
        int ab = (int)(-10.0 * (fact + (double)n * v3));
        int bb = (int)(-10.0 * (fact + (double)b * v1 + (double)a * v2));
        m = aa;
        if (m > ab) {
            m = ab;
        }
        if (m > bb) {
            m = bb;
        }
        results[0] = (aa -= m) > 255 ? 255 : aa;
        results[1] = ab > 255 ? 255 : (ab -= m);
        results[2] = bb > 255 ? 255 : (bb -= m);
        results[3] = gq;
        return results;
    }

    public static byte resolveVCFGeno(byte[] alleles, int[][] allelesInTaxa, int tx) {
        int[] alleleDepth = new int[allelesInTaxa.length];
        for (int i = 0; i < allelesInTaxa.length; ++i) {
            alleleDepth[i] = allelesInTaxa[i][tx];
        }
        return VCFUtil.resolveVCFGeno(alleles, alleleDepth);
    }

    public static byte resolveVCFGeno(byte[] alleles, int[] alleleDepth) {
        int depth = 0;
        for (int i = 0; i < alleleDepth.length; ++i) {
            depth += alleleDepth[i];
        }
        if (depth == 0) {
            return -1;
        }
        int max = 0;
        int maxAllele = 15;
        int nextMax = 0;
        int nextMaxAllele = 15;
        for (int i = 0; i < alleles.length; ++i) {
            if (alleleDepth[i] > max) {
                nextMax = max;
                nextMaxAllele = maxAllele;
                max = alleleDepth[i];
                maxAllele = alleles[i];
                continue;
            }
            if (alleleDepth[i] <= nextMax) continue;
            nextMax = alleleDepth[i];
            nextMaxAllele = alleles[i];
        }
        if (alleles.length == 1) {
            return (byte)(alleles[0] << 4 | alleles[0]);
        }
        int[] scores = VCFUtil.getScore(max = max > 127 ? 127 : max, nextMax = nextMax > 127 ? 127 : nextMax);
        if (scores[1] <= scores[0] && scores[1] <= scores[2]) {
            return (byte)(maxAllele << 4 | nextMaxAllele);
        }
        if (scores[0] <= scores[1] && scores[0] <= scores[2]) {
            return (byte)(maxAllele << 4 | maxAllele);
        }
        return (byte)(nextMaxAllele << 4 | nextMaxAllele);
    }

    public static int[] resolveRefSorted(int[] sortedAlleles, byte refAllele) {
        int[] sortedAllelesResolved = new int[sortedAlleles.length];
        int indexOfRefAllele = Ints.indexOf((int[])sortedAlleles, (int)refAllele);
        if (indexOfRefAllele < 0) {
            indexOfRefAllele = 0;
            if (refAllele != 15) {
                int[] sortedAllelesExpanded = new int[sortedAlleles.length + 1];
                sortedAllelesExpanded[0] = refAllele;
                for (int i = 0; i < sortedAlleles.length; ++i) {
                    sortedAllelesExpanded[i + 1] = sortedAlleles[i];
                }
                sortedAllelesResolved = sortedAllelesExpanded;
            } else {
                for (int i = 0; i < sortedAllelesResolved.length; ++i) {
                    sortedAllelesResolved[i] = sortedAlleles[i];
                }
            }
        } else if (indexOfRefAllele != 0) {
            int i;
            sortedAllelesResolved[0] = refAllele;
            for (i = indexOfRefAllele; i > 0; --i) {
                sortedAllelesResolved[i] = sortedAlleles[i - 1];
            }
            for (i = indexOfRefAllele + 1; i < sortedAllelesResolved.length; ++i) {
                sortedAllelesResolved[i] = sortedAlleles[i];
            }
        } else {
            for (int i = 0; i < sortedAllelesResolved.length; ++i) {
                sortedAllelesResolved[i] = sortedAlleles[i];
            }
        }
        return sortedAllelesResolved;
    }

    public static boolean indelInKnownVariant(String[] knownVariants) {
        for (String variant : knownVariants) {
            if (variant.length() <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean indelMinusInKnownVariant(String[] knownVariants) {
        for (String variant : knownVariants) {
            if (!variant.equals("-") && !variant.equals("+")) continue;
            return true;
        }
        return false;
    }

    public static Tuple<int[], String[]> resolveSortedAndKnownVariantsExport(int[] sortedAllelesInput, String[] knownVariantsInput) {
        int[] sortedAlleles = Arrays.copyOf(sortedAllelesInput, sortedAllelesInput.length);
        String[] knownVariants = Arrays.copyOf(knownVariantsInput, knownVariantsInput.length);
        if (knownVariants.length > 0) {
            ArrayList<Integer> tempSortedAlleles = new ArrayList<Integer>();
            boolean knownVariantIndel = VCFUtil.indelInKnownVariant(knownVariants);
            if (knownVariantIndel) {
                for (int i = 0; i < knownVariants.length; ++i) {
                    if (knownVariants[i].length() > 1) {
                        String parsedVariant = knownVariants[i].substring(1);
                        tempSortedAlleles.add(Integer.valueOf(NucleotideAlignmentConstants.getNucleotideAlleleByte(parsedVariant.charAt(0))));
                        continue;
                    }
                    tempSortedAlleles.add(Integer.valueOf(NucleotideAlignmentConstants.getNucleotideAlleleByte('-')));
                }
            } else {
                if (sortedAlleles.length < knownVariants.length) {
                    tempSortedAlleles = new ArrayList();
                }
                int nIndex = -1;
                for (int i = 0; i < knownVariants.length; ++i) {
                    if (knownVariants[i].charAt(0) != 'N') {
                        tempSortedAlleles.add(Integer.valueOf(NucleotideAlignmentConstants.getNucleotideAlleleByte(knownVariants[i].charAt(0))));
                        continue;
                    }
                    nIndex = i;
                }
                if (nIndex != -1) {
                    String[] knownVariantsSmall = new String[knownVariants.length - 1];
                    for (int i = 0; i < knownVariants.length; ++i) {
                        if (i < nIndex) {
                            knownVariantsSmall[i] = knownVariants[i];
                            continue;
                        }
                        if (i <= nIndex) continue;
                        knownVariantsSmall[i - 1] = knownVariants[i];
                    }
                    knownVariants = knownVariantsSmall;
                }
            }
            ArrayList<String> knownVariantsList = new ArrayList<String>();
            boolean indelsExist = false;
            boolean indelsInKnownVariants = VCFUtil.indelInKnownVariant(knownVariants);
            if (indelsInKnownVariants) {
                indelsExist = true;
            }
            for (int i = 0; i < sortedAlleles.length; ++i) {
                if (!NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]).equals("-")) continue;
                indelsExist = true;
            }
            for (String variant : knownVariants) {
                if (indelsExist && !indelsInKnownVariants) {
                    knownVariantsList.add("N" + variant);
                    continue;
                }
                knownVariantsList.add(variant);
            }
            for (int i = 0; i < sortedAlleles.length; ++i) {
                if (tempSortedAlleles.contains(sortedAlleles[i])) continue;
                tempSortedAlleles.add(sortedAlleles[i]);
                if (indelsExist) {
                    if (NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]).equals("-")) {
                        knownVariantsList.add("N");
                        continue;
                    }
                    knownVariantsList.add("N" + NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]));
                    continue;
                }
                knownVariantsList.add(NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]));
            }
            String[] knownVariantsExtended = new String[knownVariantsList.size()];
            for (int i = 0; i < knownVariantsExtended.length; ++i) {
                knownVariantsExtended[i] = (String)knownVariantsList.get(i);
            }
            knownVariants = knownVariantsExtended;
            int[] sortedAllelesExtended = new int[tempSortedAlleles.size()];
            for (int i = 0; i < sortedAllelesExtended.length; ++i) {
                sortedAllelesExtended[i] = (Integer)tempSortedAlleles.get(i);
            }
            sortedAlleles = sortedAllelesExtended;
        } else {
            int i;
            int indelIndex = -1;
            for (i = 0; i < sortedAlleles.length; ++i) {
                if (sortedAlleles[i] != NucleotideAlignmentConstants.getNucleotideAlleleByte('-')) continue;
                indelIndex = i;
                break;
            }
            knownVariants = new String[sortedAlleles.length];
            for (i = 0; i < knownVariants.length; ++i) {
                knownVariants[i] = indelIndex == -1 ? "" + NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]) : (indelIndex == i ? "N" : "N" + NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[i]));
            }
        }
        return new Tuple<int[], String[]>(sortedAlleles, knownVariants);
    }

    public static int[][] calcTop2Depths(int[] siteAlleleDepths) {
        int highestDepth = -1;
        int highestIndex = -1;
        int secondHighestDepth = -1;
        int secondHighestIndex = -1;
        for (int depthCounter = 0; depthCounter < siteAlleleDepths.length; ++depthCounter) {
            if (siteAlleleDepths[depthCounter] > highestDepth) {
                secondHighestDepth = highestDepth;
                secondHighestIndex = highestIndex;
                highestDepth = siteAlleleDepths[depthCounter];
                highestIndex = depthCounter;
                continue;
            }
            if (siteAlleleDepths[depthCounter] <= secondHighestDepth) continue;
            secondHighestDepth = siteAlleleDepths[depthCounter];
            secondHighestIndex = depthCounter;
        }
        int[][] top2Depths = new int[][]{{highestIndex, highestDepth}, {secondHighestIndex, secondHighestDepth}};
        return top2Depths;
    }

    public static List<VariantContext> convertGenotypeTableToVariantContextList(GenotypeTable genotypeTable) {
        ArrayList<VariantContext> variantContextList = new ArrayList<VariantContext>();
        ArrayList<Integer> indelSiteBlockList = new ArrayList<Integer>();
        indelSiteBlockList.add(0);
        for (int i = 1; i < genotypeTable.numberOfSites(); ++i) {
            if (((Position)genotypeTable.positions().get(i - 1)).getChromosome().equals(((Position)genotypeTable.positions().get(i)).getChromosome()) && ((Position)genotypeTable.positions().get(i - 1)).getPosition() + 1 >= ((Position)genotypeTable.positions().get(i)).getPosition()) {
                boolean isIndel = false;
                if (genotypeTable.referenceAllele(i) == 4 || genotypeTable.referenceAllele(i) == 5) {
                    indelSiteBlockList.add(i);
                    continue;
                }
                for (byte allele : genotypeTable.alleles(i)) {
                    if (allele != 4 && allele != 5) continue;
                    isIndel = true;
                    break;
                }
                if (isIndel) {
                    indelSiteBlockList.add(i);
                    continue;
                }
            }
            variantContextList.add(VCFUtil.convertGenotypeTableSiteToVariantContext(genotypeTable, indelSiteBlockList));
            indelSiteBlockList = new ArrayList();
            indelSiteBlockList.add(i);
        }
        variantContextList.add(VCFUtil.convertGenotypeTableSiteToVariantContext(genotypeTable, indelSiteBlockList));
        return variantContextList;
    }

    public static VariantContext convertGenotypeTableSiteToVariantContext(GenotypeTable genotypeTable, List<Integer> sites) {
        boolean fixIndels;
        int startPos = ((Position)genotypeTable.positions().get(sites.get(0))).getPosition();
        List alleleStrings = IntStream.range(0, genotypeTable.numberOfTaxa()).boxed().map(index -> new Tuple<StringBuilder, StringBuilder>(new StringBuilder(), new StringBuilder())).collect(Collectors.toList());
        StringBuilder referenceAlleleStringBuilder = new StringBuilder();
        LinkedHashSet<String> knownVariantSet = new LinkedHashSet<String>();
        for (Integer currentSite : sites) {
            String[] knownVariantsAtSite;
            byte refAllele = genotypeTable.referenceAllele(currentSite);
            if (refAllele != 5 && refAllele != 4) {
                referenceAlleleStringBuilder.append(NucleotideAlignmentConstants.getHaplotypeNucleotide(refAllele));
            }
            if ((knownVariantsAtSite = ((Position)genotypeTable.positions().get(currentSite)).getKnownVariants()) != null) {
                knownVariantSet.addAll(Arrays.asList(knownVariantsAtSite));
            }
            for (int taxonIndex = 0; taxonIndex < genotypeTable.numberOfTaxa(); ++taxonIndex) {
                String[] genotypeCalls = genotypeTable.genotypeAsStringArray(taxonIndex, currentSite);
                if (genotypeCalls[0].equals("X")) {
                    genotypeCalls[0] = "N";
                }
                if (genotypeCalls[1].equals("X")) {
                    genotypeCalls[1] = "N";
                }
                if (!genotypeCalls[0].equals("-") && !genotypeCalls[0].equals("+")) {
                    ((StringBuilder)((Tuple)alleleStrings.get(taxonIndex)).getX()).append(genotypeCalls[0]);
                }
                if (genotypeCalls[1].equals("-") || genotypeCalls[1].equals("+")) continue;
                ((StringBuilder)((Tuple)alleleStrings.get(taxonIndex)).getY()).append(genotypeCalls[1]);
            }
        }
        List<Tuple<String, String>> alleleStringVals = alleleStrings.stream().map(singleAlleleTuple -> new Tuple<String, String>(((StringBuilder)singleAlleleTuple.getX()).toString(), ((StringBuilder)singleAlleleTuple.getY()).toString())).collect(Collectors.toList());
        boolean bl = fixIndels = sites.size() == 1 && alleleStringVals.stream().flatMap(alleleTuple -> Arrays.asList((String)alleleTuple.getX(), (String)alleleTuple.getY()).stream()).anyMatch(alleleString -> alleleString.equals(""));
        if (fixIndels) {
            referenceAlleleStringBuilder.insert(0, "N");
            --startPos;
            alleleStringVals = VCFUtil.fixIndelPositions(alleleStringVals);
        }
        Map<String, Allele> alleleStringToObjMap = VCFUtil.createAlleleStringToObjMap(referenceAlleleStringBuilder.toString(), alleleStringVals, knownVariantSet, (Position)genotypeTable.positions().get(sites.get(0)));
        List alleleObjectList = alleleStringToObjMap.keySet().stream().map(alleleString -> (Allele)alleleStringToObjMap.get(alleleString)).filter(alleleObject -> !alleleObject.equals((Object)Allele.NO_CALL)).distinct().collect(Collectors.toList());
        List<Genotype> genotypeList = VCFUtil.getGenotypes(genotypeTable, alleleStringVals, alleleStringToObjMap);
        VariantContextBuilder vcb = new VariantContextBuilder(".", genotypeTable.positions().chromosomeName(sites.get(0)), (long)startPos, (long)(startPos + referenceAlleleStringBuilder.toString().length() - 1), alleleObjectList).genotypes(genotypeList);
        return vcb.make();
    }

    private static List<Tuple<String, String>> fixIndelPositions(List<Tuple<String, String>> alleleStringVals) {
        return alleleStringVals.stream().map(alleleTuple -> new Tuple<String, String>("N" + (String)alleleTuple.getX(), "N" + (String)alleleTuple.getY())).collect(Collectors.toList());
    }

    private static Map<String, Allele> createAlleleStringToObjMap(String referenceString, List<Tuple<String, String>> alleleStrings, Set<String> knownVariantSet, Position position) {
        try {
            HashMap<String, Allele> stringValueToAlleleMap = new HashMap<String, Allele>();
            if (referenceString == null || referenceString.equals("")) {
                myLogger.warn((Object)("NULL reference allele found: " + position.toString() + " Putting N in for ref."));
                stringValueToAlleleMap.put("N", Allele.create((String)"N", (boolean)true));
            } else {
                stringValueToAlleleMap.put(referenceString, Allele.create((String)referenceString, (boolean)true));
            }
            Map<String, Allele> uniqueAlternateAlleles = alleleStrings.stream().flatMap(sbTuple -> Arrays.asList((String)sbTuple.getX(), (String)sbTuple.getY()).stream()).filter(alleleString -> !stringValueToAlleleMap.containsKey(alleleString)).distinct().filter(alleleString -> alleleString != null).collect(Collectors.toMap(alleleString -> alleleString, alleleString -> {
                if (alleleString.equals("*") || alleleString.equals("X")) {
                    return Allele.NO_CALL;
                }
                return Allele.create((String)alleleString, (boolean)false);
            }));
            stringValueToAlleleMap.putAll(uniqueAlternateAlleles);
            Map<String, Allele> uniqueKnownVariantAlleles = knownVariantSet.stream().filter(alleleString -> !stringValueToAlleleMap.containsKey(alleleString)).distinct().filter(alleleString -> alleleString != null).collect(Collectors.toMap(alleleString -> alleleString, alleleString -> {
                if (alleleString.equals("*") || alleleString.equals("X")) {
                    return Allele.NO_CALL;
                }
                return Allele.create((String)alleleString, (boolean)false);
            }));
            stringValueToAlleleMap.putAll(uniqueKnownVariantAlleles);
            boolean hasIndel = false;
            int refLength = referenceString.length();
            for (String alleleValue : stringValueToAlleleMap.keySet()) {
                if (alleleValue.length() == refLength) continue;
                hasIndel = true;
                break;
            }
            if (!hasIndel && !referenceString.equals("N") && stringValueToAlleleMap.containsKey("N")) {
                stringValueToAlleleMap.put("N", Allele.NO_CALL);
            }
            return stringValueToAlleleMap;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static List<Genotype> getGenotypes(GenotypeTable genotypeTable, List<Tuple<String, String>> listOfAlleleCalls, Map<String, Allele> callToAlleleObjMap) {
        ArrayList<Genotype> genotypeList = new ArrayList<Genotype>();
        for (int taxonIndex = 0; taxonIndex < genotypeTable.numberOfTaxa(); ++taxonIndex) {
            List<Allele> currentTaxonsAlleles = Arrays.asList(callToAlleleObjMap.get(listOfAlleleCalls.get(taxonIndex).getX()), callToAlleleObjMap.get(listOfAlleleCalls.get(taxonIndex).getY()));
            GenotypeBuilder currentGenotypeBuilder = new GenotypeBuilder(genotypeTable.taxaName(taxonIndex), currentTaxonsAlleles);
            genotypeList.add(currentGenotypeBuilder.make());
        }
        return genotypeList;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                VCFUtil.myGenoScoreMap[i][j] = VCFUtil.calcScore(i, j);
            }
        }
    }
}

