/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Arrays;

public class AlleleDepthUtil {
    public static final byte DEPTH_BYTE_MISSING = -128;
    public static final int DEPTH_MISSING = -1;
    private static final double LOG_BASE = 1.0746;
    private static final double R_LOG_CONV = 1.0 / Math.log(1.0746);
    private static final double LOG_CONV = 1.0 / R_LOG_CONV;
    private static final int[] BYTE_TO_INT = new int[256];
    private static final int MAX_ACC_DEPTH = 182;
    private static final int MIN_ACC_BYTE = -55;
    private static final int OFFSET = 126;
    private static final double ADJ = 0.5;

    private AlleleDepthUtil() {
    }

    public static byte addByteDepths(byte depth1, byte depth2) {
        return AlleleDepthUtil.depthIntToByte(AlleleDepthUtil.depthByteToInt(depth1) + AlleleDepthUtil.depthByteToInt(depth2));
    }

    public static byte depthIntToByte(int depth) {
        if (depth == -1) {
            return -128;
        }
        if (depth < 0) {
            throw new IllegalArgumentException("AlleleDepthUtil: depthIntToByte: Can not have negative depth values: " + depth);
        }
        if (depth <= 127) {
            return (byte)depth;
        }
        if (depth <= 182) {
            return (byte)(127 - depth);
        }
        int itd = (int)(-R_LOG_CONV * Math.log(depth - 126));
        if (itd < -127) {
            return -127;
        }
        return (byte)itd;
    }

    public static byte[] depthIntToByte(int[] depth) {
        byte[] result = new byte[depth.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AlleleDepthUtil.depthIntToByte(depth[i]);
        }
        return result;
    }

    public static byte[][] depthIntToByte(int[][] depth) {
        byte[][] result = new byte[depth.length][depth[0].length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AlleleDepthUtil.depthIntToByte(depth[i]);
        }
        return result;
    }

    public static int depthByteToInt(byte depth) {
        return BYTE_TO_INT[depth & 0xFF];
    }

    public static int[] depthByteToInt(byte[] depth) {
        int[] result = new int[depth.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AlleleDepthUtil.depthByteToInt(depth[i]);
        }
        return result;
    }

    private static int decode(byte bdepth) {
        if (bdepth == -128) {
            return -1;
        }
        if (bdepth >= 0) {
            return bdepth;
        }
        if (bdepth >= -55) {
            return 127 - bdepth;
        }
        return 126 + (int)Math.exp(-LOG_CONV * ((double)bdepth - 0.5));
    }

    static {
        Arrays.fill(BYTE_TO_INT, -1);
        for (int i = 0; i < 256; ++i) {
            AlleleDepthUtil.BYTE_TO_INT[i] = AlleleDepthUtil.decode((byte)i);
        }
    }
}

