/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import net.maizegenetics.dna.snp.Translate;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.SiteScore;

public class FilterAlleleDepth
extends AlleleDepth {
    final AlleleDepth myBase;
    final Translate myTranslate;

    FilterAlleleDepth(AlleleDepth alleleDepth, Translate translate) {
        super(translate.numTaxa(), translate.numSites());
        this.myBase = alleleDepth;
        this.myTranslate = translate;
    }

    @Override
    public byte[] valuesByte(int taxon, int site) {
        long taxonSite = this.myTranslate.taxonSite(taxon, site);
        if (taxonSite == -1L) {
            return new byte[NUM_ALLELE_DEPTH_TYPES];
        }
        return this.myBase.valuesByte((int)(taxonSite >>> 32), (int)(taxonSite & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public byte[][] valuesForTaxonByte(int taxon) {
        if (!this.myTranslate.hasSiteTranslations()) {
            int translatedTaxon = this.myTranslate.taxon(taxon);
            if (translatedTaxon == -1) {
                return new byte[NUM_ALLELE_DEPTH_TYPES][this.numSites()];
            }
            return this.myBase.valuesForTaxonByte(translatedTaxon);
        }
        return super.valuesForTaxonByte(taxon);
    }

    @Override
    public byte[][] valuesForSiteByte(int site) {
        if (!this.myTranslate.hasTaxaTranslations()) {
            int translatedSite = this.myTranslate.site(site);
            if (translatedSite == -1) {
                return new byte[NUM_ALLELE_DEPTH_TYPES][this.numTaxa()];
            }
            return this.myBase.valuesForSiteByte(this.myTranslate.site(site));
        }
        return super.valuesForSiteByte(site);
    }

    @Override
    public byte valueByte(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        long taxonSite = this.myTranslate.taxonSite(taxon, site);
        if (taxonSite == -1L) {
            return 0;
        }
        return this.myBase.valueByte((int)(taxonSite >>> 32), (int)(taxonSite & 0xFFFFFFFFFFFFFFFFL), scoreType);
    }

    @Override
    public int value(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        long taxonSite = this.myTranslate.taxonSite(taxon, site);
        if (taxonSite == -1L) {
            return 0;
        }
        return this.myBase.value((int)(taxonSite >>> 32), (int)(taxonSite & 0xFFFFFFFFFFFFFFFFL), scoreType);
    }
}

