/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.Tassel5HDF5Constants;

public class HDF5AlleleDepth
extends AlleleDepth {
    private static int MAX_CACHE_SIZE = 65536;
    private static final int HDF5_BLOCK = 65536;
    private final Map<Long, byte[][]> myDepthCache = new LinkedHashMap<Long, byte[][]>(3 * MAX_CACHE_SIZE / 2){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > MAX_CACHE_SIZE;
        }
    };
    private final IHDF5Reader myReader;
    private final int myNumSites;
    private final TaxaList myTaxa;

    HDF5AlleleDepth(IHDF5Reader reader) {
        super(reader.int32().getAttr("Genotypes", "numTaxa"), reader.int32().getAttr("Positions/", "numSites"));
        this.myReader = reader;
        this.myNumSites = reader.int32().getAttr("Positions/", "numSites");
        this.myTaxa = new TaxaListBuilder().buildFromHDF5Genotypes(reader);
    }

    private static long getCacheKey(int taxon, int site) {
        return ((long)taxon << 33) + (long)(site / 65536);
    }

    @Override
    public byte[] valuesByte(int taxon, int site) {
        long key = HDF5AlleleDepth.getCacheKey(taxon, site);
        byte[][] data = this.myDepthCache.get(key);
        if (data == null) {
            data = this.cacheDepthBlock(taxon, site, key);
        }
        byte[] result = new byte[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = data[i][site % MAX_CACHE_SIZE];
        }
        return result;
    }

    @Override
    public byte[][] valuesForTaxonByte(int taxon) {
        byte[][] result = new byte[6][this.myNumSites];
        for (int site = 0; site < this.myNumSites; ++site) {
            long key = HDF5AlleleDepth.getCacheKey(taxon, site);
            byte[][] data = this.myDepthCache.get(key);
            if (data == null) {
                data = this.cacheDepthBlock(taxon, site, key);
            }
            for (int i = 0; i < 6; ++i) {
                result[i][site] = data[i][site % MAX_CACHE_SIZE];
            }
        }
        return result;
    }

    private byte[][] cacheDepthBlock(int taxon, int site, long key) {
        int start = site / MAX_CACHE_SIZE * MAX_CACHE_SIZE;
        int realSiteCache = this.myNumSites - start < MAX_CACHE_SIZE ? this.myNumSites - start : MAX_CACHE_SIZE;
        byte[][] data = this.myReader.int8().readMatrixBlockWithOffset(Tassel5HDF5Constants.getGenotypesDepthPath(this.myTaxa.taxaName(taxon)), 6, realSiteCache, 0L, (long)start);
        if (data == null) {
            return null;
        }
        this.myDepthCache.put(key, data);
        return data;
    }

    @Override
    public int value(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        return AlleleDepthUtil.depthByteToInt(this.valueByte(taxon, site, scoreType));
    }

    @Override
    public int[] values(int taxon, int site) {
        return AlleleDepthUtil.depthByteToInt(this.valuesByte(taxon, site));
    }

    @Override
    public byte valueByte(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        long key = HDF5AlleleDepth.getCacheKey(taxon, site);
        byte[][] data = this.myDepthCache.get(key);
        if (data == null) {
            data = this.cacheDepthBlock(taxon, site, key);
        }
        return data[scoreType.getIndex()][site % MAX_CACHE_SIZE];
    }

    @Override
    Collection<Byte2D> byteStorage() {
        return null;
    }
}

