/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.AlleleDepthBuilder;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;
import net.maizegenetics.dna.snp.score.HDF5AlleleDepth;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;

public class HDF5AlleleDepthBuilder
extends AlleleDepthBuilder {
    private IHDF5Writer myHDF5Writer;
    private final int myNumSites;

    private HDF5AlleleDepthBuilder(IHDF5Writer writer, int numSites) {
        super(numSites);
        this.myHDF5Writer = writer;
        this.myNumSites = numSites;
    }

    public static HDF5AlleleDepthBuilder getHDF5NucleotideInstance(IHDF5Writer writer, int numSites) {
        return new HDF5AlleleDepthBuilder(writer, numSites);
    }

    public static AlleleDepth getExistingHDF5Instance(IHDF5Reader reader) {
        if (!HDF5Utils.doesGenotypeDepthExist(reader)) {
            return null;
        }
        return new HDF5AlleleDepth(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDF5AlleleDepthBuilder addTaxon(Taxon taxon, byte[][] depths) {
        if (depths == null || depths.length != 6) {
            throw new IllegalStateException("AlleleDepthBuilder: addTaxon: Set A, C, G, T, -, + at once");
        }
        if (depths[0].length != this.myNumSites) {
            throw new IllegalStateException("AlleleDepthBuilder: addTaxon: Number of sites: " + depths[0].length + " should be: " + this.myNumSites);
        }
        IHDF5Writer iHDF5Writer = this.myHDF5Writer;
        synchronized (iHDF5Writer) {
            HDF5Utils.writeHDF5GenotypesDepth(this.myHDF5Writer, taxon.getName(), depths);
        }
        return this;
    }

    public HDF5AlleleDepthBuilder addTaxon(Taxon taxon, int[][] depths) {
        int numAlleles = depths.length;
        if (depths == null || numAlleles != 6) {
            throw new IllegalStateException("AlleleDepthBuilder: addTaxon: Set A, C, G, T, -, + at once");
        }
        if (depths[0].length != this.myNumSites) {
            throw new IllegalStateException("AlleleDepthBuilder: addTaxon: Number of sites: " + depths[0].length + " should be: " + this.myNumSites);
        }
        byte[][] result = new byte[numAlleles][this.myNumSites];
        for (int a = 0; a < numAlleles; ++a) {
            for (int s = 0; s < this.myNumSites; ++s) {
                result[a][s] = AlleleDepthUtil.depthIntToByte(depths[a][s]);
            }
        }
        return this.addTaxon(taxon, result);
    }

    @Override
    public AlleleDepth build() {
        IHDF5Writer reader = this.myHDF5Writer;
        this.myHDF5Writer = null;
        return new HDF5AlleleDepth((IHDF5Reader)reader);
    }
}

