/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SiteScoreUtil {
    private static final Logger myLogger = Logger.getLogger(SiteScoreUtil.class);
    private static final float[] BYTE_TO_FLOAT = new float[256];
    public static final byte BYTE_REPRESENTING_NAN = -1;

    private SiteScoreUtil() {
    }

    public static byte floatToBytePercentage(float value) {
        if ((double)value < 0.0 || (double)value > 1.0) {
            throw new IllegalArgumentException("SiteScoreUtil: floatToBytePercentage: value: " + value + " must be between 0.0 and 1.0");
        }
        if (Float.isNaN(value)) {
            return -1;
        }
        return (byte)Math.round(254.0f * value);
    }

    public static byte[] floatToBytePercentage(float[] values) {
        byte[] result = new byte[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SiteScoreUtil.floatToBytePercentage(values[i]);
        }
        return result;
    }

    public static byte[][] floatToBytePercentage(float[][] values) {
        byte[][] result = new byte[values.length][values[0].length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SiteScoreUtil.floatToBytePercentage(values[i]);
        }
        return result;
    }

    public static float byteToFloatPercentage(byte value) {
        if (value == -1) {
            return Float.NaN;
        }
        return BYTE_TO_FLOAT[value & 0xFF];
    }

    public static float[] byteToFloatPercentage(byte[] values) {
        float[] result = new float[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SiteScoreUtil.byteToFloatPercentage(values[i]);
        }
        return result;
    }

    private static float decode(int value) {
        float result = (float)value / 254.0f;
        BigDecimal bd = new BigDecimal(Float.toString(result));
        bd = bd.setScale(3, 4);
        return bd.floatValue();
    }

    static {
        Arrays.fill(BYTE_TO_FLOAT, -1.0f);
        for (int i = 0; i < 255; ++i) {
            SiteScoreUtil.BYTE_TO_FLOAT[i] = SiteScoreUtil.decode(i);
        }
        SiteScoreUtil.BYTE_TO_FLOAT[255] = Float.NaN;
    }
}

