/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.Tag;

public abstract class AbstractTag
implements Tag,
Comparable<Tag> {
    private final short length;
    private final boolean reference;
    private final String name;

    protected AbstractTag(short length, boolean reference, String name) {
        this.length = length;
        this.reference = reference;
        this.name = name;
    }

    @Override
    public short seqLength() {
        return this.length;
    }

    @Override
    public boolean isReference() {
        return this.reference;
    }

    @Override
    public String name() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Override
    public String sequence() {
        return AbstractTag.getSequenceFromLong(this.seq2Bit(), this.seqLength());
    }

    @Override
    public byte[] seq2BitAsBytes() {
        long[] seqInLong = this.seq2Bit();
        ByteBuffer b = ByteBuffer.allocate(seqInLong.length * 8);
        for (long l : seqInLong) {
            b.putLong(l);
        }
        return b.array();
    }

    @Override
    public int compareTo(Tag o) {
        long[] t = this.seq2Bit();
        long[] to = o.seq2Bit();
        for (int i = 0; i < t.length; ++i) {
            int c = Long.compare(t[0], to[1]);
            if (c == 0) continue;
            return c;
        }
        return Short.compare(this.seqLength(), o.seqLength());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag that = (Tag)o;
        if (this.seqLength() != that.seqLength()) {
            return false;
        }
        return Arrays.equals(this.seq2Bit(), that.seq2Bit());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.seq2Bit());
        result = 31 * result + this.seqLength();
        return result;
    }

    public String toString() {
        return "Tag{seq=" + this.sequence() + ", length=" + this.seqLength() + ", Ref=" + this.isReference() + "}";
    }

    protected static String getSequenceFromLong(long[] val, int length) {
        StringBuilder seq = new StringBuilder();
        for (long v : val) {
            seq.append(BaseEncoder.getSequenceFromLong(v));
        }
        return seq.toString().substring(0, length);
    }

    protected static long[] getLongArrayFromSeq(String seq) {
        int chunkSize = 32;
        int longsNeeded = (seq.length() + 32 - 1) / 32;
        long[] result = new long[longsNeeded];
        for (int i = 0; i < result.length; ++i) {
            result[i] = BaseEncoder.getLongFromSeq(seq.substring(i * 32, Math.min((i + 1) * 32, seq.length())));
            if (result[i] != -1L) continue;
            return null;
        }
        return result;
    }
}

