/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.AbstractTags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.OpenBitSet;

public abstract class AbstractTagsByTaxa
extends AbstractTags
implements TagsByTaxa {
    protected int taxaNum = 0;
    @Deprecated
    protected String[] taxaNames;
    protected TaxaList taxaList = null;

    @Override
    public int getTaxaCount() {
        return this.taxaNames.length;
    }

    @Override
    public String getTaxaName(int taxaIndex) {
        return this.taxaNames[taxaIndex];
    }

    @Override
    public String[] getTaxaNames() {
        return this.taxaNames;
    }

    @Override
    public TaxaList getTaxaList() {
        if (this.taxaList == null) {
            this.taxaList = new TaxaListBuilder().addAll(this.taxaNames).build();
        }
        return this.taxaList;
    }

    @Override
    public int getIndexOfTaxaName(String taxon) {
        return this.taxaList.indexOf(taxon);
    }

    @Override
    @Deprecated
    public void truncateTaxonNames() {
        for (int i = 0; i < this.taxaNames.length; ++i) {
            this.taxaNames[i] = this.taxaNames[i].substring(0, this.taxaNames[i].indexOf(":")).toLowerCase();
        }
    }

    @Override
    public synchronized void addReadsToTagTaxon(int tagIndex, int taxaIndex, int addValue) {
        this.setReadCountForTagTaxon(tagIndex, taxaIndex, addValue + this.getReadCountForTagTaxon(tagIndex, taxaIndex));
    }

    @Override
    public byte[] getTaxaReadCountsForTag(int tagIndex) {
        byte[] r = new byte[this.getTaxaCount()];
        for (int i = 0; i < this.getTaxaCount(); ++i) {
            r[i] = (byte)this.getReadCountForTagTaxon(tagIndex, i);
        }
        return r;
    }

    @Override
    public OpenBitSet getTaxaReadBitsForTag(int tagIndex) {
        OpenBitSet r = new OpenBitSet(this.getTaxaCount());
        for (int i = 0; i < this.getTaxaCount(); ++i) {
            if (this.getReadCountForTagTaxon(tagIndex, i) <= 0) continue;
            r.fastSet(i);
        }
        return r;
    }

    @Override
    public int getNumberOfTaxaWithTag(int readIndex) {
        int nTaxaWData = 0;
        for (int i = 0; i < this.getTaxaCount(); ++i) {
            if (this.getReadCountForTagTaxon(readIndex, i) <= 0) continue;
            ++nTaxaWData;
        }
        return nTaxaWData;
    }

    public void readDistFile(File inFile, TagsByTaxa.FilePacking numberType) {
        System.out.println("Reading Haplotypes distribution from:" + inFile.toString());
        switch (numberType) {
            case Text: {
                this.readTextDistFile(inFile);
                break;
            }
            default: {
                this.readByteShortDistFile(inFile, numberType);
            }
        }
    }

    public void readChannel(File inFile) {
        try {
            boolean hapsOutput = false;
            ByteBuffer bb = ByteBuffer.allocate(1024);
            FileChannel inputChannel = new FileInputStream(inFile).getChannel();
            while (inputChannel.read(bb) != -1) {
                CharBuffer inputBuffer = bb.asCharBuffer();
                inputBuffer.flip();
                while (inputBuffer.hasRemaining()) {
                    System.out.println(inputBuffer.get());
                }
                inputBuffer.clear();
            }
            inputChannel.close();
        }
        catch (Exception e) {
            System.out.println("Catch in reading input channel: " + e);
            e.printStackTrace();
        }
    }

    void readTextDistFile(File inFile) {
        int hapsOutput = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(inFile), 65536);
            String[] inputLine = br.readLine().split("\t");
            int tagNum = Integer.parseInt(inputLine[0]);
            this.tagLengthInLong = Integer.parseInt(inputLine[1]);
            this.taxaNum = Integer.parseInt(inputLine[2]);
            this.initMatrices(this.taxaNum, tagNum);
            inputLine = br.readLine().trim().split("\t");
            for (int t = 0; t < this.taxaNum; ++t) {
                this.taxaNames[t] = inputLine[t];
            }
            for (int i = 0; i < tagNum; ++i) {
                inputLine = br.readLine().split("\t");
                long[] tt = BaseEncoder.getLongArrayFromSeq(inputLine[0]);
                for (int j = 0; j < tt.length; ++j) {
                    this.tags[j][i] = tt[j];
                }
                this.tagLength[i] = Byte.valueOf(inputLine[1]);
                for (int t = 0; t < this.taxaNum; ++t) {
                    this.setReadCountForTagTaxon(i, t, Byte.valueOf(inputLine[t + 2]).byteValue());
                }
                ++hapsOutput;
            }
        }
        catch (Exception e) {
            System.out.println("Catch in writing output file e=" + e);
            e.printStackTrace();
        }
        System.out.println("Number of Taxa in file:" + this.taxaNum);
        System.out.println("Number of Haplotypes in file:" + hapsOutput);
    }

    void readByteShortDistFile(File inFile, TagsByTaxa.FilePacking countType) {
        int hapsOutput = 0;
        try {
            DataInputStream rw = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile), 4000000));
            int tagNum = rw.readInt();
            this.tagLengthInLong = rw.readInt();
            this.taxaNum = rw.readInt();
            this.initMatrices(this.taxaNum, tagNum);
            for (int t = 0; t < this.taxaNum; ++t) {
                this.taxaNames[t] = rw.readUTF();
            }
            for (int i = 0; i < tagNum; ++i) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[j][i] = rw.readLong();
                }
                this.tagLength[i] = rw.readByte();
                for (int t = 0; t < this.taxaNum; ++t) {
                    if (countType == TagsByTaxa.FilePacking.Short) {
                        this.setReadCountForTagTaxon(i, t, rw.readShort());
                        continue;
                    }
                    this.setReadCountForTagTaxon(i, t, rw.readByte());
                }
                ++hapsOutput;
            }
            rw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Catch in writing output file e=" + e);
        }
        System.out.println("Number of Taxa in file:" + this.taxaNum);
        System.out.println("Number of Haplotypes in file:" + hapsOutput);
    }

    @Override
    public void writeDistFile(File outFile, TagsByTaxa.FilePacking numberType, int minCount) {
        int hapsOutput = 0;
        int outReads = minCount > 0 ? this.readsWCountsGreaterThanMin(minCount) : this.getTagCount();
        System.out.println(outReads + " tags will be output to " + outFile.getName());
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 65536));
            switch (numberType) {
                case Text: {
                    hapsOutput = this.writeTextDistFile(fw, outReads, minCount);
                    break;
                }
                default: {
                    hapsOutput = this.writeByteShortDistFile(fw, numberType, outReads, minCount);
                }
            }
            fw.flush();
            fw.close();
            System.out.println("Tags written to:" + outFile.toString());
            System.out.println("Number of tags in file:" + hapsOutput);
        }
        catch (Exception e) {
            System.out.println("Catch in writing output file e=" + e);
            e.printStackTrace();
        }
    }

    private int writeTextDistFile(DataOutputStream fw, int outReads, int minCount) {
        int hapsOutput = 0;
        try {
            fw.writeBytes(outReads + "\t" + this.tagLengthInLong + "\t" + this.taxaNum + "\n");
            for (int t = 0; t < this.taxaNum; ++t) {
                fw.writeBytes(this.taxaNames[t] + "\t");
            }
            fw.writeBytes("\n");
            for (int i = 0; i < this.tags[0].length; ++i) {
                if (minCount > 0 && this.getReadCount(i) < minCount) continue;
                fw.writeBytes(BaseEncoder.getSequenceFromLong(this.getTag(i)) + "\t");
                fw.writeBytes(this.getTagLength(i) + "\t");
                for (int t = 0; t < this.taxaNum; ++t) {
                    fw.writeBytes(this.getReadCountForTagTaxon(i, t) + "\t");
                }
                fw.writeBytes("\n");
                ++hapsOutput;
            }
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextDistFile writing output file e=" + e);
            e.printStackTrace();
        }
        return hapsOutput;
    }

    private int writeByteShortDistFile(DataOutputStream fw, TagsByTaxa.FilePacking countType, int outReads, int minCount) {
        int hapsOutput = 0;
        try {
            fw.writeInt(outReads);
            fw.writeInt(this.tagLengthInLong);
            fw.writeInt(this.taxaNum);
            for (int t = 0; t < this.taxaNum; ++t) {
                fw.writeUTF(this.taxaNames[t]);
            }
            for (int i = 0; i < this.tags[0].length; ++i) {
                if (minCount > 0 && this.getReadCount(i) < minCount) continue;
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    fw.writeLong(this.tags[j][i]);
                }
                fw.writeByte(this.tagLength[i]);
                for (int t = 0; t < this.taxaNum; ++t) {
                    if (countType == TagsByTaxa.FilePacking.Short) {
                        fw.writeShort(this.getReadCountForTagTaxon(i, t));
                        continue;
                    }
                    fw.writeByte(this.getReadCountForTagTaxon(i, t));
                }
                ++hapsOutput;
            }
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextDistFile writing output file e=" + e);
            e.printStackTrace();
        }
        return hapsOutput;
    }

    public void writeReadCountFile(File outFile, boolean binary) {
        int hapsOutput = 0;
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 4000000));
            if (binary) {
                fw.writeInt(this.tags[0].length);
                fw.writeInt(this.tagLengthInLong);
            } else {
                fw.writeBytes(this.getTagCount() + "\t" + this.tagLengthInLong + "\n");
            }
            for (int i = 0; i < this.tags[0].length; ++i) {
                if (!binary) {
                    fw.writeBytes(BaseEncoder.getSequenceFromLong(this.getTag(i)) + '\t' + this.tags[0].length + '\t' + this.getReadCount(i) + "\n");
                } else {
                    for (int j = 0; j < this.tagLengthInLong; ++j) {
                        fw.writeLong(this.tags[j][i]);
                    }
                    fw.writeByte(this.getTagLength(i));
                    fw.writeInt(this.getReadCount(i));
                }
                ++hapsOutput;
            }
            fw.flush();
            fw.close();
            System.out.println("Reads written to:" + outFile.toString());
            System.out.println("Number of Reads in file:" + hapsOutput);
        }
        catch (Exception e) {
            System.out.println("Catch in writing output file e=" + e);
        }
    }

    private int readsWCountsGreaterThanMin(int minCount) {
        if (minCount < 1) {
            return this.getTagCount();
        }
        int sum = 0;
        for (int i = 0; i < this.getTagCount(); ++i) {
            if (this.getReadCount(i) < minCount) continue;
            ++sum;
        }
        return sum;
    }

    public int getReadCount(int tagIndex) {
        int sum = 0;
        for (int i = 0; i < this.getTaxaCount(); ++i) {
            sum += this.getReadCountForTagTaxon(tagIndex, i);
        }
        return sum;
    }

    @Override
    public boolean areTagsUnique() {
        return true;
    }
}

