/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.AbstractPETags;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class PETagCounts
extends AbstractPETags {
    int[] readCount;

    public PETagCounts(String inFile, TagsByTaxa.FilePacking format) {
        this.readDistFile(inFile, format);
    }

    public PETagCounts(int tagLengthInLong, int tagNum) {
        this.iniMatrix(tagLengthInLong, tagNum);
    }

    public PETagCounts getCollapsedPETagCounts() {
        int tagNum = this.getTagCount() - this.collapseCounts();
        PETagCounts petc = new PETagCounts(this.getTagSizeInLong(), tagNum);
        int cnt = 0;
        for (int i = 0; i < this.getTagCount(); ++i) {
            if (this.getReadCount(i) == 0) continue;
            for (int j = 0; j < this.getTagSizeInLong(); ++j) {
                petc.tagsF[cnt][j] = this.tagsF[i][j];
                petc.tagsB[cnt][j] = this.tagsB[i][j];
            }
            petc.tagFLength[cnt] = this.tagFLength[i];
            petc.tagBLength[cnt] = this.tagBLength[i];
            petc.contigLengthInLong[cnt] = this.contigLengthInLong[i];
            petc.contig[cnt] = this.contig[i];
            petc.contigLength[cnt] = this.contigLength[i];
            petc.readCount[cnt] = this.readCount[i];
            ++cnt;
        }
        return petc;
    }

    public int collapseCounts() {
        this.sort();
        int collapsedRows = 0;
        for (int i = 1; i < this.getTagCount(); ++i) {
            if (this.compare(i, i - 1) != 0) continue;
            int n = i;
            this.readCount[n] = this.readCount[n] + this.readCount[i - 1];
            this.readCount[i - 1] = 0;
            ++collapsedRows;
        }
        System.out.println("Rows collapsed:" + collapsedRows);
        return collapsedRows;
    }

    public PETagCounts getMergedPETagCounts(PETagCounts another, boolean ifCollapsed) {
        int j;
        int i;
        if (!ifCollapsed) {
            another = another.getCollapsedPETagCounts();
        }
        PETagCounts petc = new PETagCounts(this.tagLengthInLong, this.getTagCount() + another.getTagCount());
        int cnt = 0;
        for (i = 0; i < this.getTagCount(); ++i) {
            for (j = 0; j < this.getTagSizeInLong(); ++j) {
                petc.tagsF[cnt][j] = this.tagsF[i][j];
                petc.tagsB[cnt][j] = this.tagsB[i][j];
            }
            petc.tagFLength[cnt] = this.tagFLength[i];
            petc.tagBLength[cnt] = this.tagBLength[i];
            petc.contigLengthInLong[cnt] = this.contigLengthInLong[i];
            petc.contig[cnt] = this.contig[i];
            petc.contigLength[cnt] = this.contigLength[i];
            petc.readCount[cnt] = this.readCount[i];
            ++cnt;
        }
        for (i = 0; i < another.getTagCount(); ++i) {
            for (j = 0; j < another.getTagSizeInLong(); ++j) {
                petc.tagsF[cnt][j] = another.tagsF[i][j];
                petc.tagsB[cnt][j] = another.tagsB[i][j];
            }
            petc.tagFLength[cnt] = another.tagFLength[i];
            petc.tagBLength[cnt] = another.tagBLength[i];
            petc.contigLengthInLong[cnt] = another.contigLengthInLong[i];
            petc.contig[cnt] = another.contig[i];
            petc.contigLength[cnt] = another.contigLength[i];
            petc.readCount[cnt] = another.readCount[i];
            ++cnt;
        }
        return petc.getCollapsedPETagCounts();
    }

    public int getTotalReadCount() {
        int sum = 0;
        for (int i = 0; i < this.getTagCount(); ++i) {
            sum += this.getReadCount(i);
        }
        return sum;
    }

    public int getReadCount(int index) {
        return this.readCount[index];
    }

    private int getTagNumWithMincount(int minCount) {
        int num = 0;
        for (int i = 0; i < this.getTagCount(); ++i) {
            if (this.readCount[i] < minCount) continue;
            ++num;
        }
        return num;
    }

    public void readDistFile(String infileS, TagsByTaxa.FilePacking format) {
        System.out.println("Reading PETagCounts file to " + infileS);
        File infile = new File(infileS);
        switch (format) {
            case Text: {
                this.readTextPETagCountsFile(infile);
                break;
            }
            default: {
                this.readBinaryPETagCountsFile(infile);
            }
        }
        System.out.println("PETagCounts file read. Tatol: " + this.getTagCount() + " PETags");
    }

    private void readBinaryPETagCountsFile(File infile) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(infile), 65536));
            this.tagLengthInLong = dis.readInt();
            int tagNum = dis.readInt();
            if (tagNum == -1) {
                int lineSize = (this.tagLengthInLong * 8 + 2) * 2 + 1 + 2 + 4;
                tagNum = (int)((infile.length() - 8L) / (long)lineSize);
            }
            this.iniMatrix(this.tagLengthInLong, tagNum);
            for (int i = 0; i < tagNum; ++i) {
                int j;
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tagsF[i][j] = dis.readLong();
                }
                this.tagFLength[i] = dis.readShort();
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tagsB[i][j] = dis.readLong();
                }
                this.tagBLength[i] = dis.readShort();
                this.contigLengthInLong[i] = dis.readByte();
                this.contig[i] = new long[this.contigLengthInLong[i]];
                for (j = 0; j < this.contig[i].length; ++j) {
                    this.contig[i][j] = dis.readLong();
                }
                this.contigLength[i] = dis.readShort();
                this.readCount[i] = dis.readInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void readTextPETagCountsFile(File infile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(infile), 65536);
            this.tagLengthInLong = Integer.valueOf(br.readLine());
            int tagNum = Integer.valueOf(br.readLine());
            this.iniMatrix(this.tagLengthInLong, tagNum);
            for (int i = 0; i < tagNum; ++i) {
                int j;
                String[] temp = br.readLine().split("\t");
                long[] t = BaseEncoder.getLongArrayFromSeq(temp[0]);
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tagsF[i][j] = t[j];
                }
                this.tagFLength[i] = Short.valueOf(temp[1]);
                t = BaseEncoder.getLongArrayFromSeq(temp[2]);
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tagsB[i][j] = t[j];
                }
                this.tagBLength[i] = Short.valueOf(temp[3]);
                this.readCount[i] = Integer.valueOf(temp[4]);
                this.contigLengthInLong[i] = Byte.valueOf(temp[5]);
                this.contigLength[i] = Short.valueOf(temp[6]);
                this.contig[i] = new long[this.contigLengthInLong[i]];
                if (this.contigLengthInLong[i] == 0) continue;
                t = BaseEncoder.getLongArrayFromSeq(temp[7]);
                for (j = 0; j < t.length; ++j) {
                    this.contig[i][j] = t[j];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void writeDistFile(String outfileS, TagsByTaxa.FilePacking format, int minCount) {
        System.out.println("Writing PETagCounts file to " + outfileS);
        int outTagNum = this.getTagNumWithMincount(minCount);
        switch (format) {
            case Text: {
                this.writeTextPETagCountsFile(outfileS, outTagNum, minCount);
                break;
            }
            default: {
                this.writeBinaryPETagCountsFile(outfileS, outTagNum, minCount);
            }
        }
        System.out.println("PETagCounts file written");
    }

    private void writeBinaryPETagCountsFile(String outfileS, int outTagNum, int minCount) {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfileS), 65536));
            dos.writeInt(this.tagLengthInLong);
            dos.writeInt(outTagNum);
            for (int i = 0; i < this.getTagCount(); ++i) {
                int j;
                if (this.readCount[i] < minCount) continue;
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    dos.writeLong(this.tagsF[i][j]);
                }
                dos.writeShort(this.tagFLength[i]);
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    dos.writeLong(this.tagsB[i][j]);
                }
                dos.writeShort(this.tagBLength[i]);
                dos.writeByte(this.contigLengthInLong[i]);
                for (j = 0; j < this.contigLengthInLong[i]; ++j) {
                    dos.writeLong(this.contig[i][j]);
                }
                dos.writeShort(this.contigLength[i]);
                dos.writeInt(this.readCount[i]);
            }
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void writeTextPETagCountsFile(String outfileS, int outTagNum, int minCount) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write(String.valueOf(this.tagLengthInLong));
            bw.newLine();
            bw.write(String.valueOf(outTagNum));
            bw.newLine();
            for (int i = 0; i < this.getTagCount(); ++i) {
                if (this.getReadCount(i) < minCount) continue;
                bw.write(BaseEncoder.getSequenceFromLong(this.getTagF(i)) + "\t" + String.valueOf(this.getTagFLength(i)) + "\t");
                bw.write(BaseEncoder.getSequenceFromLong(this.getTagB(i)) + "\t" + String.valueOf(this.getTagBLength(i)) + "\t");
                bw.write(String.valueOf(this.getReadCount(i)) + "\t");
                bw.write(String.valueOf(this.contigLengthInLong[i]) + "\t" + String.valueOf(this.contigLength[i]) + "\t");
                bw.write(BaseEncoder.getSequenceFromLong(this.contig[i]) + "\t");
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    protected void iniMatrix(int tagLengthInLong, int tagNum) {
        super.iniMatrix(tagLengthInLong, tagNum);
        this.readCount = new int[tagNum];
    }

    @Override
    public void swap(int index1, int index2) {
        super.swap(index1, index2);
        int temp = this.readCount[index1];
        this.readCount[index1] = this.readCount[index2];
        this.readCount[index2] = temp;
    }
}

