/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.nio.ByteBuffer;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.AbstractTag;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.Tag1Long;
import net.maizegenetics.dna.tag.Tag2Long;
import net.maizegenetics.dna.tag.Tag3Long;
import net.maizegenetics.dna.tag.TagVarLong;

public class TagBuilder {
    private final long[] seq2Bit;
    private final short length;
    private boolean isReference = false;
    private String name = null;

    private TagBuilder(long[] seq2Bit, short length) {
        this.seq2Bit = seq2Bit;
        this.length = length;
    }

    public TagBuilder reference() {
        this.isReference = true;
        return this;
    }

    public TagBuilder name(String name) {
        this.name = name;
        return this;
    }

    public Tag build() {
        switch (this.seq2Bit.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new Tag1Long(this.seq2Bit, this.length, this.isReference, this.name);
            }
            case 2: {
                return new Tag2Long(this.seq2Bit, this.length, this.isReference, this.name);
            }
            case 3: {
                return new Tag3Long(this.seq2Bit, this.length, this.isReference, this.name);
            }
        }
        return new TagVarLong(this.seq2Bit, this.length, this.isReference, this.name);
    }

    public static TagBuilder instance(long[] seq2Bit, short length) {
        return new TagBuilder(seq2Bit, length);
    }

    public static TagBuilder instance(byte[] seq2BitInBytes, short length) {
        int seqBitLength = seq2BitInBytes.length / 8;
        long[] seq2Bit = new long[seqBitLength];
        ByteBuffer bb = ByteBuffer.wrap(seq2BitInBytes);
        for (int i = 0; i < seq2Bit.length; ++i) {
            seq2Bit[i] = bb.getLong();
        }
        return new TagBuilder(seq2Bit, length);
    }

    public static TagBuilder instance(String sequence) {
        long[] seq2Bit = AbstractTag.getLongArrayFromSeq(sequence);
        if (seq2Bit == null) {
            seq2Bit = new long[]{};
        }
        return new TagBuilder(seq2Bit, (short)sequence.length());
    }

    public static TagBuilder reverseComplement(Tag tag) {
        String revSequence = BaseEncoder.getReverseComplement(tag.sequence());
        if (revSequence == null) {
            return null;
        }
        return TagBuilder.instance(revSequence);
    }
}

