/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeMap;
import net.maizegenetics.dna.tag.AbstractTagsByTaxa;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByte;

public class TagsByTaxaByteHDF5TaxaGroups
extends AbstractTagsByTaxa {
    static String path = "/Users/edbuckler/SolexaAnal/GBS/test/";
    static String file = "testToGZ.h5";
    static int chunkSize = 65536;
    int tagCount = 0;
    int tagChunks = 0;
    IHDF5Writer h5 = null;
    ArrayList<String> taxaDirList;
    ArrayList<String> taxaNameList;
    TreeMap<String, String> taxaNameDirTreeMap;
    private int bufferedTaxaIndex = Integer.MIN_VALUE;
    private int bufferedChunkIndex = Integer.MIN_VALUE;
    private byte[] bufferedTagDist = null;
    private boolean bufferChanged = false;

    public TagsByTaxaByteHDF5TaxaGroups(Tags inTags, String newHDF5file) {
        this.tagLengthInLong = inTags.getTagSizeInLong();
        this.tagCount = inTags.getTagCount();
        this.taxaNum = 0;
        this.tags = new long[this.tagLengthInLong][this.tagCount];
        this.tagLength = new byte[this.tagCount];
        for (int i = 0; i < this.tagCount; ++i) {
            long[] ct = inTags.getTag(i);
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                this.tags[j][i] = ct[j];
            }
            this.tagLength[i] = (byte)inTags.getTagLength(i);
        }
        IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(newHDF5file));
        System.out.println("Creating HDF5 file: " + newHDF5file);
        config.overwrite();
        config.dontUseExtendableDataTypes();
        config.useUTF8CharacterEncoding();
        this.h5 = config.writer();
        this.h5.int32().setAttr("/", "tagCount", inTags.getTagCount());
        this.h5.int32().setAttr("/", "chunkSize", chunkSize);
        this.h5.int32().setAttr("/", "tagLengthInLong", this.tagLengthInLong);
        this.h5.int32().setAttr("/", "taxaNum", this.taxaNum);
        this.h5.int64().createMatrix("tags", (long)inTags.getTagSizeInLong(), (long)this.tagCount, inTags.getTagSizeInLong(), this.tagCount);
        this.h5.writeLongMatrix("tags", this.tags);
        this.h5.int8().createArray("tagLength", this.tagCount);
        this.h5.writeByteArray("tagLength", this.tagLength);
        this.h5.object().createGroup("tbttx");
        this.tagChunks = inTags.getTagCount() >> 16;
        if (inTags.getTagCount() % chunkSize > 0) {
            ++this.tagChunks;
        }
        System.out.println(chunkSize);
        System.out.printf("tagChunks %d Div %g %n", this.tagChunks, (double)inTags.getTagCount() / (double)chunkSize);
        this.h5.int32().setAttr("tbttx/", "tagCount", inTags.getTagCount());
        this.h5.int32().setAttr("tbttx/", "tagChunks", this.tagChunks);
        if (inTags instanceof TagsByTaxa) {
            TagsByTaxa inTBT = (TagsByTaxa)inTags;
            this.taxaNum = inTBT.getTaxaCount();
            this.h5.int32().setAttr("/", "taxaNum", this.taxaNum);
            for (int tx = 0; tx < inTBT.getTaxaCount(); ++tx) {
                byte[] tc = new byte[inTBT.getTagCount()];
                for (int i = 0; i < tc.length; ++i) {
                    tc[i] = (byte)inTBT.getReadCountForTagTaxon(i, tx);
                }
                this.addTaxon(inTBT.getTaxaName(tx), tc);
            }
        }
    }

    public TagsByTaxaByteHDF5TaxaGroups(String infile) {
        IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(infile));
        config.dontUseExtendableDataTypes();
        this.h5 = config.writer();
        this.tagCount = this.h5.int32().getAttr("/", "tagCount");
        chunkSize = this.h5.int32().getAttr("/", "chunkSize");
        this.tagLengthInLong = this.h5.int32().getAttr("/", "tagLengthInLong");
        this.taxaNum = this.h5.int32().getAttr("/", "taxaNum");
        this.tagChunks = this.h5.int32().getAttr("tbttx/", "tagChunks");
        this.tags = this.h5.readLongMatrix("tags");
        this.tagLength = this.h5.int8().readArray("tagLength");
        this.createFastTaxaMap();
    }

    private void createFastTaxaMap() {
        ArrayList tmpList = new ArrayList(this.h5.object().getAllGroupMembers("tbttx/"));
        this.taxaNameDirTreeMap = new TreeMap();
        for (String tx : tmpList) {
            String s = this.h5.string().getAttr("tbttx/" + tx, "name");
            this.taxaNameDirTreeMap.put(s, "tbttx/" + tx);
        }
        this.taxaDirList = new ArrayList<String>(this.taxaNameDirTreeMap.values());
        this.taxaNameList = new ArrayList<String>(this.taxaNameDirTreeMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTaxon(String taxonName, byte[] values) {
        IHDF5Writer iHDF5Writer = this.h5;
        synchronized (iHDF5Writer) {
            if (values.length != this.tagCount) {
                System.err.printf("Taxon (%s) does not have the right number of sites (%d)%n", taxonName, values.length);
                return false;
            }
            if (!this.addTaxon(taxonName)) {
                return false;
            }
            String ldir = this.taxaNameDirTreeMap.get(taxonName);
            byte[][] defTag = TagsByTaxaByteHDF5TaxaGroups.encodeBySign(values, chunkSize);
            for (int c = 0; c < defTag.length; ++c) {
                this.h5.writeByteArray(ldir + "/c" + c, defTag[c]);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTaxon(String taxonName) {
        IHDF5Writer iHDF5Writer = this.h5;
        synchronized (iHDF5Writer) {
            int thc = taxonName.hashCode();
            while (this.h5.isGroup("tbttx/" + thc)) {
                if (this.h5.string().getAttr("tbttx/" + thc, "name").equals(taxonName)) {
                    System.err.printf("Taxon (%s) cannot be added already exist%n", taxonName);
                    return false;
                }
                ++thc;
            }
            String lg = "tbttx/" + thc;
            this.h5.object().createGroup(lg);
            this.h5.string().setAttr(lg, "name", taxonName);
            this.createFastTaxaMap();
            this.taxaNum = this.taxaNameList.size();
            this.h5.int32().setAttr("/", "taxaNum", this.taxaNum);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTaxon(String taxonName) {
        IHDF5Writer iHDF5Writer = this.h5;
        synchronized (iHDF5Writer) {
            this.h5.delete(this.taxaNameDirTreeMap.get(taxonName));
            this.createFastTaxaMap();
            this.taxaNum = this.taxaNameList.size();
            this.h5.int32().setAttr("/", "taxaNum", this.taxaNum);
            return true;
        }
    }

    public static byte[][] encodeBySign(byte[] source, int chunkSize) {
        int chunks = source.length / chunkSize;
        if (source.length % chunkSize != 0) {
            ++chunks;
        }
        byte[][] result = new byte[chunks][];
        for (int i = 0; i < chunks; ++i) {
            int s = i * chunkSize;
            int e = s + chunkSize;
            if (e > source.length) {
                e = source.length;
            }
            result[i] = TagsByTaxaByteHDF5TaxaGroups.encodeBySign(Arrays.copyOfRange(source, s, e));
        }
        return result;
    }

    public static byte[] encodeBySign(byte[] source) {
        ByteBuffer dest = ByteBuffer.allocate(source.length);
        dest.putInt(source.length);
        byte runLength = 0;
        for (int i = 0; i < source.length; ++i) {
            if (source[i] > 0) {
                if (runLength < 0) {
                    dest.put(runLength);
                }
                dest.put(source[i]);
                runLength = 0;
                continue;
            }
            if ((runLength = (byte)(runLength - 1)) != -128) continue;
            dest.put(runLength);
            runLength = 0;
        }
        if (runLength < 0) {
            dest.put(runLength);
        }
        return Arrays.copyOf(dest.array(), dest.position());
    }

    public static byte[] decodeBySign(byte[][] srcCompChunk) {
        byte[][] resInChunk = new byte[srcCompChunk.length][];
        int totalLength = 0;
        for (int i = 0; i < srcCompChunk.length; ++i) {
            resInChunk[i] = TagsByTaxaByteHDF5TaxaGroups.decodeBySign(srcCompChunk[i]);
            totalLength += resInChunk[i].length;
        }
        ByteBuffer result = ByteBuffer.allocate(totalLength);
        for (int i = 0; i < srcCompChunk.length; ++i) {
            result.put(resInChunk[i]);
        }
        return result.array();
    }

    public static byte[] decodeBySign(byte[] source) {
        ByteBuffer srcB = ByteBuffer.wrap(source);
        int length = srcB.getInt();
        ByteBuffer dest = ByteBuffer.allocate(length);
        for (int i = 4; i < source.length; ++i) {
            if (source[i] > 0) {
                dest.put(source[i]);
                continue;
            }
            dest.position(-source[i] + dest.position());
        }
        return dest.array();
    }

    public static void main(String[] args) {
        String inTBTFile = "/Users/edbuckler/SolexaAnal/GBS/build20120110/tbt/434GFAAXX_s_3.tbt.byte";
        TagsByTaxaByte inTBT = new TagsByTaxaByte(inTBTFile, TagsByTaxa.FilePacking.Byte);
        long time = System.currentTimeMillis();
        TagsByTaxaByteHDF5TaxaGroups rHDF5 = new TagsByTaxaByteHDF5TaxaGroups(path + file);
        int same = 0;
        int diff = 0;
        int count = 0;
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000000; i += 11) {
            int taxon = i % inTBT.getTaxaCount();
            int tags = i % inTBT.getTagCount();
            int newTaxonIndex = rHDF5.getIndexOfTaxaName(inTBT.getTaxaName(taxon));
            if (inTBT.getReadCountForTagTaxon(tags, taxon) == rHDF5.getReadCountForTagTaxon(tags, newTaxonIndex)) {
                ++same;
            } else {
                ++diff;
            }
            ++count;
        }
        System.out.printf("Same %d Diff %d %n", same, diff);
        long duration = System.currentTimeMillis() - time;
        double rate = (double)duration / (double)count;
        System.out.printf("Rate %g %n", rate);
    }

    @Override
    public int getIndexOfTaxaName(String taxon) {
        int index = Collections.binarySearch(this.taxaNameList, taxon);
        return index;
    }

    @Override
    public int getReadCountForTagTaxon(int tagIndex, int taxaIndex) {
        int chunk = tagIndex >> 16;
        if (this.bufferedChunkIndex != chunk || this.bufferedTaxaIndex != taxaIndex) {
            this.bufferTagDist(chunk, taxaIndex);
        }
        int offset = tagIndex % chunkSize;
        return this.bufferedTagDist[offset];
    }

    public byte[] getReadCountDistributionForTaxon(int taxaIndex) {
        ByteBuffer bb = ByteBuffer.allocate(this.tagCount);
        for (int i = 0; i < this.tagChunks; ++i) {
            this.bufferTagDist(i, taxaIndex);
            bb.put(this.bufferedTagDist);
        }
        return bb.array();
    }

    public int getNumberOfChunks() {
        return this.tagChunks;
    }

    public int getNumberOfTagsPerChunk() {
        return chunkSize;
    }

    private synchronized void bufferTagDist(int tagChunk, int taxaIndex) {
        String g;
        if (this.bufferChanged) {
            g = this.taxaDirList.get(taxaIndex) + "/c" + tagChunk;
            this.h5.writeByteArray(g, this.bufferedTagDist);
        }
        g = this.taxaDirList.get(taxaIndex) + "/c" + tagChunk;
        this.bufferedTagDist = TagsByTaxaByteHDF5TaxaGroups.decodeBySign(this.h5.int8().readArray(g));
        this.bufferedChunkIndex = tagChunk;
        this.bufferedTaxaIndex = taxaIndex;
        this.bufferChanged = false;
    }

    @Override
    public void setMethodByRows(boolean rowSetMethod) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadCountForTagTaxon(int tagIndex, int taxaIndex, int value) {
        IHDF5Writer iHDF5Writer = this.h5;
        synchronized (iHDF5Writer) {
            int chunk = tagIndex >> 16;
            if (this.bufferedChunkIndex != chunk || this.bufferedTaxaIndex != taxaIndex) {
                this.bufferTagDist(chunk, taxaIndex);
            }
            int offset = tagIndex % chunkSize;
            this.bufferChanged = true;
            this.bufferedTagDist[offset] = value > 127 ? 127 : (value < 0 ? 0 : (int)value);
        }
    }

    @Override
    public void initMatrices(int taxaNum, int tagNum) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addTaxa(String[] addTaxaNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getFileReadyForClosing() {
        this.bufferTagDist(0, 0);
        this.h5.close();
    }

    @Override
    public int getTaxaCount() {
        return this.taxaNum;
    }

    @Override
    public String getTaxaName(int taxaIndex) {
        return this.taxaNameList.get(taxaIndex);
    }

    @Override
    public String[] getTaxaNames() {
        String[] array = this.taxaNameList.toArray(new String[this.taxaNameList.size()]);
        return array;
    }

    public TagsByTaxaByte convertToTBTByte() {
        byte[][] tagDist = new byte[this.taxaNum][this.tagCount];
        for (int taxon = 0; taxon < this.taxaNum; ++taxon) {
            for (int tag = 0; tag < this.tagCount; ++tag) {
                tagDist[taxon][tag] = (byte)this.getReadCountForTagTaxon(tag, taxon);
            }
        }
        return new TagsByTaxaByte(this.tags, this.tagLength, tagDist, this.getTaxaNames());
    }
}

