/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import cern.colt.list.ShortArrayList;
import gnu.trove.iterator.TShortIntIterator;
import gnu.trove.map.hash.TShortIntHashMap;
import net.maizegenetics.dna.tag.AbstractTaxaDistribution;
import net.maizegenetics.dna.tag.TaxaDistribution;

class TaxaDistShortExpandable
extends AbstractTaxaDistribution {
    private ShortArrayList taxaWithTag;
    private TShortIntHashMap taxaTagMap = null;
    private int totalDepth;
    private final int maxTaxa;

    public TaxaDistShortExpandable(int maxTaxa) {
        this.maxTaxa = maxTaxa;
        this.taxaWithTag = new ShortArrayList(1);
    }

    @Override
    public synchronized TaxaDistribution increment(int taxaNum) {
        this.taxaWithTag.add((short)taxaNum);
        ++this.totalDepth;
        return this;
    }

    private void convertListToMap() {
        this.taxaTagMap = new TShortIntHashMap(this.maxTaxa);
        for (short taxaIndex : this.taxaWithTag.elements()) {
            this.taxaTagMap.adjustOrPutValue(taxaIndex, 1, 1);
        }
        this.taxaWithTag = null;
    }

    @Override
    public int[] depths() {
        int[] depths = new int[this.maxTaxa];
        if (this.taxaWithTag != null) {
            for (int i = 0; i < this.taxaWithTag.size(); ++i) {
                short s = this.taxaWithTag.getQuick(i);
                depths[s] = depths[s] + 1;
            }
        } else {
            TShortIntIterator sst = this.taxaTagMap.iterator();
            while (sst.hasNext()) {
                sst.advance();
                depths[sst.key()] = sst.value();
            }
        }
        return depths;
    }

    @Override
    public int totalDepth() {
        return this.totalDepth;
    }

    @Override
    public int maxTaxa() {
        return this.maxTaxa;
    }

    @Override
    public int numberOfTaxaWithTag() {
        return this.taxaWithDepths()[0].length;
    }

    @Override
    public int memorySize() {
        int size = 40;
        if (this.taxaWithTag != null) {
            size += this.taxaWithTag.elements().length * 2;
        }
        return size;
    }

    private int unSignShort(short v) {
        if (v < 0) {
            return -v + 1;
        }
        return v;
    }
}

