/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Color;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.GenotypeTableMask;

public abstract class AbstractGenotypeTableMask
implements GenotypeTableMask {
    private static final long serialVersionUID = -5197800047652332969L;
    private final String myName;
    private Color myColor;
    private final GenotypeTable myAlignment;
    private static Color myLastColor = null;
    private static int myIncrementAmount = 125;
    private final GenotypeTableMask.MaskType myMaskType;

    public AbstractGenotypeTableMask(GenotypeTable align, String name, Color color, GenotypeTableMask.MaskType type) {
        this.myAlignment = align;
        this.myName = name;
        this.myColor = color;
        this.myMaskType = type;
    }

    protected static Color getNextColor() {
        if (myLastColor == null) {
            myLastColor = new Color(125, 0, 0);
            return myLastColor;
        }
        int newColor = myLastColor.getRGB() + myIncrementAmount;
        myIncrementAmount = (myIncrementAmount = (myIncrementAmount << 8) % 0xFFFFFF) == 0 ? 125 : myIncrementAmount;
        myLastColor = new Color(newColor %= 0xFFFFFF);
        return myLastColor;
    }

    @Override
    public Color getColor() {
        return this.myColor;
    }

    @Override
    public void setColor(Color color) {
        this.myColor = color;
    }

    @Override
    public GenotypeTable getAlignment() {
        return this.myAlignment;
    }

    @Override
    public GenotypeTableMask.MaskType getMaskType() {
        return this.myMaskType;
    }

    public String toString() {
        if (this.myColor == null) {
            return this.myName;
        }
        String color = " (Red: " + this.myColor.getRed() + "  Green: " + this.myColor.getGreen() + "  Blue: " + this.myColor.getBlue() + ")";
        return this.myName + color;
    }
}

