/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.Utils;

public class FileBrowserUtils {
    private FileBrowserUtils() {
    }

    public static File getOpenFile(JDialog parent) {
        JFileChooser fileChooser = new JFileChooser(TasselPrefs.getOpenDir());
        if (fileChooser.showOpenDialog(parent) == 0) {
            TasselPrefs.putOpenDir(fileChooser.getCurrentDirectory().getPath());
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static File getSaveFile(JDialog parent) {
        JFileChooser fileChooser = new JFileChooser(TasselPrefs.getSaveDir());
        if (fileChooser.showSaveDialog(parent) == 0) {
            TasselPrefs.putSaveDir(fileChooser.getCurrentDirectory().getPath());
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static File getOpenDir(JDialog parent) {
        JFileChooser fileChooser = new JFileChooser(Utils.getDirectory(TasselPrefs.getOpenDir()));
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(parent) == 0) {
            File file = fileChooser.getSelectedFile();
            TasselPrefs.putOpenDir(file.getPath());
            return file;
        }
        return null;
    }

    public static File getSaveDir(JDialog parent) {
        JFileChooser fileChooser = new JFileChooser(Utils.getDirectory(TasselPrefs.getSaveDir()));
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(parent) == 0) {
            File file = fileChooser.getSelectedFile();
            TasselPrefs.putSaveDir(file.getPath());
            return file;
        }
        return null;
    }
}

