/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.maizegenetics.gui.AbstractAvailableListModel;
import net.maizegenetics.gui.SelectFromAvailableDialog;
import net.maizegenetics.util.BitSet;

public class SelectFromAvailableSitesDialog
extends SelectFromAvailableDialog {
    private Frame parentFrame;
    private List<int[]> myListOfSelectedIndices = new ArrayList<int[]>();
    private List<int[]> myListOfCovariateIndices = new ArrayList<int[]>();
    private List<int[]> myListOfFactorIndices = new ArrayList<int[]>();

    public SelectFromAvailableSitesDialog(Frame frame, String title, AbstractAvailableListModel availableModel) {
        super(frame, title, availableModel);
        this.parentFrame = frame;
        this.myIsCanceled = true;
    }

    @Override
    protected JPanel getBottomPanel() {
        JPanel result = new JPanel();
        BoxLayout layout = new BoxLayout(result, 1);
        result.setLayout(layout);
        JPanel firstRow = new JPanel(new FlowLayout());
        firstRow.add(this.getSitesToCovariateButton());
        firstRow.add(Box.createRigidArea(new Dimension(15, 1)));
        firstRow.add(this.getSitesToFactorsButton());
        firstRow.add(Box.createRigidArea(new Dimension(15, 1)));
        firstRow.add(this.getRemoveButton());
        JPanel secondRow = new JPanel(new FlowLayout());
        secondRow.add(this.getSelectedButton());
        secondRow.add(Box.createRigidArea(new Dimension(15, 1)));
        secondRow.add(this.getUnselectedButton());
        secondRow.add(Box.createRigidArea(new Dimension(15, 1)));
        secondRow.add(this.getOkButton());
        secondRow.add(Box.createRigidArea(new Dimension(15, 1)));
        secondRow.add(this.getCancelButton());
        result.add(firstRow);
        result.add(Box.createRigidArea(new Dimension(1, 10)));
        result.add(secondRow);
        result.add(Box.createRigidArea(new Dimension(1, 10)));
        return result;
    }

    protected JButton getSitesToCovariateButton() {
        JButton okButton = new JButton("Selected Sites => Covariates");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = "Selected sites will be converted to covariates.";
                int response = JOptionPane.showConfirmDialog(SelectFromAvailableSitesDialog.this.parentFrame, msg, "Sites to Covariates", 2, 1);
                if (response == 0) {
                    SelectFromAvailableSitesDialog.this.myListOfCovariateIndices.add(SelectFromAvailableSitesDialog.this.mySelectedListModel.getBitSet().getIndicesOfSetBits());
                }
            }
        });
        return okButton;
    }

    protected JButton getSitesToFactorsButton() {
        JButton okButton = new JButton("Selected Sites => Factors");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = "Selected sites will be converted to factors.";
                int response = JOptionPane.showConfirmDialog(SelectFromAvailableSitesDialog.this.parentFrame, msg, "Sites to Factors", 2, 1);
                if (response == 0) {
                    SelectFromAvailableSitesDialog.this.myListOfFactorIndices.add(SelectFromAvailableSitesDialog.this.mySelectedListModel.getBitSet().getIndicesOfSetBits());
                }
            }
        });
        return okButton;
    }

    protected JButton getOkButton() {
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFromAvailableSitesDialog.this.setVisible(false);
                SelectFromAvailableSitesDialog.this.myIsCanceled = false;
            }
        });
        return okButton;
    }

    @Override
    protected JButton getSelectedButton() {
        JButton okButton = new JButton("Capture Selected");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = "A new genotype data set will be created using only the selected sites.";
                int response = JOptionPane.showConfirmDialog(SelectFromAvailableSitesDialog.this.parentFrame, msg, "Sites to Factors", 2, 1);
                if (response == 0) {
                    SelectFromAvailableSitesDialog.this.myListOfSelectedIndices.add(SelectFromAvailableSitesDialog.this.mySelectedListModel.getBitSet().getIndicesOfSetBits());
                }
            }
        });
        return okButton;
    }

    @Override
    protected JButton getUnselectedButton() {
        JButton okButton = new JButton("Capture Unselected");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = "A new genotype data set with the selected sites excluded.";
                int response = JOptionPane.showConfirmDialog(SelectFromAvailableSitesDialog.this.parentFrame, msg, "Sites to Factors", 2, 1);
                if (response == 0) {
                    BitSet temp = SelectFromAvailableSitesDialog.this.mySelectedListModel.getBitSet();
                    temp.flip(0L, SelectFromAvailableSitesDialog.this.myAvailableListModel.getRealSize());
                    SelectFromAvailableSitesDialog.this.myListOfSelectedIndices.add(temp.getIndicesOfSetBits());
                }
            }
        });
        return okButton;
    }

    public List<int[]> listOfSelectedIndices() {
        return this.myListOfSelectedIndices;
    }

    public List<int[]> listOfCovariateIndices() {
        return this.myListOfCovariateIndices;
    }

    public List<int[]> listOfFactorIndices() {
        return this.myListOfFactorIndices;
    }
}

