/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.Matrix;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.ColtEigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.ColtSingularValueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.QRDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;
import net.maizegenetics.taxa.distance.DistanceMatrix;

public class ColtDoubleMatrix
implements DoubleMatrix {
    DoubleMatrix2D myMatrix;

    public ColtDoubleMatrix(DoubleMatrix2D aMatrix) {
        this.myMatrix = aMatrix;
    }

    public ColtDoubleMatrix(int row, int col) {
        this.myMatrix = DoubleFactory2D.dense.make(row, col);
    }

    public ColtDoubleMatrix(int row, int col, double[] values) {
        this.myMatrix = DoubleFactory2D.dense.make(values, row);
    }

    public ColtDoubleMatrix(int row, int col, double value) {
        this.myMatrix = DoubleFactory2D.dense.make(row, col, value);
    }

    public ColtDoubleMatrix(double[][] values) {
        this.myMatrix = DoubleFactory2D.dense.make(values);
    }

    public ColtDoubleMatrix(DistanceMatrix values) {
        this.myMatrix = DoubleFactory2D.dense.make(values.getDistances());
    }

    public ColtDoubleMatrix(int size) {
        this.myMatrix = DoubleFactory2D.dense.identity(size);
    }

    public ColtDoubleMatrix(double[] diagonal) {
        this.myMatrix = DoubleFactory2D.dense.diagonal(DoubleFactory1D.dense.make(diagonal));
    }

    @Override
    public double get(int row, int col) {
        return this.myMatrix.getQuick(row, col);
    }

    @Override
    public double getChecked(int row, int col) {
        return this.myMatrix.get(row, col);
    }

    @Override
    public void set(int row, int col, double value) {
        this.myMatrix.setQuick(row, col, value);
    }

    @Override
    public void setChecked(int row, int col, double value) {
        this.myMatrix.set(row, col, value);
    }

    @Override
    public DoubleMatrix transpose() {
        return new ColtDoubleMatrix(this.myMatrix.viewDice().copy());
    }

    @Override
    public DoubleMatrix mult(DoubleMatrix dm, boolean transpose, boolean transposedm) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        return new ColtDoubleMatrix(this.myMatrix.zMult(B, null, 1.0, 0.0, transpose, transpose));
    }

    @Override
    public DoubleMatrix multadd(DoubleMatrix A, DoubleMatrix B, double alpha, double beta, boolean transpose, boolean transposeA) {
        DoubleMatrix2D C = ((ColtDoubleMatrix)A).myMatrix;
        DoubleMatrix2D D = B == null ? null : ((ColtDoubleMatrix)B).myMatrix;
        DoubleMatrix2D result = this.myMatrix.zMult(C, D, alpha, beta, transpose, transposeA);
        return new ColtDoubleMatrix(result);
    }

    @Override
    public DoubleMatrix mult(DoubleMatrix dm) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        return new ColtDoubleMatrix(this.myMatrix.zMult(B, null));
    }

    @Override
    public DoubleMatrix crossproduct() {
        return new ColtDoubleMatrix(this.myMatrix.viewDice().zMult(this.myMatrix, null));
    }

    @Override
    public DoubleMatrix crossproduct(DoubleMatrix dm) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        return new ColtDoubleMatrix(this.myMatrix.viewDice().zMult(B, null));
    }

    @Override
    public DoubleMatrix tcrossproduct() {
        return new ColtDoubleMatrix(this.myMatrix.zMult(this.myMatrix.viewDice(), null));
    }

    @Override
    public DoubleMatrix tcrossproduct(DoubleMatrix dm) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        return new ColtDoubleMatrix(this.myMatrix.zMult(B.viewDice(), null));
    }

    @Override
    public DoubleMatrix concatenate(DoubleMatrix dm, boolean rows) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        if (rows) {
            return new ColtDoubleMatrix(DoubleFactory2D.dense.appendRows(this.myMatrix, B));
        }
        return new ColtDoubleMatrix(DoubleFactory2D.dense.appendColumns(this.myMatrix, B));
    }

    @Override
    public DoubleMatrix inverse() {
        return new ColtDoubleMatrix(Algebra.DEFAULT.inverse(this.myMatrix));
    }

    @Override
    public boolean invert() {
        this.myMatrix = Algebra.DEFAULT.inverse(this.myMatrix);
        return true;
    }

    @Override
    public DoubleMatrix generalizedInverse() {
        cern.colt.matrix.linalg.SingularValueDecomposition svd;
        Algebra A = new Algebra();
        boolean transposeMatrix = false;
        if (this.myMatrix.rows() < this.myMatrix.columns()) {
            transposeMatrix = true;
            svd = new cern.colt.matrix.linalg.SingularValueDecomposition(this.myMatrix.viewDice());
        } else {
            svd = new cern.colt.matrix.linalg.SingularValueDecomposition(this.myMatrix);
        }
        DoubleMatrix2D invS = svd.getS();
        int size = invS.rows();
        int r = 0;
        for (int i = 0; i < size; ++i) {
            if (Math.abs(invS.get(i, i)) > 1.0E-10) {
                invS.set(i, i, 1.0 / invS.get(i, i));
                ++r;
                continue;
            }
            invS.set(i, i, 0.0);
        }
        DoubleMatrix2D minv = A.mult(A.mult(svd.getV(), invS), A.transpose(svd.getU()));
        if (transposeMatrix) {
            return new ColtDoubleMatrix(minv.viewDice().copy());
        }
        return new ColtDoubleMatrix(minv);
    }

    @Override
    public DoubleMatrix solve(DoubleMatrix Y) {
        return new ColtDoubleMatrix(Algebra.DEFAULT.solve(this.myMatrix, ((ColtDoubleMatrix)Y).myMatrix));
    }

    @Override
    public int numberOfRows() {
        return this.myMatrix.rows();
    }

    @Override
    public int numberOfColumns() {
        return this.myMatrix.columns();
    }

    @Override
    public DoubleMatrix row(int i) {
        int[] rowIndex = new int[]{i};
        return new ColtDoubleMatrix(this.myMatrix.viewSelection(rowIndex, null).viewDice().copy());
    }

    @Override
    public DoubleMatrix column(int j) {
        int[] colIndex = new int[]{j};
        return new ColtDoubleMatrix(this.myMatrix.viewSelection(null, colIndex).copy());
    }

    @Override
    public DoubleMatrix[] getXtXGM() {
        DoubleMatrix[] result = new DoubleMatrix[3];
        DoubleMatrix2D xtx = this.myMatrix.viewDice().zMult(this.myMatrix, null);
        DoubleMatrix2D g = Algebra.DEFAULT.inverse(xtx);
        DoubleMatrix2D m = DoubleFactory2D.dense.identity(this.myMatrix.rows());
        DoubleMatrix2D xgxt = this.myMatrix.zMult(g.zMult(this.myMatrix.viewDice(), null), null);
        m.assign(xgxt, Functions.minus);
        result[0] = new ColtDoubleMatrix(xtx);
        result[1] = new ColtDoubleMatrix(g);
        result[2] = new ColtDoubleMatrix(m);
        return result;
    }

    @Override
    public DoubleMatrix copy() {
        return new ColtDoubleMatrix(this.myMatrix.copy());
    }

    @Override
    public EigenvalueDecomposition getEigenvalueDecomposition() {
        return new ColtEigenvalueDecomposition(this.myMatrix);
    }

    @Override
    public SingularValueDecomposition getSingularValueDecomposition() {
        return new ColtSingularValueDecomposition(this.myMatrix);
    }

    @Override
    public QRDecomposition getQRDecomposition() {
        return null;
    }

    @Override
    public DoubleMatrix minus(DoubleMatrix dm) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        return new ColtDoubleMatrix(this.myMatrix.copy().assign(B, Functions.minus));
    }

    @Override
    public void minusEquals(DoubleMatrix dm) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        this.myMatrix.assign(B, Functions.minus);
    }

    @Override
    public DoubleMatrix plus(DoubleMatrix dm) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        return new ColtDoubleMatrix(this.myMatrix.copy().assign(B, Functions.plus));
    }

    @Override
    public void plusEquals(DoubleMatrix dm) {
        DoubleMatrix2D B = ((ColtDoubleMatrix)dm).myMatrix;
        this.myMatrix.assign(B, Functions.plus);
    }

    @Override
    public DoubleMatrix scalarAdd(double s) {
        DoubleMatrix2D S = DoubleFactory2D.dense.make(this.myMatrix.rows(), this.myMatrix.columns(), s);
        return new ColtDoubleMatrix(S.assign(this.myMatrix, Functions.plus));
    }

    @Override
    public void scalarAddEquals(double s) {
        this.myMatrix.assign(Functions.plus((double)s));
    }

    @Override
    public DoubleMatrix scalarMult(double s) {
        return new ColtDoubleMatrix(this.myMatrix.copy().assign(Functions.mult((double)s)));
    }

    @Override
    public void scalarMultEquals(double s) {
        this.myMatrix.assign(Functions.mult((double)s));
    }

    @Override
    public DoubleMatrix getSelection(int[] rows, int[] columns) {
        return new ColtDoubleMatrix(this.myMatrix.viewSelection(rows, columns).copy());
    }

    @Override
    public double rowSum(int row) {
        return this.myMatrix.viewRow(row).aggregate(Functions.plus, Functions.identity);
    }

    @Override
    public double columnSum(int column) {
        return this.myMatrix.viewColumn(column).aggregate(Functions.plus, Functions.identity);
    }

    @Override
    public int columnRank() {
        return Algebra.DEFAULT.rank(this.myMatrix);
    }

    @Override
    public DoubleMatrix generalizedInverseWithRank(int[] rank) {
        double tol = 1.0E-10;
        Algebra A = new Algebra();
        boolean transposeMatrix = false;
        if (this.myMatrix.rows() < this.myMatrix.columns()) {
            transposeMatrix = true;
        }
        cern.colt.matrix.linalg.SingularValueDecomposition svd = transposeMatrix ? new cern.colt.matrix.linalg.SingularValueDecomposition(this.myMatrix.viewDice()) : new cern.colt.matrix.linalg.SingularValueDecomposition(this.myMatrix);
        DoubleMatrix2D invS = svd.getS();
        int size = invS.rows();
        int r = 0;
        for (int i = 0; i < size; ++i) {
            if (Math.abs(invS.get(i, i)) > tol) {
                invS.set(i, i, 1.0 / invS.get(i, i));
                ++r;
                continue;
            }
            invS.set(i, i, 0.0);
        }
        rank[0] = r;
        DoubleMatrix2D minv = A.mult(A.mult(svd.getV(), invS), A.transpose(svd.getU()));
        if (transposeMatrix) {
            minv = A.transpose(minv);
        }
        return new ColtDoubleMatrix(minv);
    }

    @Override
    public double[] to1DArray() {
        int nrows = this.myMatrix.rows();
        int ncols = this.myMatrix.columns();
        int nelements = nrows * ncols;
        double[] array = new double[nelements];
        int count = 0;
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                array[count++] = this.myMatrix.getQuick(r, c);
            }
        }
        return array;
    }

    @Override
    public double[][] toArray() {
        return this.myMatrix.toArray();
    }

    public String toString() {
        return this.myMatrix.toString();
    }
}

