/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.Matrix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.EJMLEigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.EJMLSingularValueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.QRDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u001d\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0015\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u0006H\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0018\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0001H\u0016J\b\u0010(\u001a\u00020\u0001H\u0016J\u0010\u0010(\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0016J\b\u0010)\u001a\u00020\u0001H\u0016J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020,H\u0016J\u0019\u0010-\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010.\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J\u001c\u00103\u001a\u00020\u00012\b\u0010%\u001a\u0004\u0018\u00010,2\b\u00104\u001a\u0004\u0018\u00010,H\u0016J\b\u00105\u001a\u000206H\u0016J\u0013\u00107\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0016\u00a2\u0006\u0002\u00108J\n\u00109\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010:\u001a\u00020&H\u0016J\u0011\u0010;\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010$\u001a\u00020\u0001H\u0016J\u0010\u0010>\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0016J \u0010>\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00012\u0006\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020&H\u0016J:\u0010A\u001a\u00020\u00012\u0006\u0010B\u001a\u00020\u00012\b\u0010C\u001a\u0004\u0018\u00010\u00012\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010?\u001a\u00020&2\u0006\u0010F\u001a\u00020&H\u0016J\b\u0010G\u001a\u00020\u0006H\u0016J\b\u0010H\u001a\u00020\u0006H\u0016J\u0011\u0010I\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010J\u001a\u00020=2\u0006\u0010$\u001a\u00020\u0001H\u0016J\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010K\u001a\u00020\u0006H\u0016J\u0010\u0010L\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010M\u001a\u00020\u00012\u0006\u0010N\u001a\u00020\rH\u0016J\u0010\u0010O\u001a\u00020=2\u0006\u0010N\u001a\u00020\rH\u0016J\u0010\u0010P\u001a\u00020\u00012\u0006\u0010N\u001a\u00020\rH\u0016J\u0010\u0010Q\u001a\u00020=2\u0006\u0010N\u001a\u00020\rH\u0016J!\u0010R\u001a\u00020=2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J \u0010S\u001a\u00020=2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010T\u001a\u00020\u00012\b\u0010U\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010V\u001a\u00020\u0001H\u0016J\u0010\u0010V\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0016J\b\u0010W\u001a\u00020\nH\u0016J\u0013\u0010X\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0016\u00a2\u0006\u0002\u0010YJ\b\u0010?\u001a\u00020\u0001H\u0016R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0004R\u0014\u0010\u001c\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006Z"}, d2={"Lnet/maizegenetics/matrixalgebra/Matrix/EJMLDoubleMatrix;", "Lnet/maizegenetics/matrixalgebra/Matrix/DoubleMatrix;", "matrix", "Lorg/ejml/data/DMatrixRMaj;", "(Lorg/ejml/data/DMatrixRMaj;)V", "row", "", "col", "(II)V", "values", "", "(II[D)V", "value", "", "(IID)V", "", "([[D)V", "dist", "Lnet/maizegenetics/taxa/distance/DistanceMatrix;", "(Lnet/maizegenetics/taxa/distance/DistanceMatrix;)V", "size", "(I)V", "diagonal", "([D)V", "myMatrix", "getMyMatrix", "()Lorg/ejml/data/DMatrixRMaj;", "setMyMatrix", "tol", "getTol", "()D", "column", "j", "columnRank", "columnSum", "concatenate", "dm", "rows", "", "copy", "crossproduct", "generalizedInverse", "generalizedInverseWithRank", "rank", "", "get", "getChecked", "getEigenvalueDecomposition", "Lnet/maizegenetics/matrixalgebra/decomposition/EigenvalueDecomposition;", "getQRDecomposition", "Lnet/maizegenetics/matrixalgebra/decomposition/QRDecomposition;", "getSelection", "columns", "getSingularValueDecomposition", "Lnet/maizegenetics/matrixalgebra/decomposition/SingularValueDecomposition;", "getXtXGM", "()[Lnet/maizegenetics/matrixalgebra/Matrix/DoubleMatrix;", "inverse", "invert", "minus", "minusEquals", "", "mult", "transpose", "transposedm", "multadd", "A", "B", "alpha", "beta", "transposeA", "numberOfColumns", "numberOfRows", "plus", "plusEquals", "i", "rowSum", "scalarAdd", "s", "scalarAddEquals", "scalarMult", "scalarMultEquals", "set", "setChecked", "solve", "Y", "tcrossproduct", "to1DArray", "toArray", "()[[D", "tassel"})
public final class EJMLDoubleMatrix
implements DoubleMatrix {
    private final double tol;
    @NotNull
    private DMatrixRMaj myMatrix;

    public final double getTol() {
        return this.tol;
    }

    @NotNull
    public final DMatrixRMaj getMyMatrix() {
        return this.myMatrix;
    }

    public final void setMyMatrix(@NotNull DMatrixRMaj dMatrixRMaj) {
        Intrinsics.checkNotNullParameter((Object)dMatrixRMaj, (String)"<set-?>");
        this.myMatrix = dMatrixRMaj;
    }

    @Override
    public double get(int row, int col) {
        return this.myMatrix.unsafe_get(row, col);
    }

    @Override
    public double getChecked(int row, int col) {
        return this.myMatrix.get(row, col);
    }

    @Override
    public void set(int row, int col, double value) {
        this.myMatrix.unsafe_set(row, col, value);
    }

    @Override
    public void setChecked(int row, int col, double value) {
        this.myMatrix.set(row, col, value);
    }

    @Override
    @NotNull
    public DoubleMatrix transpose() {
        DMatrixRMaj dMatrixRMaj = CommonOps_DDRM.transpose((DMatrixRMaj)this.myMatrix, (DMatrixRMaj)new DMatrixRMaj(this.myMatrix.numRows, this.myMatrix.numCols));
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"CommonOps_DDRM.transpose\u2026mRows, myMatrix.numCols))");
        return new EJMLDoubleMatrix(dMatrixRMaj);
    }

    @Override
    @NotNull
    public DoubleMatrix mult(@NotNull DoubleMatrix dm, boolean transpose, boolean transposedm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj otherMatrix = ((EJMLDoubleMatrix)dm).myMatrix;
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        if (transpose && transposedm) {
            CommonOps_DDRM.multTransAB((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)otherMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        } else if (transpose && !transposedm) {
            CommonOps_DDRM.multTransA((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)otherMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        } else if (!transpose && transposedm) {
            CommonOps_DDRM.multTransB((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)otherMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        } else {
            CommonOps_DDRM.mult((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)otherMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        }
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    @NotNull
    public DoubleMatrix mult(@NotNull DoubleMatrix dm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj otherMatrix = ((EJMLDoubleMatrix)dm).myMatrix;
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.mult((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)otherMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    @NotNull
    public DoubleMatrix multadd(@NotNull DoubleMatrix A, @Nullable DoubleMatrix B, double alpha, double beta, boolean transpose, boolean transposeA) {
        DMatrixRMaj dMatrixRMaj;
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        DMatrixRMaj Amatrix = ((EJMLDoubleMatrix)A).myMatrix;
        if (B == null) {
            dMatrixRMaj = transpose && transposeA ? new DMatrixRMaj(this.myMatrix.numCols, Amatrix.numRows) : (transpose && !transposeA ? new DMatrixRMaj(this.myMatrix.numCols, Amatrix.numCols) : (!transpose && transposeA ? new DMatrixRMaj(this.myMatrix.numRows, Amatrix.numRows) : new DMatrixRMaj(this.myMatrix.numRows, Amatrix.numCols)));
        } else if (beta == 1.0) {
            dMatrixRMaj = ((EJMLDoubleMatrix)B).myMatrix;
        } else {
            DMatrixRMaj scaledB = new DMatrixRMaj(1, 1);
            CommonOps_DDRM.scale((double)beta, (DMatrixD1)((DMatrixD1)((EJMLDoubleMatrix)B).myMatrix), (DMatrixD1)((DMatrixD1)scaledB));
            dMatrixRMaj = scaledB;
        }
        DMatrixRMaj Bmatrix = dMatrixRMaj;
        if (transpose && transposeA) {
            CommonOps_DDRM.multAddTransAB((double)alpha, (DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)Amatrix), (DMatrix1Row)((DMatrix1Row)Bmatrix));
        } else if (transpose && !transposeA) {
            CommonOps_DDRM.multAddTransA((double)alpha, (DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)Amatrix), (DMatrix1Row)((DMatrix1Row)Bmatrix));
        } else if (!transpose && transposeA) {
            CommonOps_DDRM.multAddTransB((double)alpha, (DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)Amatrix), (DMatrix1Row)((DMatrix1Row)Bmatrix));
        } else {
            CommonOps_DDRM.multAdd((double)alpha, (DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)Amatrix), (DMatrix1Row)((DMatrix1Row)Bmatrix));
        }
        return new EJMLDoubleMatrix(Bmatrix);
    }

    @Override
    @NotNull
    public DoubleMatrix crossproduct() {
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.multTransA((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    @NotNull
    public DoubleMatrix crossproduct(@NotNull DoubleMatrix dm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.multTransA((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)((EJMLDoubleMatrix)dm).myMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    @NotNull
    public DoubleMatrix tcrossproduct() {
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.multTransB((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    @NotNull
    public DoubleMatrix tcrossproduct(@NotNull DoubleMatrix dm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.multTransB((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)((EJMLDoubleMatrix)dm).myMatrix), (DMatrix1Row)((DMatrix1Row)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    @NotNull
    public DoubleMatrix concatenate(@NotNull DoubleMatrix dm, boolean rows) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        if (rows) {
            CommonOps_DDRM.concatRows((DMatrixRMaj)this.myMatrix, (DMatrixRMaj)((EJMLDoubleMatrix)dm).myMatrix, (DMatrixRMaj)resultMatrix);
        } else {
            CommonOps_DDRM.concatColumns((DMatrixRMaj)this.myMatrix, (DMatrixRMaj)((EJMLDoubleMatrix)dm).myMatrix, (DMatrixRMaj)resultMatrix);
        }
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    @Nullable
    public DoubleMatrix inverse() {
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        return CommonOps_DDRM.invert((DMatrixRMaj)this.myMatrix, (DMatrixRMaj)resultMatrix) ? (DoubleMatrix)new EJMLDoubleMatrix(resultMatrix) : null;
    }

    @Override
    public boolean invert() {
        return CommonOps_DDRM.invert((DMatrixRMaj)this.myMatrix);
    }

    @Override
    @NotNull
    public DoubleMatrix generalizedInverse() {
        DMatrixRMaj resultMatrix = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.pinv((DMatrixRMaj)this.myMatrix, (DMatrixRMaj)resultMatrix);
        return new EJMLDoubleMatrix(resultMatrix);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DoubleMatrix generalizedInverseWithRank(@NotNull int[] rank) {
        Intrinsics.checkNotNullParameter((Object)rank, (String)"rank");
        EJMLSingularValueDecomposition svd = new EJMLSingularValueDecomposition(this.myMatrix);
        rank[0] = svd.getRank();
        DoubleMatrix invS = svd.getS();
        int n = 0;
        int n2 = invS.numberOfRows();
        while (n < n2) {
            void ndx;
            invS.set((int)ndx, (int)ndx, invS.get((int)ndx, (int)ndx) < this.tol ? 0.0 : 1.0 / invS.get((int)ndx, (int)ndx));
            ++ndx;
        }
        DoubleMatrix V = svd.getV(false);
        DoubleMatrix UT = svd.getU(true);
        DoubleMatrix doubleMatrix = V.mult(invS).mult(UT);
        Intrinsics.checkNotNullExpressionValue((Object)doubleMatrix, (String)"V.mult(invS).mult(UT)");
        return doubleMatrix;
    }

    @Override
    @NotNull
    public DoubleMatrix solve(@Nullable DoubleMatrix Y) {
        DMatrixRMaj dMatrixRMaj;
        LinearSolverDense solver = LinearSolverFactory_DDRM.leastSquares((int)this.myMatrix.numRows, (int)this.myMatrix.numCols);
        DMatrixRMaj Amatrix = solver.modifiesA() ? this.myMatrix.copy() : this.myMatrix;
        boolean bl = solver.setA((Matrix)Amatrix);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "solver unable to set A";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (solver.modifiesB()) {
            DoubleMatrix doubleMatrix = Y;
            if (doubleMatrix == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.matrixalgebra.Matrix.EJMLDoubleMatrix");
            }
            dMatrixRMaj = ((EJMLDoubleMatrix)doubleMatrix).myMatrix.copy();
        } else {
            DoubleMatrix doubleMatrix = Y;
            if (doubleMatrix == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.matrixalgebra.Matrix.EJMLDoubleMatrix");
            }
            dMatrixRMaj = ((EJMLDoubleMatrix)doubleMatrix).myMatrix;
        }
        DMatrixRMaj Bmatrix = dMatrixRMaj;
        DMatrixRMaj Xmatrix = new DMatrixRMaj(Amatrix.numCols, Bmatrix.numCols);
        solver.solve((Matrix)Bmatrix, (Matrix)Xmatrix);
        return new EJMLDoubleMatrix(Xmatrix);
    }

    @Override
    public int numberOfRows() {
        return this.myMatrix.numRows;
    }

    @Override
    public int numberOfColumns() {
        return this.myMatrix.numCols;
    }

    @Override
    @NotNull
    public DoubleMatrix row(int i) {
        DMatrixRMaj out = CommonOps_DDRM.extractRow((DMatrixRMaj)this.myMatrix, (int)i, null);
        out.reshape(this.myMatrix.numCols, 1);
        DMatrixRMaj dMatrixRMaj = out;
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"out");
        return new EJMLDoubleMatrix(dMatrixRMaj);
    }

    @Override
    @NotNull
    public DoubleMatrix column(int j) {
        DMatrixRMaj dMatrixRMaj = CommonOps_DDRM.extractColumn((DMatrixRMaj)this.myMatrix, (int)j, null);
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"CommonOps_DDRM.extractColumn(myMatrix, j, null)");
        return new EJMLDoubleMatrix(dMatrixRMaj);
    }

    @Override
    @NotNull
    public DoubleMatrix[] getXtXGM() {
        DMatrixRMaj result0 = new DMatrixRMaj(this.myMatrix.numCols, this.myMatrix.numCols);
        CommonOps_DDRM.multTransA((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)result0));
        DMatrixRMaj result1 = result0.copy();
        if (!CommonOps_DDRM.invert((DMatrixRMaj)result1)) {
            CommonOps_DDRM.pinv((DMatrixRMaj)result0, (DMatrixRMaj)result1);
        }
        DMatrixRMaj tmp1 = new DMatrixRMaj(this.myMatrix.numRows, result1.numCols);
        CommonOps_DDRM.mult((DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)result1), (DMatrix1Row)((DMatrix1Row)tmp1));
        DMatrixRMaj tmp2 = new DMatrixRMaj(tmp1.numRows, this.myMatrix.numRows);
        CommonOps_DDRM.multTransB((DMatrix1Row)((DMatrix1Row)tmp1), (DMatrix1Row)((DMatrix1Row)this.myMatrix), (DMatrix1Row)((DMatrix1Row)tmp2));
        DMatrixRMaj result2 = CommonOps_DDRM.identity((int)tmp2.numRows);
        CommonOps_DDRM.subtractEquals((DMatrixD1)((DMatrixD1)result2), (DMatrixD1)((DMatrixD1)tmp2));
        DoubleMatrix[] doubleMatrixArray = new DoubleMatrix[3];
        doubleMatrixArray[0] = new EJMLDoubleMatrix(result0);
        DMatrixRMaj dMatrixRMaj = result1;
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"result1");
        doubleMatrixArray[1] = new EJMLDoubleMatrix(dMatrixRMaj);
        DMatrixRMaj dMatrixRMaj2 = result2;
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj2, (String)"result2");
        doubleMatrixArray[2] = new EJMLDoubleMatrix(dMatrixRMaj2);
        return doubleMatrixArray;
    }

    @Override
    @NotNull
    public DoubleMatrix copy() {
        DMatrixRMaj dMatrixRMaj = this.myMatrix.copy();
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"myMatrix.copy()");
        return new EJMLDoubleMatrix(dMatrixRMaj);
    }

    @Override
    @NotNull
    public EigenvalueDecomposition getEigenvalueDecomposition() {
        return new EJMLEigenvalueDecomposition(this.myMatrix, false, 2, null);
    }

    @Override
    @NotNull
    public SingularValueDecomposition getSingularValueDecomposition() {
        return new EJMLSingularValueDecomposition(this.myMatrix);
    }

    @Override
    @NotNull
    public QRDecomposition getQRDecomposition() {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public DoubleMatrix minus(@NotNull DoubleMatrix dm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj otherMatrix = ((EJMLDoubleMatrix)dm).myMatrix;
        boolean bl = this.myMatrix.numRows == otherMatrix.numRows && this.myMatrix.numCols == otherMatrix.numCols;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Attempted to subtract unequal size matrices";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        DMatrixRMaj resultMatrix = new DMatrixRMaj(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps_DDRM.subtract((DMatrixD1)((DMatrixD1)this.myMatrix), (DMatrixD1)((DMatrixD1)otherMatrix), (DMatrixD1)((DMatrixD1)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    public void minusEquals(@NotNull DoubleMatrix dm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj otherMatrix = ((EJMLDoubleMatrix)dm).myMatrix;
        boolean bl = this.myMatrix.numRows == otherMatrix.numRows && this.myMatrix.numCols == otherMatrix.numCols;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Attempted to subtract unequal size matrices";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        CommonOps_DDRM.subtractEquals((DMatrixD1)((DMatrixD1)this.myMatrix), (DMatrixD1)((DMatrixD1)otherMatrix));
    }

    @Override
    @NotNull
    public DoubleMatrix plus(@NotNull DoubleMatrix dm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj otherMatrix = ((EJMLDoubleMatrix)dm).myMatrix;
        boolean bl = this.myMatrix.numRows == otherMatrix.numRows && this.myMatrix.numCols == otherMatrix.numCols;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Attempted to add unequal size matrices";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        DMatrixRMaj resultMatrix = new DMatrixRMaj(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps_DDRM.add((DMatrixD1)((DMatrixD1)this.myMatrix), (DMatrixD1)((DMatrixD1)otherMatrix), (DMatrixD1)((DMatrixD1)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    public void plusEquals(@NotNull DoubleMatrix dm) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        DMatrixRMaj otherMatrix = ((EJMLDoubleMatrix)dm).myMatrix;
        boolean bl = this.myMatrix.numRows == otherMatrix.numRows && this.myMatrix.numCols == otherMatrix.numCols;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Attempted to add unequal size matrices";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        CommonOps_DDRM.addEquals((DMatrixD1)((DMatrixD1)this.myMatrix), (DMatrixD1)((DMatrixD1)otherMatrix));
    }

    @Override
    @NotNull
    public DoubleMatrix scalarAdd(double s) {
        DMatrixRMaj resultMatrix = new DMatrixRMaj(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps_DDRM.add((DMatrixD1)((DMatrixD1)this.myMatrix), (double)s, (DMatrixD1)((DMatrixD1)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    public void scalarAddEquals(double s) {
        CommonOps_DDRM.add((DMatrixD1)((DMatrixD1)this.myMatrix), (double)s);
    }

    @Override
    @NotNull
    public DoubleMatrix scalarMult(double s) {
        DMatrixRMaj resultMatrix = new DMatrixRMaj(this.myMatrix.numRows, this.myMatrix.numCols);
        CommonOps_DDRM.scale((double)s, (DMatrixD1)((DMatrixD1)this.myMatrix), (DMatrixD1)((DMatrixD1)resultMatrix));
        return new EJMLDoubleMatrix(resultMatrix);
    }

    @Override
    public void scalarMultEquals(double s) {
        CommonOps_DDRM.scale((double)s, (DMatrixD1)((DMatrixD1)this.myMatrix));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DoubleMatrix getSelection(@Nullable int[] rows, @Nullable int[] columns) {
        int[] nArray;
        int[] selectedRows;
        int[] nArray2;
        void var12_13;
        int n;
        int[] nArray3;
        int n2;
        int n3;
        if (rows == null) {
            int n4 = this.myMatrix.numRows;
            int[] nArray4 = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                void it;
                n3 = n5;
                n2 = n5++;
                nArray3 = nArray4;
                n = 0;
                var12_13 = it;
                nArray3[n2] = var12_13;
            }
            nArray2 = nArray4;
        } else {
            nArray2 = selectedRows = rows;
        }
        if (columns == null) {
            int n6 = this.myMatrix.numCols;
            int[] nArray5 = new int[n6];
            n3 = 0;
            while (n3 < n6) {
                void it;
                n = n3;
                n2 = n3++;
                nArray3 = nArray5;
                boolean bl = false;
                var12_13 = it;
                nArray3[n2] = var12_13;
            }
            nArray = nArray5;
        } else {
            nArray = columns;
        }
        int[] selectedColumns = nArray;
        DMatrixRMaj dMatrixRMaj = CommonOps_DDRM.extract((DMatrixRMaj)this.myMatrix, (int[])selectedRows, (int)selectedRows.length, (int[])selectedColumns, (int)selectedColumns.length, null);
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"CommonOps_DDRM.extract(m\u2026lectedColumns.size, null)");
        return new EJMLDoubleMatrix(dMatrixRMaj);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double rowSum(int row) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.myMatrix.numCols);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = this.myMatrix.get(row, (int)it);
            collection.add(d);
        }
        return CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double columnSum(int column) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.myMatrix.numRows);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = this.myMatrix.get((int)it, column);
            collection.add(d);
        }
        return CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
    }

    @Override
    public int columnRank() {
        return new EJMLSingularValueDecomposition(this.myMatrix).getRank();
    }

    @Override
    @NotNull
    public double[] to1DArray() {
        Intrinsics.checkNotNullExpressionValue((Object)this.myMatrix.data, (String)"myMatrix.data");
        return this.myMatrix.data;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public double[][] toArray() {
        int n = this.myMatrix.numRows;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = i;
            double[][] dArrayArray2 = dArrayArray;
            boolean bl = false;
            int n4 = this.myMatrix.numCols;
            double[] dArray = new double[n4];
            int n5 = 0;
            while (n5 < n4) {
                void colIndex;
                void rowIndex;
                double d;
                int n6 = n5;
                int n7 = n5++;
                double[] dArray2 = dArray;
                boolean bl2 = false;
                dArray2[n7] = d = this.myMatrix.get((int)rowIndex, (int)colIndex);
            }
            double[] dArray3 = dArray;
            dArrayArray2[n3] = dArray3;
        }
        return dArrayArray;
    }

    public EJMLDoubleMatrix(@NotNull DMatrixRMaj matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        this.tol = 1.0E-10;
        this.myMatrix = matrix;
    }

    public EJMLDoubleMatrix(int row, int col) {
        this.tol = 1.0E-10;
        this.myMatrix = new DMatrixRMaj(row, col);
    }

    public EJMLDoubleMatrix(int row, int col, @NotNull double[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.tol = 1.0E-10;
        this.myMatrix = new DMatrixRMaj(row, col, true, Arrays.copyOf(values, values.length));
    }

    public EJMLDoubleMatrix(int row, int col, double value) {
        this.tol = 1.0E-10;
        this.myMatrix = new DMatrixRMaj(row, col);
        this.myMatrix.fill(value);
    }

    public EJMLDoubleMatrix(@NotNull double[][] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.tol = 1.0E-10;
        this.myMatrix = new DMatrixRMaj(values);
    }

    public EJMLDoubleMatrix(@NotNull DistanceMatrix dist) {
        Intrinsics.checkNotNullParameter((Object)dist, (String)"dist");
        this.tol = 1.0E-10;
        this.myMatrix = new DMatrixRMaj(dist.getDistances());
    }

    public EJMLDoubleMatrix(int size) {
        this.tol = 1.0E-10;
        DMatrixRMaj dMatrixRMaj = CommonOps_DDRM.identity((int)size);
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"CommonOps_DDRM.identity(size)");
        this.myMatrix = dMatrixRMaj;
    }

    public EJMLDoubleMatrix(@NotNull double[] diagonal) {
        Intrinsics.checkNotNullParameter((Object)diagonal, (String)"diagonal");
        this.tol = 1.0E-10;
        DMatrixRMaj dMatrixRMaj = CommonOps_DDRM.diag((double[])Arrays.copyOf(diagonal, diagonal.length));
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"CommonOps_DDRM.diag(*diagonal)");
        this.myMatrix = dMatrixRMaj;
    }
}

