/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.EJMLDoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.EigenOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition_F64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/maizegenetics/matrixalgebra/decomposition/EJMLEigenvalueDecomposition;", "Lnet/maizegenetics/matrixalgebra/decomposition/EigenvalueDecomposition;", "matrix", "Lorg/ejml/data/DMatrixRMaj;", "isSymmetric", "", "(Lorg/ejml/data/DMatrixRMaj;Z)V", "()Z", "myDecomposition", "Lorg/ejml/interfaces/decomposition/EigenDecomposition_F64;", "getMyDecomposition", "()Lorg/ejml/interfaces/decomposition/EigenDecomposition_F64;", "getEigenvalue", "", "i", "", "getEigenvalueMatrix", "Lnet/maizegenetics/matrixalgebra/Matrix/DoubleMatrix;", "getEigenvalues", "", "getEigenvectors", "tassel"})
public final class EJMLEigenvalueDecomposition
implements EigenvalueDecomposition {
    @NotNull
    private final EigenDecomposition_F64<DMatrixRMaj> myDecomposition;
    private final boolean isSymmetric;

    @NotNull
    public final EigenDecomposition_F64<DMatrixRMaj> getMyDecomposition() {
        return this.myDecomposition;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public double[] getEigenvalues() {
        int numberOfValues = this.myDecomposition.getNumberOfEigenvalues();
        double[] dArray = new double[numberOfValues];
        int n = 0;
        while (n < numberOfValues) {
            void ndx;
            double d;
            int n2 = n;
            int n3 = n++;
            double[] dArray2 = dArray;
            boolean bl = false;
            dArray2[n3] = d = this.myDecomposition.getEigenvalue((int)ndx).real;
        }
        return dArray;
    }

    @Override
    public double getEigenvalue(int i) {
        return this.myDecomposition.getEigenvalue((int)i).real;
    }

    @Override
    @NotNull
    public DoubleMatrix getEigenvectors() {
        DMatrixRMaj dMatrixRMaj = EigenOps_DDRM.createMatrixV(this.myDecomposition);
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"EigenOps_DDRM.createMatrixV(myDecomposition)");
        return new EJMLDoubleMatrix(dMatrixRMaj);
    }

    @Override
    @NotNull
    public DoubleMatrix getEigenvalueMatrix() {
        double[] dArray = this.getEigenvalues();
        DMatrixRMaj dMatrixRMaj = CommonOps_DDRM.diag((double[])Arrays.copyOf(dArray, dArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)dMatrixRMaj, (String)"CommonOps_DDRM.diag(*eigenvalues)");
        return new EJMLDoubleMatrix(dMatrixRMaj);
    }

    public final boolean isSymmetric() {
        return this.isSymmetric;
    }

    public EJMLEigenvalueDecomposition(@NotNull DMatrixRMaj matrix, boolean isSymmetric) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        this.isSymmetric = isSymmetric;
        EigenDecomposition_F64 eigenDecomposition_F64 = DecompositionFactory_DDRM.eig((int)matrix.numRows, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)eigenDecomposition_F64, (String)"DecompositionFactory_DDR\u2026atrix.numRows, true,true)");
        this.myDecomposition = eigenDecomposition_F64;
        DMatrixRMaj inputMatrix = this.myDecomposition.inputModified() ? matrix.copy() : matrix;
        boolean success = this.myDecomposition.decompose((Matrix)inputMatrix);
        boolean bl = false;
        boolean bl2 = false;
        if (!success) {
            boolean bl3 = false;
            String string = "EJML Eigenvalue decomposition failed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ EJMLEigenvalueDecomposition(DMatrixRMaj dMatrixRMaj, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(dMatrixRMaj, bl);
    }
}

