/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class CategoricalAttribute
implements PhenotypeAttribute {
    private final String name;
    private final int[] values;
    private final BitSet missing;
    private final String[] categoryNames;
    private final HashMap<String, Integer> nameToIndexMap;
    public static final String missingValue = "?";
    private static final List<Phenotype.ATTRIBUTE_TYPE> myAllowedTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();

    public CategoricalAttribute(String name, String[] stringValues) {
        int i;
        this.name = name;
        int n = stringValues.length;
        this.missing = new OpenBitSet(n);
        this.values = new int[n];
        TreeSet labelSet = Arrays.stream(stringValues).collect(TreeSet::new, TreeSet::add, TreeSet::addAll);
        int nlevels = labelSet.size();
        this.categoryNames = new String[nlevels];
        labelSet.toArray(this.categoryNames);
        this.nameToIndexMap = new HashMap();
        for (i = 0; i < nlevels; ++i) {
            this.nameToIndexMap.put(this.categoryNames[i], i);
        }
        for (i = 0; i < n; ++i) {
            this.values[i] = this.nameToIndexMap.get(stringValues[i]);
        }
    }

    public int intValue(int obs) {
        return this.values[obs];
    }

    public int[] allIntValues() {
        return this.values;
    }

    public String attributeLabelForIndex(int index) {
        return this.categoryNames[index];
    }

    public int indexForAttrLabel(String label) {
        return this.nameToIndexMap.get(label);
    }

    public String label(int obs) {
        return this.attributeLabelForIndex(this.values[obs]);
    }

    public String[] allLabels() {
        int n = this.values.length;
        String[] labels = new String[n];
        for (int i = 0; i < n; ++i) {
            if (this.values[i] == -1) {
                labels[i] = missingValue;
            }
            labels[i] = this.categoryNames[this.values[i]];
        }
        return labels;
    }

    public List<String> labelList() {
        return new ArrayList<String>(Arrays.asList(this.categoryNames));
    }

    public int numberOfLevels() {
        return this.categoryNames.length;
    }

    public int[] whichObservations(int level) {
        int nvalues = this.values.length;
        int[] obs = new int[nvalues];
        int obsCount = 0;
        for (int i = 0; i < nvalues; ++i) {
            if (this.values[i] != level) continue;
            obs[obsCount++] = i;
        }
        return Arrays.copyOf(obs, obsCount);
    }

    public int[] whichObservations(String factorName) {
        int nvalues = this.values.length;
        int[] obs = new int[nvalues];
        int obsCount = 0;
        for (int i = 0; i < nvalues; ++i) {
            if (!this.categoryNames[this.values[i]].equals(factorName)) continue;
            obs[obsCount++] = i;
        }
        return Arrays.copyOf(obs, obsCount);
    }

    @Override
    public Object value(int obs) {
        return this.categoryNames[this.values[obs]];
    }

    @Override
    public Object allValues() {
        return this.allLabels();
    }

    @Override
    public PhenotypeAttribute subset(int[] obs, String newName) {
        int n = obs.length;
        String[] labels = new String[n];
        for (int i = 0; i < n; ++i) {
            labels[i] = this.values[obs[i]] == -1 ? missingValue : this.categoryNames[this.values[obs[i]]];
        }
        if (newName == null) {
            newName = this.name;
        }
        return new CategoricalAttribute(newName, labels);
    }

    @Override
    public PhenotypeAttribute changeName(String newName) {
        return new CategoricalAttribute(newName, this.allLabels());
    }

    @Override
    public boolean isMissing(int obs) {
        return this.missing.fastGet(obs);
    }

    @Override
    public BitSet missing() {
        return this.missing;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public List<Phenotype.ATTRIBUTE_TYPE> getCompatibleTypes() {
        return myAllowedTypes;
    }

    @Override
    public boolean isTypeCompatible(Phenotype.ATTRIBUTE_TYPE type) {
        return myAllowedTypes.contains((Object)type);
    }

    public String toString() {
        return this.name();
    }

    static {
        myAllowedTypes.add(Phenotype.ATTRIBUTE_TYPE.factor);
    }
}

