/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.CorePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

public class FilterPhenotype
implements Phenotype {
    private int[] myRowRedirect;
    private int numberOfObservations;
    private CorePhenotype basePhenotype;
    private String name;

    FilterPhenotype(CorePhenotype basePheno, List<Taxon> taxaToKeep, String name) {
        this.basePhenotype = basePheno;
        TaxaAttribute myTaxaAttribute = basePheno.taxaAttribute();
        List<Taxon> baseTaxa = myTaxaAttribute.allTaxaAsList();
        int numberOfBaseObservations = basePheno.numberOfObservations();
        this.myRowRedirect = new int[numberOfBaseObservations];
        int obsCount = 0;
        int baseTaxonCount = 0;
        for (Taxon baseTaxon : baseTaxa) {
            if (taxaToKeep.contains(baseTaxon)) {
                this.myRowRedirect[obsCount++] = baseTaxonCount;
            }
            ++baseTaxonCount;
        }
        this.myRowRedirect = Arrays.copyOf(this.myRowRedirect, obsCount);
        this.numberOfObservations = obsCount;
        this.name = name;
    }

    FilterPhenotype(FilterPhenotype basePheno, List<Taxon> taxaToKeep, String name) {
        int numberOfBaseObservations = basePheno.numberOfObservations();
        TaxaAttribute myTaxaAttribute = basePheno.taxaAttribute();
        this.myRowRedirect = new int[numberOfBaseObservations];
        List<Taxon> baseTaxa = myTaxaAttribute.allTaxaAsList();
        int obsCount = 0;
        int baseTaxonCount = 0;
        for (Taxon baseTaxon : baseTaxa) {
            if (taxaToKeep.contains(baseTaxon)) {
                this.myRowRedirect[obsCount++] = basePheno.myRowRedirect[baseTaxonCount];
            }
            ++baseTaxonCount;
        }
        this.myRowRedirect = Arrays.copyOf(this.myRowRedirect, obsCount);
        this.basePhenotype = basePheno.basePhenotype;
        this.numberOfObservations = obsCount;
        this.name = name;
    }

    static FilterPhenotype getInstance(Phenotype basePheno, List<Taxon> taxaToKeep, String name) {
        if (basePheno instanceof CorePhenotype) {
            return new FilterPhenotype((CorePhenotype)basePheno, taxaToKeep, name);
        }
        if (basePheno instanceof FilterPhenotype) {
            return new FilterPhenotype((FilterPhenotype)basePheno, taxaToKeep, name);
        }
        return null;
    }

    @Override
    public Object[] getTableColumnNames() {
        return this.basePhenotype.getTableColumnNames();
    }

    @Override
    public String getTableTitle() {
        return this.name;
    }

    @Override
    public int getColumnCount() {
        return this.basePhenotype.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.numberOfObservations;
    }

    @Override
    public long getElementCount() {
        return this.getRowCount() * (long)this.getColumnCount();
    }

    @Override
    public Object[] getRow(long row) {
        return this.basePhenotype.getRow(this.myRowRedirect[(int)row]);
    }

    @Override
    public Object getValueAt(long row, int col) {
        return this.basePhenotype.getValueAt(this.myRowRedirect[(int)row], col);
    }

    @Override
    public Object value(int obs, int attrnum) {
        return this.basePhenotype.value(this.myRowRedirect[obs], attrnum);
    }

    @Override
    public boolean isMissing(int obs, int attrnum) {
        return this.basePhenotype.isMissing(this.myRowRedirect[obs], attrnum);
    }

    @Override
    public PhenotypeAttribute attribute(int attrnum) {
        return this.basePhenotype.attribute(attrnum).subset(this.myRowRedirect, null);
    }

    @Override
    public int indexOfAttribute(PhenotypeAttribute attribute) {
        return this.basePhenotype.indexOfAttribute(attribute);
    }

    @Override
    public List<PhenotypeAttribute> attributeListCopy() {
        ArrayList<PhenotypeAttribute> attrList = new ArrayList<PhenotypeAttribute>();
        for (int i = 0; i < this.numberOfAttributes(); ++i) {
            attrList.add(this.attribute(i));
        }
        return attrList;
    }

    @Override
    public List<PhenotypeAttribute> attributeListOfType(Phenotype.ATTRIBUTE_TYPE type) {
        int[] indices = this.attributeIndicesOfType(type);
        ArrayList<PhenotypeAttribute> attrList = new ArrayList<PhenotypeAttribute>();
        for (int ndx : indices) {
            attrList.add(this.attribute(ndx));
        }
        return attrList;
    }

    @Override
    public Stream<PhenotypeAttribute> attributeStream() {
        return IntStream.range(0, this.numberOfAttributes()).mapToObj(i -> this.attribute(i));
    }

    @Override
    public Stream<NumericAttribute> dataAttributeStream() {
        return IntStream.iterate(0, i -> i + 1).limit(this.numberOfAttributes()).filter(i -> this.attributeType(i) == Phenotype.ATTRIBUTE_TYPE.data).mapToObj(i -> (NumericAttribute)this.attribute(i));
    }

    @Override
    public Stream<NumericAttribute> covariateAttributeStream() {
        return IntStream.iterate(0, i -> i + 1).limit(this.numberOfAttributes()).filter(i -> this.attributeType(i) == Phenotype.ATTRIBUTE_TYPE.covariate).mapToObj(i -> (NumericAttribute)this.attribute(i));
    }

    @Override
    public Stream<CategoricalAttribute> factorAttributeStream() {
        return IntStream.iterate(0, i -> i + 1).limit(this.numberOfAttributes()).filter(i -> this.attributeType(i) == Phenotype.ATTRIBUTE_TYPE.factor).mapToObj(i -> (CategoricalAttribute)this.attribute(i));
    }

    @Override
    public List<Phenotype.ATTRIBUTE_TYPE> typeListCopy() {
        return this.basePhenotype.typeListCopy();
    }

    @Override
    public int numberOfAttributes() {
        return this.basePhenotype.numberOfAttributes;
    }

    @Override
    public int numberOfObservations() {
        return this.numberOfObservations;
    }

    @Override
    public TaxaList taxa() {
        if (!this.basePhenotype.hasTaxaAttribute()) {
            return null;
        }
        Taxon[] taxaArray = this.basePhenotype.taxaAttribute().allTaxa();
        TreeSet<Taxon> taxaSet = new TreeSet<Taxon>();
        for (int ndx : this.myRowRedirect) {
            taxaSet.add(taxaArray[ndx]);
        }
        return new TaxaListBuilder().addAll(taxaSet).build();
    }

    @Override
    public int numberOfAttributesOfType(Phenotype.ATTRIBUTE_TYPE type) {
        return this.basePhenotype.numberOfAttributesOfType(type);
    }

    @Override
    public int[] attributeIndicesOfType(Phenotype.ATTRIBUTE_TYPE type) {
        return this.basePhenotype.attributeIndicesOfType(type);
    }

    @Override
    public Phenotype.ATTRIBUTE_TYPE attributeType(int attrnum) {
        return this.basePhenotype.attributeType(attrnum);
    }

    @Override
    public String attributeName(int attrnum) {
        return this.basePhenotype.attributeName(attrnum);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasTaxaAttribute() {
        return this.basePhenotype.hasTaxaAttribute();
    }

    @Override
    public TaxaAttribute taxaAttribute() {
        return (TaxaAttribute)this.basePhenotype.taxaAttribute().subset(this.myRowRedirect, null);
    }

    @Override
    public int attributeIndexForName(String name) {
        return this.basePhenotype.attributeIndexForName(name);
    }

    @Override
    public boolean areTaxaReplicated() {
        int numberOfUniqueTaxa = this.taxa().size();
        return numberOfUniqueTaxa > this.numberOfObservations;
    }

    @Override
    public Phenotype asCorePhenotype() {
        List<PhenotypeAttribute> allAttributes = IntStream.iterate(0, i -> i + 1).limit(this.numberOfAttributes()).mapToObj(i -> this.attribute(i)).collect(Collectors.toList());
        return new PhenotypeBuilder().fromAttributeList(allAttributes, this.basePhenotype.typeListCopy()).build().get(0);
    }
}

