/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import net.maizegenetics.analysis.filter.FilterTaxaBuilderPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListUtils;

public class GenotypePhenotypeBuilder {
    Phenotype myPhenotype = null;
    GenotypeTable myGenotype = null;
    boolean isUnion = false;
    String myName = null;

    public GenotypePhenotypeBuilder phenotype(Phenotype thePhenotype) {
        this.myPhenotype = thePhenotype;
        return this;
    }

    public GenotypePhenotypeBuilder genotype(GenotypeTable theGenotype) {
        this.myGenotype = theGenotype;
        return this;
    }

    public GenotypePhenotypeBuilder union() {
        this.isUnion = true;
        return this;
    }

    public GenotypePhenotypeBuilder intersect() {
        this.isUnion = false;
        return this;
    }

    public GenotypePhenotypeBuilder name(String name) {
        this.myName = name;
        return this;
    }

    public GenotypePhenotype build() {
        if (this.myPhenotype == null) {
            throw new IllegalArgumentException("Error: no phenotype data set was specified.");
        }
        if (this.myGenotype == null) {
            throw new IllegalArgumentException("Error: no genotype data set was specified.");
        }
        if (this.myName == null) {
            this.myName = this.myPhenotype.name() + "_with_genotypes";
        }
        if (!this.isUnion) {
            TaxaList commonTaxa = TaxaListUtils.getCommonTaxa(this.myGenotype.taxa(), this.myPhenotype.taxa());
            if (this.myGenotype.taxa().numberOfTaxa() > commonTaxa.numberOfTaxa()) {
                this.myGenotype = new FilterTaxaBuilderPlugin().taxaList(commonTaxa).runPlugin(this.myGenotype);
            }
            if (this.myPhenotype.taxa().numberOfTaxa() > commonTaxa.numberOfTaxa()) {
                this.myPhenotype = new PhenotypeBuilder().fromPhenotype(this.myPhenotype).keepTaxa(commonTaxa).build().get(0);
            }
        }
        return new GenotypePhenotype(this.myGenotype, this.myPhenotype, this.myName);
    }
}

