/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.maizegenetics.phenotype.CorePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.TableReportUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class PhenotypeUtils {
    private static final Logger myLogger = Logger.getLogger(PhenotypeUtils.class);
    private static final String DELIMITER = "\t";

    private PhenotypeUtils() {
    }

    public static void write(Phenotype phenotype, String filename) {
        try (BufferedWriter writer = Utils.getBufferedWriter(filename);){
            int i;
            writer.write("<Phenotype>\n");
            for (i = 0; i < phenotype.numberOfAttributes(); ++i) {
                if (i != 0) {
                    writer.write(DELIMITER);
                }
                writer.write(phenotype.attributeType(i).name());
            }
            writer.write("\n");
            for (i = 0; i < phenotype.numberOfAttributes(); ++i) {
                if (i != 0) {
                    writer.write(DELIMITER);
                }
                writer.write(phenotype.attributeName(i));
            }
            writer.write("\n");
            TableReportUtils.saveDelimitedTableReport(phenotype, DELIMITER, writer, false);
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("PhenotypeUtils: write: problem saving file: " + filename);
        }
    }

    public static void writePlink(Phenotype phenotype, String filename) {
        try (BufferedWriter writer = Utils.getBufferedWriter(filename);){
            writer.write("FID");
            writer.write(DELIMITER);
            writer.write("IID");
            for (int i = 0; i < phenotype.numberOfAttributes(); ++i) {
                if (phenotype.attributeType(i) != Phenotype.ATTRIBUTE_TYPE.data && phenotype.attributeType(i) != Phenotype.ATTRIBUTE_TYPE.covariate) continue;
                writer.write(DELIMITER);
                writer.write(phenotype.attributeName(i));
            }
            writer.write("\n");
            int numObservations = phenotype.numberOfObservations();
            for (int i = 0; i < numObservations; ++i) {
                String taxonName = phenotype.value(i, 0).toString();
                writer.write(taxonName);
                writer.write(DELIMITER);
                writer.write(taxonName);
                writer.write(DELIMITER);
                for (int j = 1; j < phenotype.numberOfAttributes(); ++j) {
                    if (phenotype.attributeType(j) != Phenotype.ATTRIBUTE_TYPE.data && phenotype.attributeType(j) != Phenotype.ATTRIBUTE_TYPE.covariate) continue;
                    writer.write(DELIMITER);
                    String value = phenotype.value(i, j).toString();
                    if (value.equalsIgnoreCase("NaN")) {
                        writer.write("NA");
                        continue;
                    }
                    writer.write(value);
                }
                writer.write("\n");
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("PhenotypeUtils: writePlink: problem saving file: " + filename);
        }
    }

    public static Phenotype createPhenotypeObjectFromDB(ArrayList<ArrayList<String>> phenos) {
        ArrayList taxaNames = (ArrayList)phenos.get(1).stream().distinct().collect(Collectors.toList());
        Collections.sort(taxaNames);
        HashMap<String, ArrayListMultimap> phenotypeMapping = new HashMap<String, ArrayListMultimap>();
        for (String taxa : taxaNames) {
            phenotypeMapping.put(taxa, ArrayListMultimap.create());
        }
        for (int i = 0; i < phenos.get(0).size(); ++i) {
            ((ListMultimap)phenotypeMapping.get(phenos.get(1).get(i))).put((Object)phenos.get(3).get(i), (Object)phenos.get(4).get(i));
        }
        ArrayList variableNames = (ArrayList)phenos.get(3).stream().distinct().collect(Collectors.toList());
        Collections.sort(variableNames);
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>();
        for (String taxaName : taxaNames) {
            taxaList.add(new Taxon(taxaName));
        }
        HashMap attributeMap = new HashMap();
        for (int i = 0; i < variableNames.size(); ++i) {
            double[] currentAttribute = new double[taxaNames.size()];
            for (int j = 0; j < taxaNames.size(); ++j) {
                currentAttribute[j] = Double.parseDouble((String)((ListMultimap)phenotypeMapping.get(taxaNames.get(j))).get(variableNames.get(i)).get(0));
            }
            attributeMap.put(variableNames.get(i), currentAttribute);
        }
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(variableNames.size() + 1);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(variableNames.size() + 1);
        attributes.add(new TaxaAttribute(taxaList));
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (String variable : variableNames) {
            attributes.add(new NumericAttribute(variable, (double[])attributeMap.get(variable)));
            types.add(Phenotype.ATTRIBUTE_TYPE.data);
        }
        return new CorePhenotype(attributes, types, "B4R_Phenotype");
    }

    public static Phenotype createPhenotypeObjectFromDB2(ArrayList<ArrayList<String>> phenos) {
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>();
        HashMap<Integer, String> plotNoToTaxaNameMap = new HashMap<Integer, String>();
        ArrayList<Integer> plotNoMapping = new ArrayList<Integer>();
        for (int i = 0; i < phenos.get(0).size(); ++i) {
            plotNoToTaxaNameMap.put(Integer.parseInt(phenos.get(2).get(i)), phenos.get(1).get(i));
        }
        System.out.println("Size of map: " + plotNoToTaxaNameMap.size());
        ArrayList taxaNames = new ArrayList();
        for (Integer key : plotNoToTaxaNameMap.keySet()) {
            plotNoMapping.add(key);
            taxaNames.add(plotNoToTaxaNameMap.get(key));
            taxaList.add(new Taxon((String)plotNoToTaxaNameMap.get(key)));
        }
        ArrayList variableNames = (ArrayList)phenos.get(3).stream().distinct().collect(Collectors.toList());
        Collections.sort(variableNames);
        HashMap phenotypeMapping = new HashMap();
        for (int i = 0; i < phenos.get(0).size(); ++i) {
            if (!phenotypeMapping.containsKey(Integer.parseInt(phenos.get(2).get(i)))) {
                phenotypeMapping.put(Integer.parseInt(phenos.get(2).get(i)), new HashMap());
            }
            ((HashMap)phenotypeMapping.get(Integer.parseInt(phenos.get(2).get(i)))).put(phenos.get(3).get(i), Double.parseDouble(phenos.get(4).get(i)));
        }
        System.out.println("Size of full phenoMap: " + phenotypeMapping.size());
        HashMap attributeMap = new HashMap();
        for (int i = 0; i < variableNames.size(); ++i) {
            double[] currentAttribute = new double[taxaNames.size()];
            for (int j = 0; j < taxaList.size(); ++j) {
                currentAttribute[j] = (Double)((HashMap)phenotypeMapping.get(plotNoMapping.get(j))).get(variableNames.get(i));
            }
            attributeMap.put(variableNames.get(i), currentAttribute);
        }
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(variableNames.size() + 1);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(variableNames.size() + 1);
        attributes.add(new TaxaAttribute(taxaList));
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (String variable : variableNames) {
            attributes.add(new NumericAttribute(variable, (double[])attributeMap.get(variable)));
            types.add(Phenotype.ATTRIBUTE_TYPE.data);
        }
        System.out.println("Number of attributes: " + attributes.size());
        return new CorePhenotype(attributes, types, "B4R_Phenotype");
    }

    public static Phenotype createPhenotypeFromTransform(ArrayList<String> taxaListNames, ArrayList<String> variableNames, List<ArrayList<Double>> data, String outputObjectName, ArrayList<Phenotype.ATTRIBUTE_TYPE> types) throws Exception {
        boolean taxaCorrectSize = true;
        boolean variableCorrectSize = true;
        if (taxaListNames.size() != data.size()) {
            taxaCorrectSize = false;
        }
        if (variableNames.size() != data.get(0).size()) {
            variableCorrectSize = false;
        }
        if (!taxaCorrectSize && !variableCorrectSize) {
            throw new Exception("Error Size of Taxa names and Variable names do not match:\nNumber of taxa: " + taxaListNames.size() + " Number of samples: " + data.size() + "\nNumber of variables: " + variableNames.size() + " Number of columns: " + data.get(0).size());
        }
        if (!taxaCorrectSize) {
            throw new Exception("Error: Number of Taxa Names and Number of samples does not match: Number of taxa: " + taxaListNames.size() + " Number of samples: " + data.size());
        }
        if (!variableCorrectSize) {
            throw new Exception("Error: Number of Variable Names and Number of columns does not match: Number of variables: " + variableNames.size() + " Number of columns: " + data.get(0).size());
        }
        ArrayList taxaList = (ArrayList)taxaListNames.stream().map(name -> new Taxon((String)name)).collect(Collectors.toList());
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(variableNames.size() + 1);
        attributes.add(new TaxaAttribute(taxaList));
        for (int col = 0; col < data.get(0).size(); ++col) {
            double[] currentColumnValues = new double[data.size()];
            for (int row = 0; row < data.size(); ++row) {
                currentColumnValues[row] = data.get(row).get(col);
            }
            attributes.add(new NumericAttribute(variableNames.get(col), currentColumnValues));
        }
        System.out.println("Number of Taxa: " + taxaListNames.size() + " Number of attributes: " + attributes.size());
        return new CorePhenotype(attributes, types, outputObjectName);
    }
}

