/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.pipeline;

import java.io.BufferedReader;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.analysis.association.RidgeRegressionEmmaPlugin;
import net.maizegenetics.analysis.association.WeightedMLMPlugin;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.chart.ManhattanDisplayPlugin;
import net.maizegenetics.analysis.chart.TableDisplayPlugin;
import net.maizegenetics.analysis.data.CombineDataSetsPlugin;
import net.maizegenetics.analysis.data.ConvertAlignmentCoordinatesPlugin;
import net.maizegenetics.analysis.data.ExportMultiplePlugin;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.data.HetsToUnknownPlugin;
import net.maizegenetics.analysis.data.IntersectionAlignmentPlugin;
import net.maizegenetics.analysis.data.MemoryUsagePlugin;
import net.maizegenetics.analysis.data.MergeAlignmentsSameSitesPlugin;
import net.maizegenetics.analysis.data.MergeGenotypeTablesPlugin;
import net.maizegenetics.analysis.data.PlinkLoadPlugin;
import net.maizegenetics.analysis.data.PrincipalComponentsPlugin;
import net.maizegenetics.analysis.data.ProjectionLoadPlugin;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.analysis.data.SynonymizerPlugin;
import net.maizegenetics.analysis.data.UnionAlignmentPlugin;
import net.maizegenetics.analysis.distance.DistanceMatrixPlugin;
import net.maizegenetics.analysis.distance.DistanceMatrixRangesPlugin;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.analysis.filter.FilterSiteBuilderPlugin;
import net.maizegenetics.analysis.filter.FilterSiteNamePlugin;
import net.maizegenetics.analysis.filter.FilterSubsetPlugin;
import net.maizegenetics.analysis.filter.FilterTaxaBuilderPlugin;
import net.maizegenetics.analysis.filter.FilterTraitsPlugin;
import net.maizegenetics.analysis.popgen.LinkageDiseqDisplayPlugin;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumPlugin;
import net.maizegenetics.analysis.popgen.SequenceDiversityPlugin;
import net.maizegenetics.analysis.tree.ArchaeopteryxPlugin;
import net.maizegenetics.analysis.tree.CreateTreePlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.TagsOnPhysMapHDF5;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.pipeline.TasselPipelineStepsDialog;
import net.maizegenetics.pipeline.TasselPipelineXMLUtil;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.ParameterCache;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.progress.ProgressPanel;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.tassel.TasselLogging;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.LoggingUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TasselPipeline
implements PluginListener {
    private static final Logger myLogger = Logger.getLogger(TasselPipeline.class);
    private final TASSELMainFrame myMainFrame;
    private final Map<String, List<Plugin>> myForks = new LinkedHashMap<String, List<Plugin>>();
    private String myCurrentFork = null;
    private List<Plugin> myCurrentPipe = null;
    private Plugin myFirstPlugin = null;
    private final List<ThreadedPluginListener> myThreads = new ArrayList<ThreadedPluginListener>();
    private final Map<Plugin, Integer> myProgressValues = new HashMap<Plugin, Integer>();
    private final StringBuilder myDeprecatedWarning = new StringBuilder();
    private final boolean myIsInteractive;
    private final boolean myIsThreaded;
    private TasselPipelineStepsDialog myStepsDialog = null;
    private String[] myDescriptions = null;
    private int myCurrentDescriptionIndex = 0;

    public TasselPipeline(String[] args, TASSELMainFrame frame) {
        this(args, frame, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TasselPipeline(String[] args, TASSELMainFrame frame, boolean interactive, String name) {
        ExecutorService pool;
        this.myMainFrame = frame;
        this.myIsInteractive = interactive;
        boolean bl = this.myIsThreaded = !this.myIsInteractive;
        if (args.length == 1 && args[0].equalsIgnoreCase("-versionComment")) {
            System.out.println("Version 5.2.76 on October 26, 2021");
            return;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("-versionTag")) {
            System.out.println("V5.2.76");
            return;
        }
        if (frame == null) {
            TasselLogging.basicLoggingInfo();
        }
        if (this.myIsInteractive) {
            pool = null;
        } else {
            int numThreads = Runtime.getRuntime().availableProcessors() / 2;
            numThreads = Math.max(2, numThreads);
            pool = Executors.newFixedThreadPool(numThreads);
        }
        try {
            Object progressPanel;
            if (this.myIsInteractive) {
                this.myStepsDialog = new TasselPipelineStepsDialog(this.myMainFrame, name);
            }
            this.parseArgs(args);
            for (Map.Entry<String, List<Plugin>> fork : this.myForks.entrySet()) {
                Plugin first;
                List<Plugin> current2 = fork.getValue();
                if (current2 == null || current2.isEmpty() || !((first = current2.get(0)) instanceof AbstractPlugin) || !((AbstractPlugin)first).getInputs().isEmpty()) continue;
                boolean alreadyRun = false;
                for (ThreadedPluginListener currentListener : this.myThreads) {
                    if (currentListener.getPluginListener() != first) continue;
                    alreadyRun = true;
                    break;
                }
                if (alreadyRun) continue;
                PluginEvent event = new PluginEvent(new DataSet((Datum)null, null));
                ThreadedPluginListener thread = new ThreadedPluginListener(first, event);
                this.myThreads.add(thread);
            }
            if (this.myMainFrame != null && !this.myIsInteractive && (progressPanel = this.myMainFrame.getProgressPanel()) != null) {
                for (String key : this.myForks.keySet()) {
                    List<Plugin> current3 = this.myForks.get(key);
                    ((ProgressPanel)progressPanel).addPipelineSegment(current3);
                }
            }
            if (this.myIsInteractive) {
                this.myStepsDialog.showDialog();
                for (ThreadedPluginListener current4 : this.myThreads) {
                    try {
                        current4.run();
                        if (!((Plugin)current4.getPluginListener()).wasCancelled()) continue;
                    }
                    catch (Exception ex) {
                        myLogger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    break;
                }
            } else {
                ArrayList futures = new ArrayList();
                this.myThreads.stream().forEach(current -> futures.add(pool.submit((Runnable)current)));
                for (Future future : futures) {
                    future.get();
                }
            }
            if (this.myDeprecatedWarning.length() != 0) {
                myLogger.warn((Object)this.myDeprecatedWarning.toString());
            }
        }
        catch (Exception e) {
            myLogger.error((Object)e.getMessage(), (Throwable)e);
            if (this.myIsInteractive) {
                throw new IllegalStateException("TasselPipeline: init: " + e.getMessage());
            }
            System.exit(1);
        }
        finally {
            if (pool != null) {
                pool.shutdown();
            }
        }
    }

    public static void main(String[] args) {
        String emDash = "\u2014";
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].replaceFirst(emDash, "-");
        }
        TasselPrefs.setPersistPreferences(false);
        LoggingUtils.setupLogging();
        if (args.length >= 2 && args[0].equalsIgnoreCase("-createXML")) {
            String xmlFilename = args[1].trim();
            String[] temp = new String[args.length - 2];
            System.arraycopy(args, 2, temp, 0, temp.length);
            temp = TasselPipeline.addForkFlagsIfNeeded(temp);
            TasselPipelineXMLUtil.writeArgsAsXML(xmlFilename, temp);
            return;
        }
        if (args.length >= 2 && args[0].equalsIgnoreCase("-translateXML")) {
            String xmlFilename = args[1].trim();
            String[][] result = TasselPipelineXMLUtil.readXMLAsArgs(xmlFilename);
            for (int i = 0; i < result[0].length; ++i) {
                System.out.print(result[0][i]);
                System.out.print(" ");
            }
            System.out.println("");
            return;
        }
        String[] currentArgs = args;
        boolean notDone = true;
        while (notDone) {
            String[] temp;
            String filename;
            if (currentArgs.length >= 1 && (currentArgs[0].equalsIgnoreCase("-debug") || currentArgs[0].equalsIgnoreCase("-log"))) {
                filename = null;
                if (currentArgs.length >= 2) {
                    filename = currentArgs[1].trim();
                }
                if (filename != null && !filename.startsWith("-")) {
                    try {
                        if (currentArgs[0].equalsIgnoreCase("-debug")) {
                            LoggingUtils.setupDebugLogfile(filename);
                        } else {
                            LoggingUtils.setupLogfile(filename);
                        }
                    }
                    catch (Exception e) {
                        myLogger.error((Object)("Problem with file: " + filename + "\n" + e.getMessage()));
                    }
                    temp = new String[currentArgs.length - 2];
                    System.arraycopy(currentArgs, 2, temp, 0, temp.length);
                    currentArgs = temp;
                    continue;
                }
                if (currentArgs[0].equalsIgnoreCase("-debug")) {
                    LoggingUtils.setupDebugLogging();
                } else {
                    LoggingUtils.setupLogging();
                }
                temp = new String[currentArgs.length - 1];
                System.arraycopy(currentArgs, 1, temp, 0, temp.length);
                currentArgs = temp;
                continue;
            }
            if (currentArgs.length >= 2 && currentArgs[0].equalsIgnoreCase("-configParameters")) {
                filename = currentArgs[1].trim();
                if (!new File(filename).isFile()) {
                    throw new IllegalArgumentException("TasselPipeline: main: -configParameters file: " + filename + " doesn't exist or isn't a file.");
                }
                ParameterCache.load(filename);
                temp = new String[currentArgs.length - 2];
                System.arraycopy(currentArgs, 2, temp, 0, temp.length);
                currentArgs = temp;
                continue;
            }
            notDone = false;
        }
        new TasselPipeline(currentArgs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseArgs(String[] input) {
        String[][] tempArgsDesc;
        String xmlFilename;
        String[] args = input;
        if (args.length >= 1 && args[0].equalsIgnoreCase("-configFile")) {
            if (args.length < 2) {
                throw new IllegalArgumentException("TasselPipeline: parseArgs: a filename must follow -configFile flag.");
            }
            xmlFilename = args[1].trim();
            tempArgsDesc = TasselPipelineXMLUtil.readXMLAsArgs(xmlFilename);
            args = tempArgsDesc[0];
            this.myDescriptions = tempArgsDesc[1];
        } else if (args.length >= 1 && args[0].equalsIgnoreCase("-configResourceFile")) {
            if (args.length < 2) {
                throw new IllegalArgumentException("TasselPipeline: parseArgs: a filename must follow -configResourceFile flag.");
            }
            xmlFilename = args[1].trim();
            tempArgsDesc = TasselPipelineXMLUtil.readXMLAsArgsFromResource(xmlFilename);
            args = tempArgsDesc[0];
            this.myDescriptions = tempArgsDesc[1];
            if (this.myStepsDialog != null && tempArgsDesc[2] != null) {
                if (tempArgsDesc[2][0] != null) {
                    this.myStepsDialog.setOverallDescription(tempArgsDesc[2][0]);
                }
                if (tempArgsDesc[2][1] != null) {
                    this.myStepsDialog.setCitation(tempArgsDesc[2][1]);
                }
            }
        } else {
            args = TasselPipeline.addForkFlagsIfNeeded(args);
        }
        StringBuilder argsStr = new StringBuilder();
        argsStr.append("[");
        boolean print = true;
        boolean first = true;
        for (String current : args) {
            if (first) {
                first = false;
            } else {
                argsStr.append(", ");
            }
            if (print) {
                argsStr.append(current);
            } else {
                argsStr.append("?????");
                print = true;
            }
            if (!current.toUpperCase().contains("PASSWORD")) continue;
            print = false;
        }
        argsStr.append("]");
        myLogger.info((Object)("Tassel Pipeline Arguments: " + argsStr.toString()));
        int index = 0;
        while (index < args.length) {
            this.myCurrentDescriptionIndex = index;
            try {
                Taxon[] ids;
                int i;
                String inputline;
                Plugin plugin;
                String file;
                String hdf5File;
                String key;
                String current = args[index++];
                String emDash = "\u2014";
                current = current.replaceFirst(emDash, "-");
                if (!current.startsWith("-")) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: expecting argument beginning with dash: " + current);
                }
                if (current.startsWith("-runfork")) {
                    key = current.replaceFirst("-runfork", "-fork");
                    List<Plugin> specifiedPipe = this.myForks.get(key);
                    if (specifiedPipe == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: unknown fork: " + current);
                    }
                    if (specifiedPipe.isEmpty()) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: empty fork: " + current);
                    }
                    if (specifiedPipe.get(0) instanceof AbstractPlugin && !((AbstractPlugin)specifiedPipe.get(0)).getInputs().isEmpty()) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: this fork does not need to be explicitly run: it is receiving input from another plugin: " + current);
                    }
                    PluginEvent event = new PluginEvent(new DataSet((Datum)null, null));
                    ThreadedPluginListener thread = new ThreadedPluginListener(specifiedPipe.get(0), event);
                    this.myThreads.add(thread);
                    continue;
                }
                if (current.startsWith("-fork")) {
                    if (this.myCurrentPipe != null && !this.myCurrentPipe.isEmpty()) {
                        this.myCurrentPipe.get(this.myCurrentPipe.size() - 1).setThreaded(this.myIsThreaded);
                    }
                    this.myCurrentFork = current;
                    this.myCurrentPipe = new ArrayList<Plugin>();
                    this.myForks.put(this.myCurrentFork, this.myCurrentPipe);
                    continue;
                }
                if (current.startsWith("-input")) {
                    key = current.replaceFirst("-input", "-fork");
                    List<Plugin> specifiedPipe = this.myForks.get(key);
                    if (specifiedPipe == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: unknown input: " + current);
                    }
                    Plugin lastCurrentPipe = null;
                    try {
                        lastCurrentPipe = this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -input must come after plugin in current fork.");
                    }
                    Plugin endSpecifiedPipe = specifiedPipe.get(specifiedPipe.size() - 1);
                    lastCurrentPipe.receiveInput(endSpecifiedPipe);
                    continue;
                }
                if (current.startsWith("-inputOnce")) {
                    key = current.replaceFirst("-input", "-fork");
                    List<Plugin> specifiedPipe = this.myForks.get(key);
                    if (specifiedPipe == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: unknown input: " + current);
                    }
                    CombineDataSetsPlugin combinePlugin = null;
                    try {
                        combinePlugin = (CombineDataSetsPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -inputOnce must follow -combine flag.");
                    }
                    Plugin endSpecifiedPipe = specifiedPipe.get(specifiedPipe.size() - 1);
                    combinePlugin.receiveDataSetOnceFrom(endSpecifiedPipe);
                    continue;
                }
                if (current.startsWith("-combine")) {
                    current = current.replaceFirst("-combine", "-fork");
                    if (this.myCurrentPipe != null && !this.myCurrentPipe.isEmpty()) {
                        this.myCurrentPipe.get(this.myCurrentPipe.size() - 1).setThreaded(this.myIsThreaded);
                    }
                    this.myCurrentFork = current;
                    this.myCurrentPipe = new ArrayList<Plugin>();
                    this.myForks.put(this.myCurrentFork, this.myCurrentPipe);
                    this.integratePlugin(new CombineDataSetsPlugin(), false);
                    continue;
                }
                if (current.equalsIgnoreCase("-maxThreads")) {
                    String str = args[index++].trim();
                    int numThreads = -1;
                    try {
                        numThreads = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with number of max threads: " + str);
                    }
                    TasselPrefs.putMaxThreads(numThreads);
                    continue;
                }
                if (current.equalsIgnoreCase("-t")) {
                    String traitFile = args[index++].trim();
                    this.loadFile(traitFile, FileLoadPlugin.TasselFileType.Phenotype);
                    continue;
                }
                if (current.equalsIgnoreCase("-s")) {
                    String inputFile = args[index++].trim();
                    this.loadFile(inputFile, FileLoadPlugin.TasselFileType.Sequence);
                    continue;
                }
                if (current.equalsIgnoreCase("-k")) {
                    String kinshipFile = args[index++].trim();
                    this.loadFile(kinshipFile, FileLoadPlugin.TasselFileType.SqrMatrix);
                    continue;
                }
                if (current.equalsIgnoreCase("-q")) {
                    String populationFile = args[index++].trim();
                    this.loadFile(populationFile, FileLoadPlugin.TasselFileType.Phenotype);
                    continue;
                }
                if (current.equalsIgnoreCase("-h")) {
                    String hapFile = args[index++].trim();
                    this.loadFile(hapFile, FileLoadPlugin.TasselFileType.Hapmap);
                    continue;
                }
                if (current.equalsIgnoreCase("-h5")) {
                    hdf5File = args[index++].trim();
                    this.loadFile(hdf5File, FileLoadPlugin.TasselFileType.HDF5);
                    continue;
                }
                if (current.equalsIgnoreCase("-hdf5Schema")) {
                    hdf5File = args[index++].trim();
                    this.loadFile(hdf5File, FileLoadPlugin.TasselFileType.HDF5Schema);
                    continue;
                }
                if (current.equalsIgnoreCase("-r")) {
                    String phenotypeFile = args[index++].trim();
                    this.loadFile(phenotypeFile, FileLoadPlugin.TasselFileType.Phenotype);
                    continue;
                }
                if (current.equalsIgnoreCase("-plink")) {
                    String pedFile = null;
                    String mapFile = null;
                    for (int i2 = 0; i2 < 2; ++i2) {
                        String fileType = args[index++].trim();
                        String filename = args[index++].trim();
                        if (fileType.equalsIgnoreCase("-ped")) {
                            pedFile = filename;
                            continue;
                        }
                        if (fileType.equalsIgnoreCase("-map")) {
                            mapFile = filename;
                            continue;
                        }
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -plink: unknown file type: " + fileType);
                    }
                    if (pedFile == null || mapFile == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -plink must specify both ped and map files.");
                    }
                    PlinkLoadPlugin plugin2 = new PlinkLoadPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin2, true);
                    plugin2.pedFile(pedFile);
                    plugin2.mapFile(mapFile);
                    continue;
                }
                if (current.equalsIgnoreCase("-fasta")) {
                    String fastaFile = args[index++].trim();
                    this.loadFile(fastaFile, FileLoadPlugin.TasselFileType.Fasta);
                    continue;
                }
                if (current.equalsIgnoreCase("-table")) {
                    String tableFile = args[index++].trim();
                    this.loadFile(tableFile, FileLoadPlugin.TasselFileType.Table);
                    continue;
                }
                if (current.equalsIgnoreCase("-vcf")) {
                    String vcfFile = args[index++].trim();
                    this.loadFile(vcfFile, FileLoadPlugin.TasselFileType.VCF);
                    continue;
                }
                if (current.equalsIgnoreCase("-readSerialAlignment")) {
                    file = args[index++].trim();
                    this.loadFile(file, FileLoadPlugin.TasselFileType.Serial);
                    continue;
                }
                if (current.equalsIgnoreCase("-importGuess")) {
                    file = args[index++].trim();
                    this.loadFile(file, FileLoadPlugin.TasselFileType.Unknown);
                    continue;
                }
                if (current.equalsIgnoreCase("-sortPositions")) {
                    plugin = (FileLoadPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FileLoadPlugin.class});
                    if (plugin != null) {
                        ((FileLoadPlugin)plugin).sortPositions(true);
                        continue;
                    }
                    PlinkLoadPlugin plink = (PlinkLoadPlugin)this.findLastPluginFromCurrentPipe(new Class[]{PlinkLoadPlugin.class});
                    if (plink != null) {
                        plink.sortPositions(true);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: No FileLoadPlugin step defined: " + current);
                }
                if (current.equalsIgnoreCase("-noDepth")) {
                    plugin = (FileLoadPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FileLoadPlugin.class});
                    if (plugin != null) {
                        ((FileLoadPlugin)plugin).keepDepth(false);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: No FileLoadPlugin step defined: " + current);
                }
                if (current.equalsIgnoreCase("-projection")) {
                    file = args[index++].trim();
                    ProjectionLoadPlugin plugin3 = new ProjectionLoadPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin3, true);
                    plugin3.recombinationBreakpoints(file);
                    continue;
                }
                if (current.equalsIgnoreCase("-printGenoSummary")) {
                    plugin = new GenotypeSummaryPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    ((GenotypeSummaryPlugin)plugin).overview(false);
                    ((GenotypeSummaryPlugin)plugin).siteSummary(false);
                    ((GenotypeSummaryPlugin)plugin).taxaSummary(false);
                    continue;
                }
                if (current.equalsIgnoreCase("-printMemoryUsage")) {
                    plugin = new MemoryUsagePlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, false);
                    continue;
                }
                if (current.equalsIgnoreCase("-convertTOPMtoHDF5")) {
                    String filename = args[index++].trim();
                    TagsOnPhysicalMap topm = null;
                    String h5Filename = null;
                    if (filename.endsWith(".topm.txt")) {
                        topm = new TagsOnPhysicalMap(filename, false);
                        h5Filename = filename.replaceAll(".topm.txt", ".topm.h5");
                    } else if (filename.endsWith(".topm.bin")) {
                        topm = new TagsOnPhysicalMap(filename, true);
                        h5Filename = filename.replaceAll(".topm.bin", ".topm.h5");
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -convertTOPMtoHDF5: Unknown file extension: " + filename);
                    }
                    TagsOnPhysMapHDF5.createFile(topm, h5Filename, 4, 8);
                    continue;
                }
                if (current.equalsIgnoreCase("-retainRareAlleles")) {
                    String temp = args[index++].trim();
                    boolean retain = true;
                    if (temp.equalsIgnoreCase("false")) {
                        retain = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        retain = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -retainRareAlleles parameter must be true or false.");
                    }
                    TasselPrefs.putAlignmentRetainRareAlleles(retain);
                    continue;
                }
                if (current.equalsIgnoreCase("-union")) {
                    plugin = new UnionAlignmentPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-intersect")) {
                    plugin = new IntersectionAlignmentPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-separate")) {
                    plugin = new SeparatePlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    String temp = args[index].trim();
                    if (temp.startsWith("-")) continue;
                    String[] chromosomes = temp.split(",");
                    ((SeparatePlugin)plugin).setChromosomesToSeparate(chromosomes);
                    ++index;
                    continue;
                }
                if (current.equalsIgnoreCase("-homozygous")) {
                    plugin = new HetsToUnknownPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-synonymizer")) {
                    plugin = new SynonymizerPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mergeGenotypeTables")) {
                    plugin = new MergeGenotypeTablesPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mergeAlignmentsSameSites")) {
                    plugin = new MergeAlignmentsSameSitesPlugin(this.myMainFrame);
                    this.integratePlugin(plugin, true);
                    try {
                        for (int i3 = 0; i3 < 2; ++i3) {
                            String paraType = args[index++].trim();
                            String value = args[index++].trim();
                            if (paraType.equalsIgnoreCase("-input")) {
                                String[] files = value.split(",");
                                ArrayList<String> filenames = new ArrayList<String>();
                                for (int j = 0; j < files.length; ++j) {
                                    filenames.add(files[j]);
                                }
                                ((MergeAlignmentsSameSitesPlugin)plugin).setInputFiles(filenames);
                                continue;
                            }
                            if (paraType.equalsIgnoreCase("-output")) {
                                ((MergeAlignmentsSameSitesPlugin)plugin).setOutputFile(value);
                                continue;
                            }
                            throw new IllegalArgumentException("TasselPipeline: parseArgs: -mergeAlignmentsSameSites: unknown descriptor: " + paraType);
                        }
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -mergeAlignmentsSameSites: not specified correctly.");
                    }
                }
                if (current.equalsIgnoreCase("-excludeLastTrait")) {
                    plugin = new FilterTraitsPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    ((FilterTraitsPlugin)plugin).excludeLast(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-pca")) {
                    plugin = new PrincipalComponentsPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mhd")) {
                    plugin = new ManhattanDisplayPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlm")) {
                    plugin = new WeightedMLMPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlmVarCompEst")) {
                    plugin = (WeightedMLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{WeightedMLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    String method = args[index++].trim();
                    ((WeightedMLMPlugin)plugin).setVarCompEst(method);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlmCompressionLevel")) {
                    String type;
                    plugin = (WeightedMLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{WeightedMLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    if ((type = args[index++].trim()).equalsIgnoreCase("Optimum")) {
                        ((WeightedMLMPlugin)plugin).setCompressionType(WeightedMLMPlugin.CompressionType.Optimum);
                        continue;
                    }
                    if (type.equalsIgnoreCase("Custom")) {
                        ((WeightedMLMPlugin)plugin).setCompressionType(WeightedMLMPlugin.CompressionType.Custom);
                        continue;
                    }
                    if (type.equalsIgnoreCase("None")) {
                        ((WeightedMLMPlugin)plugin).setCompressionType(WeightedMLMPlugin.CompressionType.None);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: Unknown compression type: " + type);
                }
                if (current.equalsIgnoreCase("-mlmCustomCompression")) {
                    plugin = (WeightedMLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{WeightedMLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing custom compression: " + temp);
                    }
                    ((WeightedMLMPlugin)plugin).setCustomCompression(value);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlmOutputFile")) {
                    plugin = (WeightedMLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{WeightedMLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    String filename = args[index++].trim();
                    ((WeightedMLMPlugin)plugin).setOutputName(filename);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlmMaxP")) {
                    plugin = (WeightedMLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{WeightedMLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double maxP = 0.0;
                    try {
                        maxP = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing max P: " + temp);
                    }
                    ((WeightedMLMPlugin)plugin).setMaxp(maxP);
                    continue;
                }
                if (current.equalsIgnoreCase("-glm")) {
                    this.myDeprecatedWarning.append("parseArgs: NOTE: The -glm flags are deprecated.\n");
                    this.myDeprecatedWarning.append("parseArgs: PLEASE RUN THIS COMMAND TO GET USAGE: ./run_pipeline.pl -FixedEffectLMPlugin\n");
                    plugin = new FixedEffectLMPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-glmOutputFile")) {
                    plugin = (FixedEffectLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FixedEffectLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No GLM step defined: " + current);
                    }
                    String filename = args[index++].trim();
                    ((FixedEffectLMPlugin)plugin).setOutputFile(filename);
                    continue;
                }
                if (current.equalsIgnoreCase("-glmMaxP")) {
                    plugin = (FixedEffectLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FixedEffectLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No GLM step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double maxP = 0.0;
                    try {
                        maxP = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing max P: " + temp);
                    }
                    ((FixedEffectLMPlugin)plugin).setMaxP(maxP);
                    continue;
                }
                if (current.equalsIgnoreCase("-glmPermutations")) {
                    plugin = (FixedEffectLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FixedEffectLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No GLM step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int permutations = 0;
                    try {
                        permutations = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing number of permutations: " + temp);
                    }
                    ((FixedEffectLMPlugin)plugin).setPermute(true);
                    ((FixedEffectLMPlugin)plugin).setNumberOfPermutations(permutations);
                    continue;
                }
                if (current.equalsIgnoreCase("-td_csv")) {
                    String csvFile = args[index++].trim();
                    this.getTableDisplayPlugin(csvFile, current);
                    continue;
                }
                if (current.equalsIgnoreCase("-td_tab")) {
                    String tabFile = args[index++].trim();
                    this.getTableDisplayPlugin(tabFile, current);
                    continue;
                }
                if (current.equalsIgnoreCase("-td_gui")) {
                    this.getTableDisplayPlugin(null, current);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversity")) {
                    plugin = new SequenceDiversityPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversityStartBase")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int start = -1;
                    try {
                        start = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with Diversity Start Base number: " + str);
                    }
                    if (start < 0) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Diversity Start Base can't be less than 0.");
                    }
                    ((SequenceDiversityPlugin)plugin).startSite(start);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversityEndBase")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int end = -1;
                    try {
                        end = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with Diversity Start Base number: " + str);
                    }
                    ((SequenceDiversityPlugin)plugin).endSite(end);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversitySlidingWin")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    ((SequenceDiversityPlugin)plugin).isSlidingWindowAnalysis(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversitySlidingWinStep")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int step = -1;
                    try {
                        step = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with Diversity Sliding Win Step number: " + str);
                    }
                    ((SequenceDiversityPlugin)plugin).stepSize(step);
                    ((SequenceDiversityPlugin)plugin).isSlidingWindowAnalysis(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversitySlidingWinSize")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int size = -1;
                    try {
                        size = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with Diversity Sliding Win Size number: " + str);
                    }
                    ((SequenceDiversityPlugin)plugin).windowSize(size);
                    ((SequenceDiversityPlugin)plugin).isSlidingWindowAnalysis(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-ld")) {
                    plugin = new LinkageDisequilibriumPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldPermNum")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int permNum = -1;
                    try {
                        permNum = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with LD Permutation number: " + str);
                    }
                    if (permNum < 1) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Permutation size can't be less than 1.");
                    }
                    ((LinkageDisequilibriumPlugin)plugin).setPermutationNumber(permNum);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldTestSite")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int testSite = -1;
                    try {
                        testSite = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with LD Test Site number: " + str);
                    }
                    if (testSite < 0) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Test Site can't be less than 0.");
                    }
                    ((LinkageDisequilibriumPlugin)plugin).setTestSite(testSite);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldTestSiteName")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    ((LinkageDisequilibriumPlugin)plugin).setTestSiteName(str);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldWinSize")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int winSize = -1;
                    try {
                        winSize = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with LD Window Size: " + str);
                    }
                    if (winSize < 1) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Window Size can't be less than 1.");
                    }
                    ((LinkageDisequilibriumPlugin)plugin).setWinSize(winSize);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldRapidAnalysis")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    boolean rapid = true;
                    if (temp.equalsIgnoreCase("false")) {
                        rapid = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        rapid = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Rapid Analysis parameter must be true or false.");
                    }
                    ((LinkageDisequilibriumPlugin)plugin).setRapidAnalysis(rapid);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldType")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    if (temp.equalsIgnoreCase("All")) {
                        ((LinkageDisequilibriumPlugin)plugin).setLDType(LinkageDisequilibrium.testDesign.All);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("SlidingWindow")) {
                        ((LinkageDisequilibriumPlugin)plugin).setLDType(LinkageDisequilibrium.testDesign.SlidingWindow);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("SiteByAll")) {
                        ((LinkageDisequilibriumPlugin)plugin).setLDType(LinkageDisequilibrium.testDesign.SiteByAll);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Type parameter must be All, SlidingWindow, or SiteByAll.");
                }
                if (current.equalsIgnoreCase("-ldHetTreatment")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    if (temp.equalsIgnoreCase("Haplotype")) {
                        ((LinkageDisequilibriumPlugin)plugin).setHetTreatment(LinkageDisequilibrium.HetTreatment.Haplotype);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("Homozygous")) {
                        ((LinkageDisequilibriumPlugin)plugin).setHetTreatment(LinkageDisequilibrium.HetTreatment.Homozygous);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("Genotype")) {
                        ((LinkageDisequilibriumPlugin)plugin).setHetTreatment(LinkageDisequilibrium.HetTreatment.Genotype);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Het Treatment parameter must be Haplotype, Homozygous, or Genotype.");
                }
                if (current.equalsIgnoreCase("-ldd")) {
                    String outputType = args[index++].trim();
                    this.getLinkageDiseqDisplayPlugin(outputType);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldplotsize")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDiseqDisplayPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDiseqDisplay step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int plotSize = -1;
                    try {
                        plotSize = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with LD Plot size number: " + str);
                    }
                    if (plotSize < 1) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Plot size can't be less than 1.");
                    }
                    ((AbstractDisplayPlugin)plugin).setImageSize(plotSize, plotSize);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldplotlabels")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDiseqDisplayPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDiseqDisplay step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    boolean ldPlotLabels = true;
                    if (temp.equalsIgnoreCase("false")) {
                        ldPlotLabels = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        ldPlotLabels = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Plot labels parameter must be true or false.");
                    }
                    ((LinkageDiseqDisplayPlugin)plugin).setShowLabels(ldPlotLabels);
                    continue;
                }
                if (current.equalsIgnoreCase("-o")) {
                    plugin = this.findLastPluginFromCurrentPipe(new Class[]{LinkageDiseqDisplayPlugin.class});
                    String temp = args[index++].trim();
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDiseqDisplay step defined: " + current + " " + temp);
                    }
                    if (!(plugin instanceof LinkageDiseqDisplayPlugin)) continue;
                    ((LinkageDiseqDisplayPlugin)plugin).setSaveFile(temp);
                    continue;
                }
                if (current.equalsIgnoreCase("-ck")) {
                    plugin = new KinshipPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-ckModelHets")) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: -ckModelHets not needed in Tassel 5.0. It is designed to handle heterzygotes.");
                }
                if (current.equalsIgnoreCase("-ckRescale")) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: -ckRescale not needed in Tassel 5.0. It is designed to handle heterzygotes.");
                }
                if (current.equalsIgnoreCase("-archaeopteryx")) {
                    plugin = new ArchaeopteryxPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-tree")) {
                    plugin = new CreateTreePlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    String temp = args[index++].trim();
                    if (temp.equalsIgnoreCase("Neighbor")) {
                        ((CreateTreePlugin)plugin).clusteringMethod(CreateTreePlugin.CLUSTERING_METHOD.Neighbor_Joining);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("UPGMA")) {
                        ((CreateTreePlugin)plugin).clusteringMethod(CreateTreePlugin.CLUSTERING_METHOD.UPGMA);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: tree clustering method must be Neighbor or UPGMA: " + temp);
                }
                if (current.equalsIgnoreCase("-treeSaveDistance")) {
                    plugin = (CreateTreePlugin)this.findLastPluginFromCurrentPipe(new Class[]{CreateTreePlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Create Tree step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    boolean value = true;
                    if (temp.equalsIgnoreCase("false")) {
                        value = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        value = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: tree save distance matrix parameter must be true or false: " + value);
                    }
                    ((CreateTreePlugin)plugin).saveDistanceMatrix(value);
                    continue;
                }
                if (current.equalsIgnoreCase("-gs")) {
                    plugin = new RidgeRegressionEmmaPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-distanceMatrix")) {
                    plugin = new DistanceMatrixPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRanges")) {
                    plugin = new DistanceMatrixRangesPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRangesLocus")) {
                    plugin = null;
                    try {
                        plugin = (DistanceMatrixRangesPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No DistanceMatrixRangesPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    ((DistanceMatrixRangesPlugin)plugin).setLocus(str);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRangesTaxon")) {
                    plugin = null;
                    try {
                        plugin = (DistanceMatrixRangesPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No DistanceMatrixRangesPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    ((DistanceMatrixRangesPlugin)plugin).setTaxon(str);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRangesPos")) {
                    plugin = null;
                    try {
                        plugin = (DistanceMatrixRangesPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No DistanceMatrixRangesPlugin step defined: " + current);
                    }
                    String[] positions = args[index++].trim().split(",");
                    ((DistanceMatrixRangesPlugin)plugin).setPhysicalPositions(positions);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRangesPosFile")) {
                    plugin = null;
                    try {
                        plugin = (DistanceMatrixRangesPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No DistanceMatrixRangesPlugin step defined: " + current);
                    }
                    String posFile = args[index++].trim();
                    ArrayList<String> positions = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(posFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                positions.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    String[] positionArray = new String[positions.size()];
                    positionArray = positions.toArray(positionArray);
                    ((DistanceMatrixRangesPlugin)plugin).setPhysicalPositions(positionArray);
                    continue;
                }
                if (current.equalsIgnoreCase("-genotypeSummary")) {
                    plugin = new GenotypeSummaryPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    String temp = args[index++].trim();
                    String[] types = temp.split(",");
                    ((GenotypeSummaryPlugin)plugin).overview(false);
                    ((GenotypeSummaryPlugin)plugin).siteSummary(false);
                    ((GenotypeSummaryPlugin)plugin).taxaSummary(false);
                    for (int i4 = 0; i4 < types.length; ++i4) {
                        if (types[i4].equalsIgnoreCase("overall")) {
                            ((GenotypeSummaryPlugin)plugin).overview(true);
                            continue;
                        }
                        if (types[i4].equalsIgnoreCase("site")) {
                            ((GenotypeSummaryPlugin)plugin).siteSummary(true);
                            continue;
                        }
                        if (types[i4].equalsIgnoreCase("taxa")) {
                            ((GenotypeSummaryPlugin)plugin).taxaSummary(true);
                            continue;
                        }
                        if (types[i4].equalsIgnoreCase("all")) {
                            ((GenotypeSummaryPlugin)plugin).overview(true);
                            ((GenotypeSummaryPlugin)plugin).siteSummary(true);
                            ((GenotypeSummaryPlugin)plugin).taxaSummary(true);
                            continue;
                        }
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -genotypeSummary illegal types: " + temp);
                    }
                    continue;
                }
                if (current.equalsIgnoreCase("-export")) {
                    plugin = new ExportMultiplePlugin(this.myMainFrame);
                    String temp = args[index].trim();
                    if (!temp.startsWith("-")) {
                        String[] filenames = temp.split(",");
                        ((ExportMultiplePlugin)plugin).setSaveFiles(filenames);
                        ++index;
                    }
                    this.integratePlugin(plugin, false);
                    continue;
                }
                if (current.equalsIgnoreCase("-exportType")) {
                    plugin = (ExportMultiplePlugin)this.findLastPluginFromCurrentPipe(new Class[]{ExportMultiplePlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Export step defined: " + current);
                    }
                    String type = args[index++].trim();
                    try {
                        ((ExportMultiplePlugin)plugin).setAlignmentFileType(FileLoadPlugin.TasselFileType.valueOf(type));
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -exportType: Unknown type: " + type + "  Should be: " + Arrays.toString((Object[])FileLoadPlugin.TasselFileType.values()));
                    }
                }
                if (current.equalsIgnoreCase("-exportIncludeAnno")) {
                    plugin = (ExportMultiplePlugin)this.findLastPluginFromCurrentPipe(new Class[]{ExportMultiplePlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Export step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    boolean value = true;
                    if (temp.equalsIgnoreCase("false")) {
                        value = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        value = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -exportIncludeAnno must be true or false: " + temp);
                    }
                    ((ExportMultiplePlugin)plugin).setIncludeAnnotations(value);
                    continue;
                }
                if (current.equalsIgnoreCase("-exportIncludeDepth")) {
                    plugin = (ExportMultiplePlugin)this.findLastPluginFromCurrentPipe(new Class[]{ExportMultiplePlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Export step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    boolean value = true;
                    if (temp.equalsIgnoreCase("false")) {
                        value = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        value = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -exportIncludeDepth must be true or false: " + temp);
                    }
                    ((ExportMultiplePlugin)plugin).setIncludeDepth(value);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterTaxaNames")) {
                    plugin = new FilterTaxaBuilderPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlign")) {
                    plugin = new FilterSiteBuilderPlugin(this.myMainFrame, this.myIsInteractive);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignMinCount")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int minCount = 0;
                    try {
                        minCount = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment min count: " + temp);
                    }
                    ((FilterSiteBuilderPlugin)plugin).siteMinCount(minCount);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignMinFreq")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double minFreq = 0.0;
                    try {
                        minFreq = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment min frequency: " + temp);
                    }
                    ((FilterSiteBuilderPlugin)plugin).siteMinAlleleFreq(minFreq);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignMaxFreq")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double maxFreq = 0.0;
                    try {
                        maxFreq = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment max frequency: " + temp);
                    }
                    ((FilterSiteBuilderPlugin)plugin).siteMaxAlleleFreq(maxFreq);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignStart")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int start = 0;
                    try {
                        start = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment start: " + temp);
                    }
                    ((FilterSiteBuilderPlugin)plugin).startSite(start);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignEnd")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int end = 0;
                    try {
                        end = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment end: " + temp);
                    }
                    ((FilterSiteBuilderPlugin)plugin).endSite(end);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignStartPos")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int startPos = 0;
                    try {
                        startPos = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment start physical position: " + temp);
                    }
                    ((FilterSiteBuilderPlugin)plugin).startPos(startPos);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignEndPos")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int endPos = 0;
                    try {
                        endPos = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment end physical position: " + temp);
                    }
                    ((FilterSiteBuilderPlugin)plugin).endPos(endPos);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignLocus")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    Chromosome chr = Chromosome.instance(temp);
                    ((FilterSiteBuilderPlugin)plugin).startChr(chr);
                    ((FilterSiteBuilderPlugin)plugin).endChr(chr);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignExtInd")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    throw new UnsupportedOperationException("TasselPipeline: -filterAlignExtInd currently unsupported.");
                }
                if (current.equalsIgnoreCase("-filterAlignRemMinor")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    ((FilterSiteBuilderPlugin)plugin).removeMinorSNPStates(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignSliding")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    throw new UnsupportedOperationException("TasselPipeline: -filterAlignSliding currently unsupported.");
                }
                if (current.equalsIgnoreCase("-filterAlignHapLen")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int hapLen = 0;
                    try {
                        hapLen = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment haplotype length: " + temp);
                    }
                    throw new UnsupportedOperationException("TasselPipeline: -filterAlignHapLen currently unsupported.");
                }
                if (current.equalsIgnoreCase("-filterAlignStepLen")) {
                    plugin = (FilterSiteBuilderPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterSiteBuilderPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int stepLen = 0;
                    try {
                        stepLen = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment step length: " + temp);
                    }
                    throw new UnsupportedOperationException("TasselPipeline: -filterAlignStepLen currently unsupported.");
                }
                if (current.equalsIgnoreCase("-numericalGenoTransform")) {
                    myLogger.warn((Object)"parseArgs: PLEASE USE NumericalGenotypePlugin.\n");
                    System.exit(1);
                    continue;
                }
                if (current.equalsIgnoreCase("-includeTaxa")) {
                    plugin = new FilterTaxaBuilderPlugin(this.myMainFrame, this.myIsInteractive);
                    String[] taxa = args[index++].trim().split(",");
                    Taxon[] ids2 = new Taxon[taxa.length];
                    for (int i5 = 0; i5 < taxa.length; ++i5) {
                        ids2[i5] = new Taxon(taxa[i5]);
                    }
                    ((FilterTaxaBuilderPlugin)plugin).taxaList(new TaxaListBuilder().addAll(ids2).build());
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-includeTaxaInFile")) {
                    plugin = new FilterTaxaBuilderPlugin(this.myMainFrame, this.myIsInteractive);
                    String taxaListFile = args[index++].trim();
                    ArrayList<String> taxa = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(taxaListFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                taxa.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    ids = new Taxon[taxa.size()];
                    for (int i6 = 0; i6 < taxa.size(); ++i6) {
                        ids[i6] = new Taxon((String)taxa.get(i6));
                    }
                    ((FilterTaxaBuilderPlugin)plugin).taxaList(new TaxaListBuilder().addAll(ids).build());
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeTaxa")) {
                    plugin = new FilterTaxaBuilderPlugin(this.myMainFrame, this.myIsInteractive);
                    String[] taxa = args[index++].trim().split(",");
                    Taxon[] ids3 = new Taxon[taxa.length];
                    for (int i7 = 0; i7 < taxa.length; ++i7) {
                        ids3[i7] = new Taxon(taxa[i7]);
                    }
                    ((FilterTaxaBuilderPlugin)plugin).includeTaxa(false);
                    ((FilterTaxaBuilderPlugin)plugin).taxaList(new TaxaListBuilder().addAll(ids3).build());
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeTaxaInFile")) {
                    plugin = new FilterTaxaBuilderPlugin(this.myMainFrame, this.myIsInteractive);
                    String taxaListFile = args[index++].trim();
                    ArrayList<String> taxa = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(taxaListFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                taxa.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    ids = new Taxon[taxa.size()];
                    for (int i8 = 0; i8 < taxa.size(); ++i8) {
                        ids[i8] = new Taxon((String)taxa.get(i8));
                    }
                    ((FilterTaxaBuilderPlugin)plugin).includeTaxa(false);
                    ((FilterTaxaBuilderPlugin)plugin).taxaList(new TaxaListBuilder().addAll(ids).build());
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-includeSiteNames")) {
                    plugin = new FilterSiteNamePlugin(this.myMainFrame, this.myIsInteractive);
                    String[] names = args[index++].trim().split(",");
                    ((FilterSiteNamePlugin)plugin).setSiteNamesToKeep(names);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-includeSiteNamesInFile")) {
                    plugin = new FilterSiteNamePlugin(this.myMainFrame, this.myIsInteractive);
                    String siteNameListFile = args[index++].trim();
                    ArrayList<String> siteNames = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(siteNameListFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                siteNames.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    String[] siteNameArray = new String[siteNames.size()];
                    siteNameArray = siteNames.toArray(siteNameArray);
                    ((FilterSiteNamePlugin)plugin).setSiteNamesToKeep(siteNameArray);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeSiteNames")) {
                    plugin = new FilterSiteNamePlugin(this.myMainFrame, this.myIsInteractive);
                    String[] sites = args[index++].trim().split(",");
                    ((FilterSiteNamePlugin)plugin).setSiteNamesToRemove(sites);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeSiteNamesInFile")) {
                    plugin = new FilterSiteNamePlugin(this.myMainFrame, this.myIsInteractive);
                    String siteNameListFile = args[index++].trim();
                    ArrayList<String> siteNames = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(siteNameListFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                siteNames.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    String[] names = new String[siteNames.size()];
                    for (int i9 = 0; i9 < siteNames.size(); ++i9) {
                        names[i9] = (String)siteNames.get(i9);
                    }
                    ((FilterSiteNamePlugin)plugin).setSiteNamesToRemove(names);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-subsetSites")) {
                    plugin = new FilterSubsetPlugin(this.myMainFrame, this.myIsInteractive);
                    try {
                        double siteVal = Double.parseDouble(args[index++].trim());
                        ((FilterSubsetPlugin)plugin).setSiteSubset(siteVal);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Value following -subsetSites must be a number (decimal or integer)");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (args[index].equalsIgnoreCase("-step")) {
                        ((FilterSubsetPlugin)plugin).setIsRandom(false);
                        ++index;
                    }
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-subsetTaxa")) {
                    plugin = new FilterSubsetPlugin(this.myMainFrame, this.myIsInteractive);
                    try {
                        double taxaVal = Double.parseDouble(args[index++].trim());
                        ((FilterSubsetPlugin)plugin).setTaxaSubset(taxaVal);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Value following -subsetTaxa must be a number (decimal or integer)");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (args[index].equalsIgnoreCase("-step")) {
                        ((FilterSubsetPlugin)plugin).setIsRandom(false);
                        ++index;
                    }
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-newCoordinates")) {
                    plugin = new ConvertAlignmentCoordinatesPlugin(this.myMainFrame, this.myIsInteractive);
                    String mapFile = args[index++].trim();
                    ((ConvertAlignmentCoordinatesPlugin)plugin).mapFilename(mapFile);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                try {
                    String match;
                    plugin = null;
                    String possibleClassName = current.substring(1);
                    List<String> matches = Utils.getFullyQualifiedClassNames(possibleClassName);
                    Iterator<String> br = matches.iterator();
                    while (br.hasNext() && (plugin = Plugin.getPluginInstance(match = br.next(), this.myMainFrame, this.myIsInteractive)) == null) {
                    }
                    if (plugin == null) {
                        plugin = Plugin.getPluginInstance(possibleClassName, this.myMainFrame, this.myIsInteractive);
                    }
                    if (plugin != null) {
                        this.integratePlugin(plugin, true);
                        ArrayList<String> pluginArgs = new ArrayList<String>();
                        String temp = args[index++].trim();
                        while (!temp.equalsIgnoreCase("-endPlugin")) {
                            if (temp.startsWith("-runfork")) {
                                --index;
                                break;
                            }
                            pluginArgs.add(temp);
                            temp = args[index++].trim();
                        }
                        String[] result = new String[pluginArgs.size()];
                        result = pluginArgs.toArray(result);
                        try {
                            plugin.setParameters(result);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ExceptionUtils.logExceptionCauses(e, myLogger, Level.ERROR);
                            System.exit(1);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: Unknown parameter: " + current);
                }
                catch (UnsupportedOperationException usoe) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: this plugin is not self-described: " + current);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: Unknown parameter: " + current);
                }
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage());
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                System.exit(1);
            }
        }
        if (this.myFirstPlugin != null) {
            this.tracePipeline();
        } else {
            myLogger.warn((Object)"parseArgs: no arguments specified.");
        }
    }

    public static String[] addForkFlagsIfNeeded(String[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        for (String a : args) {
            if (!a.toLowerCase().startsWith("-fork") && !a.toLowerCase().startsWith("-runfork")) continue;
            return args;
        }
        String[] newArgs = new String[args.length + 2];
        newArgs[0] = "-fork1";
        newArgs[newArgs.length - 1] = "-runfork1";
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return newArgs;
    }

    private void tracePipeline() {
        for (ThreadedPluginListener thread : this.myThreads) {
            Plugin current = (Plugin)thread.getPluginListener();
            ((AbstractPlugin)current).trace(0);
        }
    }

    public FileLoadPlugin loadFile(String filename, FileLoadPlugin.TasselFileType fileType) {
        FileLoadPlugin plugin = new FileLoadPlugin(this.myMainFrame, this.myIsInteractive);
        this.integratePlugin(plugin, true);
        if (fileType == null) {
            plugin.setTheFileType(FileLoadPlugin.TasselFileType.Unknown);
        } else {
            plugin.setTheFileType(fileType);
        }
        plugin.setOpenFiles(new String[]{filename});
        return plugin;
    }

    public TableDisplayPlugin getTableDisplayPlugin(String filename, String flag) {
        TableDisplayPlugin plugin = null;
        if (flag.equalsIgnoreCase("-td_gui")) {
            plugin = new TableDisplayPlugin(this.myMainFrame, true);
            this.integratePlugin(plugin, false);
        } else if (flag.equalsIgnoreCase("-td_tab")) {
            filename = Utils.addSuffixIfNeeded(filename, ".txt");
            myLogger.info((Object)("getTableDisplayPlugin: " + filename));
            plugin = new TableDisplayPlugin(this.myMainFrame, this.myIsInteractive);
            this.integratePlugin(plugin, false);
            plugin.setDelimiter("\t");
            plugin.setSaveFile(filename);
        } else if (flag.equalsIgnoreCase("-td_csv")) {
            filename = Utils.addSuffixIfNeeded(filename, ".csv");
            myLogger.info((Object)("getTableDisplayPlugin: " + filename));
            plugin = new TableDisplayPlugin(this.myMainFrame, this.myIsInteractive);
            this.integratePlugin(plugin, false);
            plugin.setDelimiter(",");
            plugin.setSaveFile(filename);
        }
        return plugin;
    }

    public LinkageDiseqDisplayPlugin getLinkageDiseqDisplayPlugin(String type) {
        LinkageDiseqDisplayPlugin plugin = new LinkageDiseqDisplayPlugin(this.myMainFrame, true);
        this.integratePlugin(plugin, false);
        if (type.equalsIgnoreCase("gui")) {
            plugin = new LinkageDiseqDisplayPlugin(null, true);
            plugin.setBlockSchematic(false);
            plugin.setLowerCorner(0);
            plugin.setUpperCorner(2);
        } else {
            plugin = new LinkageDiseqDisplayPlugin(null, false);
            plugin.setBlockSchematic(false);
            plugin.setLowerCorner(0);
            plugin.setUpperCorner(2);
            if (type.equalsIgnoreCase("png")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.png);
            } else if (type.equalsIgnoreCase("gif")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.gif);
            } else if (type.equalsIgnoreCase("bmp")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.bmp);
            } else if (type.equalsIgnoreCase("jpg")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.jpg);
            } else if (type.equalsIgnoreCase("svg")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.svg);
            } else {
                throw new IllegalArgumentException("TasselPipeline: getLinkageDiseqDisplayPlugin: unknown output type: " + type);
            }
        }
        return plugin;
    }

    private void integratePlugin(Plugin plugin, boolean displayDataTree) {
        if (this.myFirstPlugin == null) {
            this.myFirstPlugin = plugin;
        }
        if (displayDataTree) {
            plugin.addListener(this);
        }
        if (this.myCurrentPipe == null) {
            this.myCurrentPipe = new ArrayList<Plugin>();
        }
        if (this.myCurrentPipe.isEmpty()) {
            this.myCurrentPipe.add(plugin);
        } else {
            plugin.receiveInput(this.myCurrentPipe.get(this.myCurrentPipe.size() - 1));
            this.myCurrentPipe.add(plugin);
        }
        if (this.myIsInteractive) {
            this.myStepsDialog.addPlugin(plugin, this.myDescriptions[this.myCurrentDescriptionIndex]);
        }
        ((AbstractPlugin)plugin).setConfigParameters();
    }

    private Plugin findLastPluginFromAll(Class[] types) {
        if (this.myCurrentPipe != null && this.myCurrentPipe.size() != 0) {
            for (int i = this.myCurrentPipe.size() - 1; i >= 0; --i) {
                Plugin current = this.myCurrentPipe.get(i);
                if (!this.matchType(types, current)) continue;
                return current;
            }
        }
        ArrayList<String> keys = new ArrayList<String>(this.myForks.keySet());
        for (int i = keys.size() - 1; i >= 0; --i) {
            List<Plugin> currentPipe = this.myForks.get(keys.get(i));
            for (int j = currentPipe.size() - 1; j >= 0; --j) {
                Plugin current = currentPipe.get(j);
                if (!this.matchType(types, current)) continue;
                return current;
            }
        }
        return null;
    }

    private Plugin findLastPluginFromCurrentPipe(Class[] types) {
        if (this.myCurrentPipe != null && this.myCurrentPipe.size() != 0) {
            for (int i = this.myCurrentPipe.size() - 1; i >= 0; --i) {
                Plugin current = this.myCurrentPipe.get(i);
                if (!this.matchType(types, current)) continue;
                return current;
            }
        }
        return null;
    }

    private boolean matchType(Class[] types, Object test) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isInstance(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dataSetReturned(PluginEvent event) {
        DataSet tds = (DataSet)event.getSource();
        if (tds != null && tds.getSize() != 0 && this.myMainFrame != null) {
            this.myMainFrame.getDataTreePanel().addDataSet(tds, "Data");
            this.myMainFrame.getDataTreePanel().setSelectionPath(tds.getData(0));
        }
    }

    @Override
    public void progress(PluginEvent event) {
        DataSet ds;
        if (this.myMainFrame == null && (ds = (DataSet)event.getSource()) != null) {
            Datum datum;
            Integer percent;
            List<Datum> percentage = ds.getDataOfType(Integer.class);
            Plugin plugin = ds.getCreator();
            Integer lastValue = this.myProgressValues.get(plugin);
            if (lastValue == null) {
                lastValue = 0;
            }
            if (percentage.size() > 0 && (percent = (Integer)(datum = percentage.get(0)).getData()) >= lastValue) {
                LocalDateTime time = LocalDateTime.now();
                String timeStr = time.format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
                myLogger.info((Object)(ds.getCreator().getClass().getName() + ": time: " + timeStr + ": progress: " + percent + "%"));
                lastValue = lastValue + 10;
                this.myProgressValues.put(plugin, lastValue);
            }
        }
    }

    public static enum FLAGS {
        t,
        s,
        k,
        q,
        h,
        h5,
        hdf5Schema,
        r,
        plink,
        fasta,
        table,
        vcf,
        readSerialAlignment,
        importGuess,
        projection,
        convertTOPMtoHDF5,
        retainRareAlleles,
        union,
        intersect,
        separate,
        homozygous,
        synonymizer,
        mergeGenotypeTables,
        mergeAlignmentsSameSites,
        excludeLastTrait,
        mlm,
        glm,
        td_csv,
        td_tab,
        td_gui,
        diversity,
        ld,
        ldd,
        ck,
        tree,
        gs,
        distanceMatrix,
        distMatrixRanges,
        genotypeSummary,
        export,
        filterAlign,
        numericalGenoTransform,
        includeTaxa,
        includeTaxaInFile,
        excludeTaxa,
        excludeTaxaInFile,
        includeSiteNames,
        includeSiteNamesInFile,
        excludeSiteNames,
        excludeSiteNamesInFile,
        subsetSites,
        subsetTaxa,
        newCoordinates,
        archaeopteryx,
        filterTaxaNames,
        maxThreads,
        mhd,
        pca,
        printGenoSummary,
        printMemoryUsage;


        public String toString() {
            return "-" + super.toString();
        }
    }
}

