/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.pipeline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.maizegenetics.analysis.association.EqtlAssociationPlugin;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.association.RidgeRegressionEmmaPlugin;
import net.maizegenetics.analysis.association.WeightedMLMPlugin;
import net.maizegenetics.analysis.chart.ChartDisplayPlugin;
import net.maizegenetics.analysis.chart.ManhattanDisplayPlugin;
import net.maizegenetics.analysis.chart.QQDisplayPlugin;
import net.maizegenetics.analysis.chart.TableDisplayPlugin;
import net.maizegenetics.analysis.data.CombineDataSetsPlugin;
import net.maizegenetics.analysis.data.ExportPlugin;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.data.GetPositionListPlugin;
import net.maizegenetics.analysis.data.GetTaxaListPlugin;
import net.maizegenetics.analysis.data.HetsToUnknownPlugin;
import net.maizegenetics.analysis.data.IntersectionAlignmentPlugin;
import net.maizegenetics.analysis.data.MergeGenotypeTablesPlugin;
import net.maizegenetics.analysis.data.PrincipalComponentsPlugin;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.analysis.data.SortGenotypeFilePlugin;
import net.maizegenetics.analysis.data.SynonymizerPlugin;
import net.maizegenetics.analysis.data.UnionAlignmentPlugin;
import net.maizegenetics.analysis.distance.DistanceMatrixPlugin;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.analysis.distance.MultiDimensionalScalingPlugin;
import net.maizegenetics.analysis.filter.FilterAlignmentPlugin;
import net.maizegenetics.analysis.filter.FilterSiteBuilderPlugin;
import net.maizegenetics.analysis.filter.FilterSiteNamePlugin;
import net.maizegenetics.analysis.filter.FilterTaxaBuilderPlugin;
import net.maizegenetics.analysis.filter.FilterTaxaPropertiesPlugin;
import net.maizegenetics.analysis.filter.FilterTraitsPlugin;
import net.maizegenetics.analysis.imputation.FILLINFindHaplotypesPlugin;
import net.maizegenetics.analysis.imputation.FILLINImputationPlugin;
import net.maizegenetics.analysis.imputation.FSFHapImputationPlugin;
import net.maizegenetics.analysis.imputation.RemoveIndelsForBeaglePlugin;
import net.maizegenetics.analysis.modelfitter.StepwiseOLSModelFitterPlugin;
import net.maizegenetics.analysis.numericaltransform.ImputationPlugin;
import net.maizegenetics.analysis.numericaltransform.NumericalGenotypePlugin;
import net.maizegenetics.analysis.numericaltransform.TransformDataPlugin;
import net.maizegenetics.analysis.popgen.LinkageDiseqDisplayPlugin;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumPlugin;
import net.maizegenetics.analysis.popgen.SequenceDiversityPlugin;
import net.maizegenetics.analysis.tree.ArchaeopteryxPlugin;
import net.maizegenetics.analysis.tree.CreateTreePlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.progress.ProgressPanel;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.util.Utils;

public class TasselPipelineStepsDialog
extends JDialog
implements PluginListener {
    private static final Map<Class, String> MENU_LOCATIONS = new HashMap<Class, String>();
    private static final Color CURRENT_STEP_COLOR;
    private final List<Plugin> myPluginOrder = new ArrayList<Plugin>();
    private final List<String> myPluginDescriptions = new ArrayList<String>();
    private final Map<Plugin, JTextPane> myTextAreas = new LinkedHashMap<Plugin, JTextPane>();
    private final JPanel myMainPane = new JPanel();
    private String myDescription = null;
    private String myCitation = null;
    private final ProgressPanel myProgressPanel;

    public TasselPipelineStepsDialog(TASSELMainFrame mainFrame, String name) {
        super((Window)null, "Tassel Workflow: " + name, Dialog.ModalityType.MODELESS);
        this.setLayout(new BorderLayout());
        this.myMainPane.setLayout(new BoxLayout(this.myMainPane, 1));
        JScrollPane scroll = new JScrollPane(this.myMainPane);
        scroll.setHorizontalScrollBarPolicy(31);
        this.getContentPane().add((Component)scroll, "Center");
        JButton ok = new JButton(new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasselPipelineStepsDialog.this.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(ok);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setPreferredSize(new Dimension(400, 650));
        this.setResizable(false);
        this.myProgressPanel = mainFrame.getProgressPanel();
    }

    public void setOverallDescription(String description) {
        this.myDescription = description;
    }

    public void setCitation(String citation) {
        this.myCitation = citation;
    }

    public void addPlugin(Plugin plugin, String description) {
        this.myPluginOrder.add(plugin);
        this.myPluginDescriptions.add(description);
        plugin.addListener(this);
    }

    public void showDialog() {
        JTextPane text;
        if (this.myDescription != null) {
            text = new JTextPane();
            text.setContentType("text/html");
            text.setText("<h3>" + this.myDescription + "</h3>");
            text.setMargin(new Insets(5, 10, 3, 10));
            text.setEditable(false);
            this.myMainPane.add(text);
        }
        if (this.myCitation != null) {
            text = new JTextPane();
            text.setContentType("text/html");
            text.setText("<h3>" + this.myCitation + "</h3>");
            text.setMargin(new Insets(3, 10, 5, 10));
            text.setEditable(false);
            this.myMainPane.add(text);
        }
        boolean firstCreated = true;
        for (int i = 0; i < this.myPluginOrder.size(); ++i) {
            this.myMainPane.add(Box.createRigidArea(new Dimension(20, 2)));
            Plugin plugin = this.myPluginOrder.get(i);
            Class<?> clazz = plugin.getClass();
            StringBuilder builder = new StringBuilder();
            builder.append("<html>");
            String menu = MENU_LOCATIONS.get(clazz);
            builder.append("<h3>");
            if (menu == null) {
                builder.append(Utils.getBasename(clazz.getName()));
            } else {
                builder.append(menu);
                builder.append(" -> ");
                builder.append(plugin.getButtonName());
            }
            builder.append("</h3>\n");
            if (this.myPluginDescriptions.get(i) != null && this.myPluginDescriptions.get(i).length() != 0) {
                builder.append(this.myPluginDescriptions.get(i));
            }
            builder.append("</html>");
            JTextPane text2 = new JTextPane();
            text2.setContentType("text/html");
            text2.setText(builder.toString());
            text2.setMargin(new Insets(10, 10, 10, 10));
            text2.setEditable(false);
            this.myMainPane.add(text2);
            this.myTextAreas.put(plugin, text2);
            if (!firstCreated) continue;
            this.setTextColor(plugin, CURRENT_STEP_COLOR);
            firstCreated = false;
        }
        this.pack();
        this.setVisible(true);
    }

    @Override
    public synchronized void dataSetReturned(PluginEvent event) {
        DataSet dataSet = (DataSet)event.getSource();
        Plugin plugin = dataSet.getCreator();
        System.out.println("data set returned from: " + plugin.getClass().getName());
        this.setTextColor(plugin, Color.gray);
        int index = this.myPluginOrder.indexOf(plugin);
        if (index < this.myPluginOrder.size() - 1) {
            this.setTextColor(this.myPluginOrder.get(index + 1), CURRENT_STEP_COLOR);
            this.myProgressPanel.addPlugin(this.myPluginOrder.get(index + 1));
            if (index < this.myPluginOrder.size() - 2) {
                Rectangle rec = this.myTextAreas.get(this.myPluginOrder.get(index + 2)).getBounds();
                this.myMainPane.scrollRectToVisible(rec);
            }
        }
    }

    private void setTextColor(Plugin plugin, Color color) {
        JTextPane pane = this.myTextAreas.get(plugin);
        MutableAttributeSet attrs = pane.getInputAttributes();
        StyleConstants.setForeground(attrs, color);
        StyledDocument doc = pane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), attrs, true);
    }

    @Override
    public void progress(PluginEvent event) {
    }

    static {
        MENU_LOCATIONS.put(FileLoadPlugin.class, "Data");
        MENU_LOCATIONS.put(ExportPlugin.class, "Data");
        MENU_LOCATIONS.put(GetTaxaListPlugin.class, "Data");
        MENU_LOCATIONS.put(GetPositionListPlugin.class, "Data");
        MENU_LOCATIONS.put(SortGenotypeFilePlugin.class, "Data");
        MENU_LOCATIONS.put(SynonymizerPlugin.class, "Data");
        MENU_LOCATIONS.put(IntersectionAlignmentPlugin.class, "Data");
        MENU_LOCATIONS.put(UnionAlignmentPlugin.class, "Data");
        MENU_LOCATIONS.put(MergeGenotypeTablesPlugin.class, "Data");
        MENU_LOCATIONS.put(SeparatePlugin.class, "Data");
        MENU_LOCATIONS.put(HetsToUnknownPlugin.class, "Data");
        MENU_LOCATIONS.put(TransformDataPlugin.class, "Data");
        MENU_LOCATIONS.put(NumericalGenotypePlugin.class, "Data");
        MENU_LOCATIONS.put(FILLINFindHaplotypesPlugin.class, "Impute");
        MENU_LOCATIONS.put(FILLINImputationPlugin.class, "Impute");
        MENU_LOCATIONS.put(FSFHapImputationPlugin.class, "Impute");
        MENU_LOCATIONS.put(ImputationPlugin.class, "Impute");
        MENU_LOCATIONS.put(RemoveIndelsForBeaglePlugin.class, "Impute");
        MENU_LOCATIONS.put(FilterSiteBuilderPlugin.class, "Filter");
        MENU_LOCATIONS.put(FilterAlignmentPlugin.class, "Filter");
        MENU_LOCATIONS.put(FilterSiteNamePlugin.class, "Filter");
        MENU_LOCATIONS.put(FilterTaxaBuilderPlugin.class, "Filter");
        MENU_LOCATIONS.put(FilterTaxaPropertiesPlugin.class, "Filter");
        MENU_LOCATIONS.put(FilterTraitsPlugin.class, "Filter");
        MENU_LOCATIONS.put(SequenceDiversityPlugin.class, "Analysis");
        MENU_LOCATIONS.put(LinkageDisequilibriumPlugin.class, "Analysis");
        MENU_LOCATIONS.put(DistanceMatrixPlugin.class, "Analysis");
        MENU_LOCATIONS.put(CreateTreePlugin.class, "Analysis");
        MENU_LOCATIONS.put(KinshipPlugin.class, "Analysis");
        MENU_LOCATIONS.put(PrincipalComponentsPlugin.class, "Analysis");
        MENU_LOCATIONS.put(MultiDimensionalScalingPlugin.class, "Analysis");
        MENU_LOCATIONS.put(FixedEffectLMPlugin.class, "Analysis");
        MENU_LOCATIONS.put(MLMPlugin.class, "Analysis");
        MENU_LOCATIONS.put(WeightedMLMPlugin.class, "Analysis");
        MENU_LOCATIONS.put(RidgeRegressionEmmaPlugin.class, "Analysis");
        MENU_LOCATIONS.put(GenotypeSummaryPlugin.class, "Analysis");
        MENU_LOCATIONS.put(StepwiseOLSModelFitterPlugin.class, "Analysis");
        MENU_LOCATIONS.put(EqtlAssociationPlugin.class, "Analysis");
        MENU_LOCATIONS.put(TableDisplayPlugin.class, "Results");
        MENU_LOCATIONS.put(ArchaeopteryxPlugin.class, "Results");
        MENU_LOCATIONS.put(LinkageDiseqDisplayPlugin.class, "Results");
        MENU_LOCATIONS.put(ChartDisplayPlugin.class, "Results");
        MENU_LOCATIONS.put(QQDisplayPlugin.class, "Results");
        MENU_LOCATIONS.put(ManhattanDisplayPlugin.class, "Results");
        MENU_LOCATIONS.put(CombineDataSetsPlugin.class, "Select Multiple Datasets while holding Ctrl or Command");
        CURRENT_STEP_COLOR = new Color(2912555);
    }
}

