/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.plugindef.AbstractPlugin;
import org.apache.log4j.Logger;

public final class PluginParameter<T> {
    private static final Logger myLogger = Logger.getLogger(PluginParameter.class);
    private final String myGuiName;
    private final String myUnits;
    private final String myCmdLineName;
    private final String myDescription;
    private final List<Range<Comparable<T>>> myRanges;
    private final T myDefaultValue;
    private final T myValue;
    private final boolean myRequired;
    private final Class<T> myClass;
    private final PluginParameter<?> myDependentOnParameter;
    private final Object[] myDependentOnParameterValue;
    private final List<T> myPossibleValues;
    private final boolean myIsNullable;
    private final PARAMETER_TYPE myParameterType;

    private PluginParameter(String guiName, String guiUnits, String cmdLineName, String description, List<Range<Comparable<T>>> ranges, T defaultValue, T value, boolean required, PARAMETER_TYPE fileType, PluginParameter<?> dependentOnParameter, Object[] dependentOnParameterValue, List<T> possibleValues, boolean isNullable, Class<T> type) {
        this.myGuiName = guiName;
        this.myUnits = guiUnits;
        this.myCmdLineName = cmdLineName;
        this.myDescription = description;
        this.myRanges = ranges;
        this.myDefaultValue = defaultValue;
        this.myValue = value == null ? defaultValue : value;
        if (this.hasRange() && this.myValue != null && !this.acceptsValue((Comparable)this.myValue)) {
            StringBuilder builder = new StringBuilder();
            builder.append("PluginParameter: init: " + this.myCmdLineName + " value: " + this.myValue.toString() + " outside range: ");
            builder.append(this.rangeToString());
            throw new IllegalArgumentException(builder.toString());
        }
        this.myRequired = required;
        if (this.myDefaultValue != null && this.myRequired) {
            throw new IllegalArgumentException("PluginParameter: init: " + this.myCmdLineName + " shouldn't have default value and be required.");
        }
        this.myClass = type;
        this.myParameterType = fileType;
        this.myDependentOnParameter = dependentOnParameter;
        this.myDependentOnParameterValue = dependentOnParameterValue;
        this.myPossibleValues = possibleValues != null && possibleValues.isEmpty() ? null : possibleValues;
        this.myIsNullable = isNullable;
    }

    public PluginParameter(PluginParameter<T> oldParameter, T newValue) {
        this(oldParameter.myGuiName, oldParameter.myUnits, oldParameter.myCmdLineName, oldParameter.myDescription, oldParameter.myRanges, oldParameter.myDefaultValue, newValue, oldParameter.myRequired, oldParameter.myParameterType, oldParameter.dependentOnParameter(), oldParameter.dependentOnParameterValue(), oldParameter.possibleValues(), oldParameter.myIsNullable, oldParameter.myClass);
    }

    public PluginParameter(PluginParameter<T> oldParameter, List<T> possibleValues) {
        this(oldParameter.myGuiName, oldParameter.myUnits, oldParameter.myCmdLineName, oldParameter.myDescription, oldParameter.myRanges, oldParameter.myDefaultValue, oldParameter.value(), oldParameter.myRequired, oldParameter.myParameterType, oldParameter.dependentOnParameter(), oldParameter.dependentOnParameterValue(), possibleValues, oldParameter.myIsNullable, oldParameter.myClass);
    }

    public static PluginParameter<String> getLabelInstance(String label) {
        return new PluginParameter<String>(label, null, label, "label", null, null, null, false, PARAMETER_TYPE.LABEL, null, null, null, false, String.class);
    }

    public String guiName() {
        return this.myGuiName;
    }

    public String units() {
        return this.myUnits;
    }

    public String cmdLineName() {
        return this.myCmdLineName;
    }

    public String description() {
        return this.myDescription;
    }

    public boolean hasRange() {
        return this.myRanges != null && !this.myRanges.isEmpty();
    }

    public String rangeToString() {
        return this.rangeToString(false);
    }

    public String rangeToString(boolean friendly) {
        if (this.hasRange()) {
            StringBuilder builder = new StringBuilder();
            if (this.myRanges.size() == 1) {
                Range<Comparable<T>> current = this.myRanges.get(0);
                if (current.hasLowerBound() && current.hasUpperBound() && current.lowerEndpoint().equals(current.upperEndpoint())) {
                    builder.append("[");
                    if (!friendly && current.lowerEndpoint() instanceof Enum) {
                        builder.append(((Enum)((Object)current.lowerEndpoint())).name());
                    } else {
                        builder.append(current.lowerEndpoint().toString());
                    }
                    builder.append("]");
                } else {
                    builder.append(current.toString());
                }
            } else {
                boolean first = true;
                builder.append("[");
                for (Range<Comparable<T>> current : this.myRanges) {
                    if (!first) {
                        builder.append(", ");
                    } else {
                        first = false;
                    }
                    if (current.hasLowerBound() && current.hasUpperBound() && current.lowerEndpoint().equals(current.upperEndpoint())) {
                        if (!friendly && current.lowerEndpoint() instanceof Enum) {
                            builder.append(((Enum)((Object)current.lowerEndpoint())).name());
                            continue;
                        }
                        builder.append(current.lowerEndpoint().toString());
                        continue;
                    }
                    builder.append(current.toString());
                }
                builder.append("]");
            }
            return builder.toString();
        }
        return "";
    }

    public String possibleValuesString(boolean friendly) {
        if (this.hasPossibleValues()) {
            StringBuilder builder = new StringBuilder();
            if (this.myPossibleValues.size() == 1) {
                T current = this.myPossibleValues.get(0);
                builder.append("[");
                if (!friendly && current instanceof Enum) {
                    builder.append(((Enum)current).name());
                } else {
                    builder.append(current.toString());
                }
                builder.append("]");
            } else {
                boolean first = true;
                builder.append("[");
                for (T current : this.myPossibleValues) {
                    if (!first) {
                        builder.append(", ");
                    } else {
                        first = false;
                    }
                    if (!friendly && current instanceof Enum) {
                        builder.append(((Enum)current).name());
                        continue;
                    }
                    builder.append(current.toString());
                }
                builder.append("]");
            }
            return builder.toString();
        }
        return "";
    }

    public boolean acceptsValue(Object value) {
        try {
            if (value == null && this.myIsNullable) {
                return true;
            }
            if (this.hasRange()) {
                for (Range<Comparable<T>> current : this.myRanges) {
                    if (!current.contains((Comparable)value)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean acceptsValue(String input) {
        Comparable value = (Comparable)AbstractPlugin.convert(input, this.valueType());
        return this.acceptsValue(value);
    }

    public T value() {
        return this.myValue;
    }

    public T defaultValue() {
        return this.myDefaultValue;
    }

    public boolean required() {
        return this.myRequired;
    }

    public Class<T> valueType() {
        return this.myClass;
    }

    public PARAMETER_TYPE parameterType() {
        return this.myParameterType;
    }

    public PluginParameter<?> dependentOnParameter() {
        return this.myDependentOnParameter;
    }

    public Object[] dependentOnParameterValue() {
        return this.myDependentOnParameterValue;
    }

    public boolean hasPossibleValues() {
        return this.myPossibleValues != null;
    }

    public List<T> possibleValues() {
        return this.myPossibleValues;
    }

    public boolean isEmpty() {
        return this.myValue == null || this.myValue instanceof String && ((String)this.myValue).trim().isEmpty();
    }

    public static class Builder<T> {
        private String myGuiName;
        private String myUnits = "";
        private final String myCmdLineName;
        private String myDescription = "";
        private List<Range<Comparable<T>>> myRanges = new ArrayList<Range<Comparable<T>>>();
        private final T myDefaultValue;
        private boolean myIsRequired = false;
        private final Class<T> myClass;
        private PARAMETER_TYPE myParameterType = PARAMETER_TYPE.NA;
        private PluginParameter<?> myDependentOnParameter = null;
        private Object[] myDependentOnParameterValue = null;
        private List<T> myPossibleValues = null;
        private boolean myIsNullable = false;

        public Builder(String cmdLineName, T defaultValue, Class<T> type) {
            this.myCmdLineName = cmdLineName;
            this.myDefaultValue = defaultValue;
            this.myClass = type;
        }

        public Builder<T> units(String units) {
            this.myUnits = units;
            return this;
        }

        public Builder<T> description(String description) {
            this.myDescription = description;
            return this;
        }

        public Builder<T> range(Range<Comparable<T>> range) {
            if (range != null) {
                this.myRanges.add(range);
            }
            return this;
        }

        public Builder<T> range(Comparable<T>[] values) {
            if (values != null) {
                for (Comparable<T> current : values) {
                    this.myRanges.add(Range.singleton(current));
                }
            }
            return this;
        }

        public Builder<T> required(boolean required) {
            this.myIsRequired = required;
            return this;
        }

        public Builder<T> guiName(String guiName) {
            this.myGuiName = guiName;
            return this;
        }

        public Builder<T> inFile() {
            this.myParameterType = PARAMETER_TYPE.IN_FILE;
            return this;
        }

        public Builder<T> outFile() {
            this.myParameterType = PARAMETER_TYPE.OUT_FILE;
            return this;
        }

        public Builder<T> inDir() {
            this.myParameterType = PARAMETER_TYPE.IN_DIR;
            return this;
        }

        public Builder<T> outDir() {
            this.myParameterType = PARAMETER_TYPE.OUT_DIR;
            return this;
        }

        public Builder<T> genotypeTable() {
            this.myParameterType = PARAMETER_TYPE.GENOTYPE_TABLE;
            return this;
        }

        public Builder<T> distanceMatrix() {
            this.myParameterType = PARAMETER_TYPE.DISTANCE_MATRIX;
            return this;
        }

        public Builder<T> siteNameList() {
            this.myParameterType = PARAMETER_TYPE.SITE_NAME_LIST;
            return this;
        }

        public Builder<T> objectListSingleSelect() {
            this.myParameterType = PARAMETER_TYPE.OBJECT_LIST_SINGLE_SELECT;
            return this;
        }

        public Builder<T> password() {
            this.myParameterType = PARAMETER_TYPE.PASSWORD;
            return this;
        }

        public Builder<T> dependentOnParameter(PluginParameter<?> parameter) {
            if (Boolean.class.isAssignableFrom(parameter.valueType())) {
                return this.dependentOnParameter(parameter, true);
            }
            throw new IllegalArgumentException("PluginParameter: dependentOnParameter: no default value for: " + parameter.valueType().getName());
        }

        public Builder<T> dependentOnParameter(PluginParameter<?> parameter, Object value) {
            this.myDependentOnParameter = parameter;
            this.myDependentOnParameterValue = new Object[]{value};
            return this;
        }

        public Builder<T> dependentOnParameter(PluginParameter<?> parameter, Object[] values) {
            this.myDependentOnParameter = parameter;
            Object[] result = new Object[values.length];
            System.arraycopy(values, 0, result, 0, values.length);
            this.myDependentOnParameterValue = result;
            return this;
        }

        public Builder<T> possibleValues(List<T> possibleValues) {
            this.myPossibleValues = possibleValues;
            return this;
        }

        public Builder<T> nullable() {
            this.myIsNullable = true;
            return this;
        }

        public PluginParameter<T> build() {
            if (this.myGuiName == null || this.myGuiName.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append(Character.toUpperCase(this.myCmdLineName.charAt(0)));
                for (int i = 1; i < this.myCmdLineName.length(); ++i) {
                    char current = this.myCmdLineName.charAt(i);
                    if (Character.isUpperCase(current)) {
                        builder.append(" ");
                    }
                    builder.append(current);
                }
                this.myGuiName = builder.toString();
            }
            if (this.myDescription.isEmpty()) {
                this.myDescription = this.myGuiName;
            }
            return new PluginParameter(this.myGuiName, this.myUnits, this.myCmdLineName, this.myDescription, this.myRanges, this.myDefaultValue, null, this.myIsRequired, this.myParameterType, this.myDependentOnParameter, this.myDependentOnParameterValue, this.myPossibleValues, this.myIsNullable, this.myClass);
        }
    }

    public static enum PARAMETER_TYPE {
        NA,
        IN_FILE,
        OUT_FILE,
        IN_DIR,
        OUT_DIR,
        GENOTYPE_TABLE,
        SITE_NAME_LIST,
        OBJECT_LIST_SINGLE_SELECT,
        DISTANCE_MATRIX,
        LABEL,
        PASSWORD;

    }
}

