/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import java.awt.Component;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ThreadedPluginListener
extends Thread {
    private static final Logger myLogger = Logger.getLogger(ThreadedPluginListener.class);
    private final PluginListener myPluginListener;
    private final PluginEvent myEvent;

    public ThreadedPluginListener(PluginListener pluginListener, PluginEvent event) {
        this.myPluginListener = pluginListener;
        this.myEvent = event;
    }

    @Override
    public void run() {
        try {
            this.myPluginListener.dataSetReturned(this.myEvent);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append("Out of Memory: ");
            Plugin plugin = null;
            try {
                plugin = (Plugin)this.myPluginListener;
                builder.append(Utils.getBasename(plugin.getClass().getName()));
                builder.append(" could not complete task: ");
            }
            catch (Exception exception) {
                // empty catch block
            }
            builder.append("\n");
            long heapMaxSize = Runtime.getRuntime().maxMemory() / 0x100000L;
            builder.append("Current Max Heap Size: ");
            builder.append(heapMaxSize);
            builder.append(" Mb\n");
            builder.append("Use -Xmx option in start_tassel.pl or start_tassel.bat\n");
            builder.append("to increase heap size.");
            builder.append(" Included with tassel standalone zip.");
            String str = builder.toString();
            try {
                if (plugin.isInteractive()) {
                    DialogUtils.showError(str, (Component)plugin.getParentFrame());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            myLogger.error((Object)str);
        }
    }

    public PluginListener getPluginListener() {
        return this.myPluginListener;
    }
}

