/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.PCA;

import java.util.stream.IntStream;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import net.maizegenetics.taxa.distance.DistanceMatrix;

public class ClassicMds {
    private DistanceMatrix myDistanceMatrix;
    private EigenvalueDecomposition eigenDecomp;
    private DoubleMatrix eigenVectors;
    private int numberOfPositiveEigenvalues;
    private double tol = 1.0E-8;
    private int[] eigenSort;

    public ClassicMds(DistanceMatrix dm) {
        this.myDistanceMatrix = dm;
        this.testDMforMissing();
        this.calculatePCs();
    }

    public int maximumNumberOfPCs() {
        return this.numberOfPositiveEigenvalues;
    }

    public double[] getPrincipalCoordinate(int index) {
        if (index > this.numberOfPositiveEigenvalues - 1) {
            return null;
        }
        double eval = Math.sqrt(this.eigenDecomp.getEigenvalue(this.eigenSort[index]));
        int ntaxa = this.myDistanceMatrix.numberOfTaxa();
        double[] pc = new double[ntaxa];
        for (int i = 0; i < ntaxa; ++i) {
            pc[i] = this.eigenVectors.get(i, this.eigenSort[index]) * eval;
        }
        return pc;
    }

    public double getEigenvalue(int index) {
        return this.eigenDecomp.getEigenvalue(this.eigenSort[index]);
    }

    private void calculatePCs() {
        double mean;
        DoubleMatrix dm = this.SquaredDoubleMatrixFromDistanceMatrix();
        int n = dm.numberOfRows();
        for (int r = 0; r < n; ++r) {
            mean = dm.rowSum(r) / (double)n;
            for (int c = 0; c < n; ++c) {
                dm.set(r, c, dm.get(r, c) - mean);
            }
        }
        for (int c = 0; c < n; ++c) {
            mean = dm.columnSum(c) / (double)n;
            for (int r = 0; r < n; ++r) {
                dm.set(r, c, dm.get(r, c) - mean);
            }
        }
        dm.scalarMultEquals(-0.5);
        this.eigenDecomp = dm.getEigenvalueDecomposition();
        this.numberOfPositiveEigenvalues = 0;
        double[] eval = this.eigenDecomp.getEigenvalues();
        for (int i = 0; i < n; ++i) {
            if (!(eval[i] > this.tol)) continue;
            ++this.numberOfPositiveEigenvalues;
        }
        this.eigenVectors = this.eigenDecomp.getEigenvectors();
        int nEigenvalues = eval.length;
        this.eigenSort = IntStream.range(0, nEigenvalues).boxed().sorted((a, b) -> {
            if (eval[a] > eval[b]) {
                return -1;
            }
            if (eval[a] < eval[b]) {
                return 1;
            }
            return 0;
        }).mapToInt(I -> I).toArray();
    }

    private DoubleMatrix SquaredDoubleMatrixFromDistanceMatrix() {
        int n = this.myDistanceMatrix.getSize();
        DoubleMatrix dm = DoubleMatrixFactory.DEFAULT.make(n, n);
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                double val = this.myDistanceMatrix.getDistance(r, c);
                val *= val;
                dm.set(r, c, val);
            }
        }
        return dm;
    }

    private void testDMforMissing() {
        int n = this.myDistanceMatrix.getSize();
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                if (Double.isFinite(this.myDistanceMatrix.getDistance(r, c))) continue;
                throw new RuntimeException("Distance matrix contains missing values in ClassicMds.");
            }
        }
    }
}

