/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.Arrays;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.ModelEffect;

public class CovariateModelEffect
implements ModelEffect {
    private final double[] covariate;
    private final int size;
    private final double sum;
    private final double sumsq;
    private Object id = null;

    public CovariateModelEffect(double[] covariate) {
        this.covariate = covariate;
        this.size = covariate.length;
        double s = 0.0;
        double ss = 0.0;
        for (double cov : covariate) {
            s += cov;
            ss += cov * cov;
        }
        this.sum = s;
        this.sumsq = ss;
    }

    public CovariateModelEffect(double[] covariate, Object id) {
        this(covariate);
        this.id = id;
    }

    private CovariateModelEffect(double[] covariate, int size, double sum, double sumsq, Object id) {
        this.covariate = Arrays.copyOf(covariate, covariate.length);
        this.size = size;
        this.sum = sum;
        this.sumsq = sumsq;
        this.id = id;
    }

    @Override
    public Object getID() {
        return this.id;
    }

    @Override
    public int getNumberOfLevels() {
        return 1;
    }

    @Override
    public void setID(Object id) {
        this.id = id;
    }

    @Override
    public int[] getLevelCounts() {
        return new int[]{this.size};
    }

    @Override
    public int getSize() {
        return this.covariate.length;
    }

    @Override
    public DoubleMatrix getX() {
        return DoubleMatrixFactory.DEFAULT.make(this.covariate.length, 1, this.covariate);
    }

    @Override
    public DoubleMatrix getXtX() {
        return DoubleMatrixFactory.DEFAULT.make(1, 1, this.sumsq);
    }

    @Override
    public DoubleMatrix getXty(double[] y) {
        double sumprod = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sumprod += this.covariate[i] * y[i];
        }
        return DoubleMatrixFactory.DEFAULT.make(1, 1, sumprod);
    }

    @Override
    public DoubleMatrix getyhat(DoubleMatrix beta) {
        double scalar = beta.get(0, 0);
        DoubleMatrix yhat = DoubleMatrixFactory.DEFAULT.make(this.size, 1, this.covariate);
        yhat.scalarMultEquals(scalar);
        return yhat;
    }

    @Override
    public DoubleMatrix getyhat(double[] beta) {
        double scalar = beta[0];
        DoubleMatrix yhat = DoubleMatrixFactory.DEFAULT.make(this.size, 1, this.covariate);
        yhat.scalarMultEquals(scalar);
        return yhat;
    }

    public DoubleMatrix getXtX2(CovariateModelEffect cme) {
        double sumprod = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sumprod += this.covariate[i] * cme.covariate[i];
        }
        return DoubleMatrixFactory.DEFAULT.make(1, 1, sumprod);
    }

    public double[] getCovariate() {
        return this.covariate;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumSquares() {
        return this.sumsq;
    }

    @Override
    public ModelEffect getCopy() {
        return new CovariateModelEffect(Arrays.copyOf(this.covariate, this.size), this.size, this.sum, this.sumsq, this.id);
    }

    @Override
    public ModelEffect getSubSample(int[] sample) {
        int numberOfSamples = sample.length;
        double[] sampleCov = new double[numberOfSamples];
        for (int i = 0; i < numberOfSamples; ++i) {
            sampleCov[i] = this.covariate[sample[i]];
        }
        return new CovariateModelEffect(sampleCov, this.id);
    }

    @Override
    public int getEffectSize() {
        return 1;
    }
}

