/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.maizegenetics.analysis.modelfitter.AddPlusDomModelEffect;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.NestedCovariateModelEffect;

public class ModelEffectUtils {
    private static final List<Byte> homGeno = Arrays.asList(NucleotideAlignmentConstants.getNucleotideDiploidByte("A"), NucleotideAlignmentConstants.getNucleotideDiploidByte("C"), NucleotideAlignmentConstants.getNucleotideDiploidByte("G"), NucleotideAlignmentConstants.getNucleotideDiploidByte("T"), NucleotideAlignmentConstants.getNucleotideDiploidByte("Z"), NucleotideAlignmentConstants.getNucleotideDiploidByte("+"), NucleotideAlignmentConstants.getNucleotideDiploidByte("-"));

    private ModelEffectUtils() {
    }

    public static DoubleMatrix getXtY(ModelEffect X, ModelEffect Y) {
        if (X instanceof FactorModelEffect) {
            FactorModelEffect fme = (FactorModelEffect)X;
            if (Y instanceof FactorModelEffect) {
                return fme.getXtX2((FactorModelEffect)Y);
            }
            if (Y instanceof CovariateModelEffect) {
                return fme.getXty(((CovariateModelEffect)Y).getCovariate());
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return fme.getX().mult(Y.getX(), true, false);
            }
            if (Y instanceof AddPlusDomModelEffect) {
                return fme.getX().crossproduct(Y.getX());
            }
        } else if (X instanceof CovariateModelEffect) {
            double[] cov = ((CovariateModelEffect)X).getCovariate();
            if (Y instanceof FactorModelEffect) {
                return ModelEffectUtils.getXtY(Y, X).transpose();
            }
            if (Y instanceof CovariateModelEffect) {
                return Y.getXty(cov);
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return Y.getXty(cov).transpose();
            }
            if (Y instanceof AddPlusDomModelEffect) {
                return Y.getXty(cov).transpose();
            }
        } else if (X instanceof NestedCovariateModelEffect) {
            if (Y instanceof FactorModelEffect) {
                return X.getX().mult(Y.getX(), true, false);
            }
            if (Y instanceof CovariateModelEffect) {
                return X.getXty(((CovariateModelEffect)Y).getCovariate());
            }
            if (Y instanceof NestedCovariateModelEffect) {
                return ((NestedCovariateModelEffect)X).getXtX2((NestedCovariateModelEffect)Y);
            }
            if (Y instanceof AddPlusDomModelEffect) {
                return X.getX().crossproduct(Y.getX());
            }
        } else if (X instanceof AddPlusDomModelEffect) {
            return X.getX().crossproduct(Y.getX());
        }
        return null;
    }

    public static int[] getIntegerLevels(Object[] originalLevels) {
        int nLevels = originalLevels.length;
        int[] intLevels = new int[nLevels];
        HashMap<Object, Integer> levelMap = new HashMap<Object, Integer>();
        for (int i = 0; i < nLevels; ++i) {
            Integer ndx = (Integer)levelMap.get(originalLevels[i]);
            if (ndx == null) {
                ndx = new Integer(levelMap.size());
                levelMap.put(originalLevels[i], ndx);
            }
            intLevels[i] = ndx;
        }
        return intLevels;
    }

    public static <T> int[] getIntegerLevels(T[] originalLevels, ArrayList<T> ids) {
        int nLevels = originalLevels.length;
        int[] intLevels = new int[nLevels];
        HashMap<T, Integer> levelMap = new HashMap<T, Integer>();
        for (int i = 0; i < nLevels; ++i) {
            Integer ndx = (Integer)levelMap.get(originalLevels[i]);
            if (ndx == null) {
                ndx = new Integer(levelMap.size());
                levelMap.put(originalLevels[i], ndx);
            }
            intLevels[i] = ndx;
        }
        if (ids != null) {
            TreeSet sortedEntries = new TreeSet(new Comparator<Map.Entry<T, Integer>>(){

                @Override
                public int compare(Map.Entry<T, Integer> arg0, Map.Entry<T, Integer> arg1) {
                    return arg0.getValue().compareTo(arg1.getValue());
                }
            });
            sortedEntries.addAll(levelMap.entrySet());
            for (Map.Entry entry : sortedEntries) {
                ids.add(entry.getKey());
            }
        }
        return intLevels;
    }

    public static int[] getIntegerLevelsSortedByGenotype(String[] originalLevels, ArrayList<String> ids) {
        int i;
        int nLevels = originalLevels.length;
        int[] intLevels = new int[nLevels];
        String nukes = "ACGT";
        HashSet idSet = Arrays.stream(originalLevels).collect(Collectors.toCollection(HashSet::new));
        ids.addAll(idSet);
        Collections.sort(ids, (a, b) -> {
            String id1 = a.toString();
            String id2 = b.toString();
            if (nukes.contains(id1)) {
                if (nukes.contains(id2)) {
                    return id1.compareTo(id2);
                }
                return -1;
            }
            if (nukes.contains(id2)) {
                return 1;
            }
            return id1.compareTo(id2);
        });
        HashMap<String, Integer> levelMap = new HashMap<String, Integer>();
        for (i = 0; i < ids.size(); ++i) {
            levelMap.put(ids.get(i), i);
        }
        for (i = 0; i < nLevels; ++i) {
            intLevels[i] = (Integer)levelMap.get(originalLevels[i]);
        }
        return intLevels;
    }

    public static int[] getIntegerLevels(byte[] genotypes, ArrayList<Byte> ids) {
        int n = genotypes.length;
        TreeSet<Byte> genotypeSet = new TreeSet<Byte>((a, b) -> {
            if (homGeno.contains(a)) {
                if (homGeno.contains(b)) {
                    return a.compareTo((Byte)b);
                }
                return -1;
            }
            if (homGeno.contains(b)) {
                return 1;
            }
            return a.compareTo((Byte)b);
        });
        for (byte b2 : genotypes) {
            genotypeSet.add(b2);
        }
        ids.addAll(genotypeSet);
        HashMap<Byte, Integer> genoMap = new HashMap<Byte, Integer>();
        for (int i2 = 0; i2 < ids.size(); ++i2) {
            genoMap.put(ids.get(i2), i2);
        }
        return IntStream.range(0, n).map(i -> (Integer)genoMap.get(genotypes[i])).toArray();
    }

    public static byte[] genotypesToUnphasedSorted(byte[] genotypes) {
        byte[] unphasedSorted = new byte[genotypes.length];
        for (int g = 0; g < genotypes.length; ++g) {
            unphasedSorted[g] = GenotypeTableUtils.getUnphasedSortedDiploidValue(genotypes[g]);
        }
        return unphasedSorted;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int[] getIntegerLevels(ArrayList<T> originalLevels, ArrayList<T> ids) {
        int[] intLevels = new int[originalLevels.size()];
        HashMap<T, Integer> levelMap = new HashMap<T, Integer>();
        int count = 0;
        for (T level : originalLevels) {
            void var7_7;
            Integer n = (Integer)levelMap.get(level);
            if (n == null) {
                Integer n2 = new Integer(levelMap.size());
                levelMap.put(level, n2);
            }
            intLevels[count++] = var7_7.intValue();
        }
        if (ids != null) {
            TreeSet sortedEntries = new TreeSet(new Comparator<Map.Entry<T, Integer>>(){

                @Override
                public int compare(Map.Entry<T, Integer> arg0, Map.Entry<T, Integer> arg1) {
                    return arg0.getValue().compareTo(arg1.getValue());
                }
            });
            sortedEntries.addAll(levelMap.entrySet());
            for (Map.Entry entry : sortedEntries) {
                ids.add(entry.getKey());
            }
        }
        return intLevels;
    }

    public static <T> int[] getIntegerLevels(ArrayList<T> originalLevels) {
        return ModelEffectUtils.getIntegerLevels(originalLevels, null);
    }

    public static int[] getIntegerLevels(int[] originalLevels) {
        TreeSet originalSet = Arrays.stream(originalLevels).collect(TreeSet::new, TreeSet::add, TreeSet::addAll);
        int norig = originalLevels.length;
        if (originalSet.size() == norig) {
            return originalLevels;
        }
        int[] index = new int[norig];
        Arrays.fill(index, -1);
        int count = 0;
        for (Integer level : originalSet) {
            index[level.intValue()] = count++;
        }
        int[] newLevels = new int[norig];
        for (int i = 0; i < norig; ++i) {
            newLevels[i] = index[originalLevels[i]];
        }
        return newLevels;
    }

    public static double[] getNumericCodingForAdditiveModel(Object[] marker, String allele) {
        int nmarkers = marker.length;
        if (allele.equals("N")) {
            return new double[nmarkers];
        }
        String firstMarker = (String)marker[0];
        double[] values = new double[nmarkers];
        if (firstMarker.contains(":")) {
            Pattern colon = Pattern.compile(":");
            for (int m = 0; m < nmarkers; ++m) {
                String markerval = (String)marker[m];
                String[] markerAlleles = colon.split(markerval);
                if (markerAlleles[0].equals(allele)) {
                    int n = m;
                    values[n] = values[n] + 1.0;
                }
                if (!markerAlleles[1].equals(allele)) continue;
                int n = m;
                values[n] = values[n] + 1.0;
            }
        } else {
            Pattern nuc = Pattern.compile("[RSYWKM0]");
            for (int m = 0; m < nmarkers; ++m) {
                String markerval = (String)marker[m];
                values[m] = markerval.equals(allele) ? 2.0 : (nuc.matcher((String)marker[m]).matches() ? 1.0 : 0.0);
            }
        }
        return values;
    }

    public static double[] getNumericCodingForAdditiveModel(byte[] marker, byte allele) {
        int nmarkers = marker.length;
        double[] values = new double[nmarkers];
        for (int m = 0; m < nmarkers; ++m) {
            byte[] markerval;
            for (byte alleleval : markerval = GenotypeTableUtils.getDiploidValues(marker[m])) {
                if (alleleval != allele) continue;
                int n = m;
                values[n] = values[n] + 1.0;
            }
        }
        return values;
    }
}

