/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SweepFast;

public class SweepFastLinearModel {
    SweepFast sf;
    ArrayList<ModelEffect> modelEffects;
    int[] dimX;
    double[] y;
    ArrayList<Double> incrementalss;
    ArrayList<Double> incrementaldf;
    double totalSS;
    double modeldf;

    public SweepFastLinearModel(ArrayList<ModelEffect> effects, double[] data) {
        this.modelEffects = effects;
        this.y = data;
        this.init();
    }

    public SweepFastLinearModel(List<ModelEffect> effects, double[] data) {
        this.modelEffects = effects instanceof ArrayList ? (ArrayList<Object>)effects : new ArrayList<ModelEffect>(effects);
        this.y = data;
        this.init();
    }

    public SweepFastLinearModel(ArrayList<ModelEffect> effects, DoubleMatrix[][] xtx, DoubleMatrix[] xty, double[] data) {
        this.modelEffects = effects;
        this.y = data;
        this.init(xtx, xty);
    }

    private void init() {
        int neffects = this.modelEffects.size();
        DoubleMatrix[][] xtx = new DoubleMatrix[neffects][neffects];
        DoubleMatrix[] xty = new DoubleMatrix[neffects];
        for (int i = 0; i < neffects; ++i) {
            xty[i] = this.modelEffects.get(i).getXty(this.y);
            xtx[i][i] = this.modelEffects.get(i).getXtX();
            for (int j = i + 1; j < neffects; ++j) {
                xtx[i][j] = ModelEffectUtils.getXtY(this.modelEffects.get(i), this.modelEffects.get(j));
            }
        }
        this.init(xtx, xty);
    }

    private void init(DoubleMatrix[][] xtx, DoubleMatrix[] xty) {
        this.incrementalss = new ArrayList();
        this.incrementaldf = new ArrayList();
        int neffects = xtx.length;
        this.dimX = new int[neffects];
        for (int i = 0; i < neffects; ++i) {
            this.dimX[i] = xtx[i][i].numberOfColumns();
        }
        double sum = 0.0;
        double sumsq = 0.0;
        for (double d : this.y) {
            sum += d;
            sumsq += d * d;
        }
        this.totalSS = sumsq;
        this.sf = new SweepFast(xtx, xty, this.totalSS);
        this.modeldf = 0.0;
        double thisdf = 0.0;
        int count = 0;
        for (int i = 0; i < this.dimX[0]; ++i) {
            if (!this.sf.revg2sweep(count++)) continue;
            thisdf += 1.0;
            this.modeldf += 1.0;
        }
        double previousErrorSS = this.sf.getResidualSS();
        this.incrementalss.add(new Double(this.totalSS - previousErrorSS));
        this.incrementaldf.add(new Double(thisdf));
        this.sf.setDminFromA();
        for (int i = 1; i < neffects; ++i) {
            thisdf = 0.0;
            for (int j = 0; j < this.dimX[i]; ++j) {
                if (!this.sf.revg2sweep(count++)) continue;
                thisdf += 1.0;
                this.modeldf += 1.0;
            }
            double newErrorSS = this.sf.getResidualSS();
            this.incrementalss.add(new Double(previousErrorSS - newErrorSS));
            this.incrementaldf.add(new Double(thisdf));
            previousErrorSS = newErrorSS;
        }
    }

    public double[] getMarginalSSdf(int effect) {
        int start = 0;
        for (int i = 0; i < effect; ++i) {
            start += this.dimX[i];
        }
        int end = start + this.dimX[effect];
        double df = 0.0;
        for (int i = start; i < end; ++i) {
            this.sf.revg2sweep(i);
        }
        this.sf.sweepSingularColumns();
        double reducedModelSS = this.sf.getResidualSS();
        for (int i = start; i < end; ++i) {
            if (!this.sf.revg2sweep(i)) continue;
            df += 1.0;
        }
        return new double[]{reducedModelSS - this.sf.getResidualSS(), df};
    }

    public double[] getIncrementalSSdf(int effect) {
        return new double[]{this.incrementalss.get(effect), this.incrementaldf.get(effect)};
    }

    public double[] getResidualSSdf() {
        double ss = this.sf.getResidualSS();
        double df = (double)this.y.length - this.modeldf;
        return new double[]{ss, df};
    }

    public double[] getFullModelSSdf() {
        double ss = this.totalSS - this.sf.getResidualSS();
        double df = 0.0;
        for (Double effectdf : this.incrementaldf) {
            df += effectdf.doubleValue();
        }
        return new double[]{ss, df};
    }

    public double[] getModelcfmSSdf() {
        double ss = this.totalSS - this.incrementalss.get(0) - this.sf.getResidualSS();
        double df = 0.0;
        int n = this.incrementaldf.size();
        for (int i = 1; i < n; ++i) {
            df += this.incrementaldf.get(i).doubleValue();
        }
        return new double[]{ss, df};
    }

    public double[] getBeta() {
        return this.sf.getBeta();
    }

    public double[] getBlues(int effect, boolean restricted) {
        int i;
        if (this.modelEffects == null) {
            return null;
        }
        if (!(this.modelEffects.get(effect) instanceof FactorModelEffect)) {
            return null;
        }
        double mean = 0.0;
        int neffects = this.modelEffects.size();
        double[] beta = this.getBeta();
        int startIndex = 0;
        int startIndexForEffect = 0;
        for (i = 0; i < neffects; ++i) {
            double effectAverage = 0.0;
            if (i != effect && this.modelEffects.get(effect) instanceof FactorModelEffect) {
                FactorModelEffect fme = (FactorModelEffect)this.modelEffects.get(effect);
                for (int j = 0; j < this.dimX[i]; ++j) {
                    effectAverage += beta[startIndex + j];
                }
                effectAverage = restricted && effect > 0 ? (effectAverage /= (double)(this.dimX[i] + 1)) : (effectAverage /= (double)this.dimX[i]);
            } else if (i == effect) {
                startIndexForEffect = startIndex;
            }
            startIndex += this.dimX[effect];
            mean += effectAverage;
        }
        double[] blues = restricted ? new double[this.dimX[effect] + 1] : new double[this.dimX[effect]];
        for (i = 0; i < this.dimX[effect]; ++i) {
            blues[i] = mean + beta[startIndexForEffect + i];
        }
        if (restricted) {
            blues[blues.length - 1] = mean;
        }
        return blues;
    }

    public DoubleMatrix getInverseOfXtX() {
        DoubleMatrix A = this.sf.getA();
        int n = A.numberOfRows();
        int[] ndx = new int[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            ndx[i] = i;
        }
        return A.getSelection(ndx, ndx);
    }

    public DoubleMatrix getPredictedValues() {
        if (this.modelEffects == null) {
            return null;
        }
        int numberOfEffects = this.modelEffects.size();
        if (numberOfEffects == 0) {
            return null;
        }
        double[] beta = this.getBeta();
        int start = 0;
        ModelEffect me = this.modelEffects.get(0);
        int effectSize = me.getEffectSize();
        double[] thisbeta = Arrays.copyOfRange(beta, start, start + effectSize);
        DoubleMatrix p = me.getyhat(thisbeta);
        start += effectSize;
        for (int i = 1; i < numberOfEffects; ++i) {
            me = this.modelEffects.get(i);
            effectSize = me.getEffectSize();
            thisbeta = Arrays.copyOfRange(beta, start, start + effectSize);
            p.plusEquals(me.getyhat(thisbeta));
            start += effectSize;
        }
        return p;
    }

    public DoubleMatrix getResiduals() {
        DoubleMatrix r = DoubleMatrixFactory.DEFAULT.make(this.y.length, 1, this.y);
        r.minusEquals(this.getPredictedValues());
        return r;
    }
}

