/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.stats.linearmodels.SweepFast;
import net.maizegenetics.util.BitSet;
import org.apache.log4j.Logger;

public class SymmetricMatrixInverterDM {
    private static final Logger myLogger = Logger.getLogger(SymmetricMatrixInverterDM.class);
    private SweepFast originalSweep = new SweepFast();
    boolean[] included;

    public SymmetricMatrixInverterDM(DoubleMatrix symmetricMatrix) {
        this.originalSweep.setUTA(SweepFast.UTAFromDoubleMatrix(symmetricMatrix));
        this.originalSweep.fullSweepSetDmin();
    }

    public DoubleMatrix getInverse(boolean[] exclude) {
        int n = exclude.length;
        if (n == 0 || exclude == null) {
            DoubleMatrix inverse = this.originalSweep.getA();
            for (int i = 0; i < n; ++i) {
                if (!this.originalSweep.isSingular(i)) continue;
                for (int j = 0; j < n; ++j) {
                    inverse.set(i, j, 0.0);
                    inverse.set(j, i, 0.0);
                }
            }
            return inverse;
        }
        SweepFast sf = this.originalSweep.copy();
        for (int i = 0; i < n; ++i) {
            if (!exclude[i]) continue;
            sf.revg2sweep(i);
        }
        sf.sweepSingularColumns();
        DoubleMatrix inverse = sf.getSubsetOfA(exclude);
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (exclude[i]) continue;
            if (sf.isSingular(i)) {
                for (int j = 0; j < n; ++j) {
                    inverse.set(count, j, 0.0);
                    inverse.set(j, count, 0.0);
                }
            }
            ++count;
        }
        return inverse;
    }

    public DoubleMatrix getInverse(BitSet exclude, int size) {
        boolean[] boolExclude = new boolean[size];
        for (int i = 0; i < size; ++i) {
            boolExclude[i] = exclude.fastGet(i);
        }
        return this.getInverse(boolExclude);
    }
}

