/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.statistics;

import java.util.Arrays;
import net.maizegenetics.stats.statistics.GammaDistribution;

public class ApproxFastChiSquareDistribution
extends GammaDistribution {
    double[][] precomputed;
    int maxN;
    int maxX;

    public ApproxFastChiSquareDistribution(int maxX, int maxN) {
        this.maxN = maxN;
        this.maxX = maxX;
        this.precomputed = new double[maxN][maxX + 1];
        Arrays.fill(this.precomputed[0], 0.0);
        for (int n = 1; n < maxN; ++n) {
            for (int x = 0; x <= maxX; ++x) {
                this.precomputed[n][x] = ApproxFastChiSquareDistribution.cdf(x, n);
            }
        }
    }

    public static double pdf(double x, double n) {
        return ApproxFastChiSquareDistribution.pdf(x, n / 2.0, 2.0);
    }

    public static double cdf(double x, double n) {
        return ApproxFastChiSquareDistribution.cdf(x, n / 2.0, 2.0);
    }

    public double cdfFastApprox(double x, double n) {
        int lx = (int)x;
        int ln = (int)n;
        int lxFloor = (int)Math.floor(x);
        int lxCeil = (int)Math.ceil(x);
        double d = x - (double)lxFloor;
        double p = d * this.precomputed[ln][lxCeil] + (1.0 - d) * this.precomputed[ln][lxFloor];
        return p;
    }

    public static double quantile(double y, double n) {
        return ApproxFastChiSquareDistribution.quantile(y, n / 2.0, 2.0);
    }

    public static double mean(double n) {
        return n;
    }

    public static double variance(double n) {
        return 2.0 * n;
    }
}

