/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.maizegenetics.analysis.association.EqtlAssociationPlugin;
import net.maizegenetics.analysis.association.FastMultithreadedAssociationPlugin;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumPlugin;
import net.maizegenetics.analysis.popgen.SequenceDiversityPlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.snp.FilterList;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.gui.GenotypeTableMask;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.tassel.SeqViewerPanel;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.tassel.TableReportPanel;
import net.maizegenetics.taxa.IdentifierSynonymizer;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.tree.SimpleTree;
import net.maizegenetics.taxa.tree.Tree;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.HDF5TableReport;
import net.maizegenetics.util.TableReport;
import org.apache.log4j.Logger;

public class DataTreePanel
extends JPanel
implements PluginListener {
    private static final Logger myLogger = Logger.getLogger(DataTreePanel.class);
    public static final String NODE_TYPE_DATA = "Data";
    public static final String NODE_TYPE_RESULT = "Result";
    public static final String NODE_TYPE_SEQUENCE = "Sequence";
    public static final String NODE_TYPE_POLYMORPHISMS = "Polymorphisms";
    public static final String NODE_TYPE_NUMERICAL = "Numerical";
    public static final String NODE_TYPE_HDF5_SCHEMA = "HDF5 Schema";
    public static final String NODE_TYPE_MATRIX = "Matrix";
    public static final String NODE_TYPE_TREE = "Tree";
    public static final String NODE_TYPE_LISTS = "Lists";
    public static final String NODE_TYPE_FILTERS = "Filters";
    public static final String NODE_TYPE_FUSIONS = "Fusions";
    public static final String NODE_TYPE_SYNONYMS = "Synonyms";
    public static final String NODE_TYPE_DIVERSITY = "Diversity";
    public static final String NODE_TYPE_SNP_ASSAYS = "SNP Assays";
    public static final String NODE_TYPE_LD = "LD";
    public static final String NODE_TYPE_ASSOCIATIONS = "Association";
    public static final String NODE_TYPE_VARIANCES = "Variances";
    public static final String NODE_TYPE_SYNONYMIZER = "Synonymizer";
    public static final String NODE_TYPE_STEPWISE = "Stepwise";
    public static final String NODE_TYPE_TOPM = "TOPM";
    public static final String NODE_TYPE_GENO_SUMMARY = "Genotype Summary";
    public static final String NODE_TYPE_DEFAULT = "Data";
    private static final List<String> NODE_TYPE_DATA_CHILDREN = new ArrayList<String>();
    private String myLineStyle = "Angled";
    private JTree myTree;
    private DefaultTreeModel myTreeModel;
    private TASSELMainFrame myTASSELMainFrame;
    private HashMap<String, DefaultMutableTreeNode> myNodeHash = new HashMap();
    private LinkedHashMap myDataSetList = new LinkedHashMap();
    private Datum myLastBookSelected;
    private DefaultMutableTreeNode myTopNode;
    private DefaultMutableTreeNode myDataNode;
    private DefaultMutableTreeNode myResultNode;
    private DefaultMutableTreeNode myLastNode = null;
    private TreeSelectionListener myTreeSelectionListener = null;

    public DataTreePanel(TASSELMainFrame theQAF) {
        this.myTASSELMainFrame = theQAF;
        this.myTopNode = new DefaultMutableTreeNode("top");
        this.createNodes();
        this.myTreeModel = new DefaultTreeModel(this.myTopNode);
        this.myTree = new JTree(this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setEditable(true);
        this.myTreeModel.addTreeModelListener(new MyTreeModelListener(this));
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.setLargeModel(true);
        this.initSelectionListener();
        this.initKeyStrokeListener();
        this.myTree.putClientProperty("JTree.lineStyle", this.myLineStyle);
        this.myTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree pTree, Object pValue, boolean pIsSelected, boolean pIsExpanded, boolean pIsLeaf, int pRow, boolean pHasFocus) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)pValue;
                Datum nodeInfo = (Datum)node.getUserObject();
                Component result = super.getTreeCellRendererComponent(pTree, pValue, pIsSelected, pIsExpanded, pIsLeaf, pRow, pHasFocus);
                Object data = nodeInfo.getData();
                if (data instanceof GenotypeTableMask) {
                    result.setForeground(((GenotypeTableMask)nodeInfo.getData()).getColor());
                }
                return result;
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DataTreePanel getThis() {
        return this;
    }

    private void processMyKeyStroke(KeyEvent e) {
        if (e.getID() == 402 && 127 == e.getKeyCode()) {
            int userResponse;
            TreePath[] currentSelection = this.myTree.getSelectionPaths();
            String pluralQuestion = "Are you sure you want to delete these " + currentSelection.length + " nodes?";
            String question = "Are you sure you want to delete this node?";
            if (currentSelection.length > 1) {
                question = pluralQuestion;
            }
            if ((userResponse = JOptionPane.showOptionDialog(this.myTASSELMainFrame, question, "Node Deletion", 0, 3, null, null, null)) == 0) {
                this.deleteSelectedNodes();
            }
        }
    }

    private void initKeyStrokeListener() {
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                DataTreePanel.this.processMyKeyStroke(e);
            }
        });
    }

    private void initSelectionListener() {
        this.myTreeSelectionListener = new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                block64: {
                    try {
                        TableReportPanel theATP;
                        JPanel blankPanel;
                        String comment;
                        DistanceMatrix matrix;
                        GeneralAnnotation annotations;
                        GenotypeTable a;
                        DefaultMutableTreeNode node = null;
                        node = e != null && e.getSource() instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)e.getSource() : (DefaultMutableTreeNode)DataTreePanel.this.myTree.getLastSelectedPathComponent();
                        if (node == null) {
                            return;
                        }
                        if (DataTreePanel.this.myLastNode == node) {
                            return;
                        }
                        DataTreePanel.this.myLastNode = node;
                        Object nodeInfo = node.getUserObject();
                        DataTreePanel.this.myLastBookSelected = (Datum)nodeInfo;
                        Datum book = (Datum)nodeInfo;
                        myLogger.info((Object)("initSelectionListener: node type: " + book.getDataType()));
                        StringBuilder builder = new StringBuilder();
                        if (book.getData() instanceof GenotypeTable) {
                            a = (GenotypeTable)book.getData();
                            builder.append("Number of taxa: ");
                            builder.append(a.numberOfTaxa());
                            builder.append("\n");
                            builder.append("Number of sites: ");
                            builder.append(a.numberOfSites());
                            builder.append("\n");
                            Chromosome[] loci = a.chromosomes();
                            Object positions = null;
                            boolean first = true;
                            int numLoci = 0;
                            if (loci != null) {
                                numLoci = loci.length;
                                positions = a.positions();
                            }
                            for (int i = 0; i < numLoci; ++i) {
                                String name = loci[i].getName();
                                if (name == null || name.length() == 0) continue;
                                if (first) {
                                    builder.append("\nChromosomes...\n\n");
                                    first = false;
                                }
                                builder.append(name);
                                int[] firstLast = a.firstLastSiteOfChromosome(loci[i]);
                                builder.append(": ");
                                builder.append(firstLast[1] - firstLast[0] + 1);
                                builder.append(" sites:\n");
                                builder.append(firstLast[0]);
                                builder.append(" (");
                                builder.append(((Position)positions.get(firstLast[0])).getPosition());
                                builder.append(") - ");
                                builder.append(firstLast[1]);
                                builder.append(" (");
                                builder.append(((Position)positions.get(firstLast[1])).getPosition());
                                builder.append(")");
                                builder.append("\n\n");
                            }
                        }
                        if (book.getData() instanceof GenotypeTable) {
                            try {
                                a = (GenotypeTable)book.getData();
                                if (a.hasGenotype() && NucleotideAlignmentConstants.isNucleotideEncodings(a.alleleDefinitions())) {
                                    builder.append("\n");
                                    builder.append("Nucleotide Codes\n(Derived from IUPAC)...\n");
                                    builder.append("A     A:A\n");
                                    builder.append("C     C:C\n");
                                    builder.append("G     G:G\n");
                                    builder.append("T     T:T\n");
                                    builder.append("R     A:G\n");
                                    builder.append("Y     C:T\n");
                                    builder.append("S     C:G\n");
                                    builder.append("W     A:T\n");
                                    builder.append("K     G:T\n");
                                    builder.append("M     A:C\n");
                                    builder.append("+     +:+ (insertion)\n");
                                    builder.append("0     +:-\n");
                                    builder.append("-     -:- (deletion)\n");
                                    builder.append("N     Unknown\n\n");
                                }
                            }
                            catch (Exception ex) {
                                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                            }
                        }
                        if (book.getData() instanceof TableReport) {
                            TableReport tr = (TableReport)book.getData();
                            long numColumns = tr.getColumnCount();
                            long numRows = tr.getRowCount();
                            builder.append("Table Title: ");
                            builder.append(tr.getTableTitle());
                            builder.append("\n");
                            builder.append("Number of columns: ");
                            builder.append(numColumns);
                            builder.append("\n");
                            builder.append("Number of rows: ");
                            builder.append(numRows);
                            builder.append("\n");
                            builder.append("Matrix size (excludes row headers): ");
                            builder.append((numColumns - 1L) * numRows);
                            builder.append("\n");
                        }
                        if (book.getData() instanceof TOPMInterface) {
                            TOPMInterface topm = (TOPMInterface)book.getData();
                            builder.append("Number of Tags: ");
                            builder.append(topm.getSize());
                            builder.append("\n");
                        }
                        if (book.getData() instanceof DistanceMatrix && (annotations = (matrix = (DistanceMatrix)book.getData()).annotations()) != null && annotations.numAnnotations() != 0) {
                            builder.append("\nAnnotations...\n");
                            for (Map.Entry<String, String> entry : annotations.getAllAnnotationEntries()) {
                                builder.append(entry.getKey());
                                builder.append(": ");
                                builder.append(entry.getValue());
                                builder.append("\n");
                            }
                            builder.append("\n");
                        }
                        if (book.getData() instanceof TaxaList) {
                            TaxaList taxa = (TaxaList)book.getData();
                            builder.append("Number of Taxa: ");
                            builder.append(taxa.numberOfTaxa());
                            builder.append("\n\n");
                        }
                        if ((comment = book.getComment()) != null && comment.length() != 0) {
                            builder.append(comment);
                        }
                        DataTreePanel.this.myTASSELMainFrame.setNoteText(builder.toString());
                        if (book.getData() == null) break block64;
                        ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.removeAll();
                        if (book.getData() instanceof TableReport) {
                            long size = ((TableReport)book.getData()).getElementCount();
                            myLogger.info((Object)("initSelectionListener: Table Report Size: " + size));
                            if (size == 0L) {
                                JPanel blankPanel2 = new JPanel();
                                blankPanel2.setLayout(new BorderLayout());
                                blankPanel2.add((Component)new JLabel("     Nothing to Display"), "Center");
                                ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)blankPanel2, "Center");
                            } else {
                                TableReportPanel theATP2 = TableReportPanel.getInstance((TableReport)book.getData());
                                ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)theATP2, "Center");
                            }
                        } else if (book.getData() instanceof FilterList) {
                            TableReportPanel theATP3 = TableReportPanel.getInstance((FilterList)book.getData());
                            ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)theATP3, "Center");
                        } else if (book.getData() instanceof TOPMInterface) {
                            int size = ((TOPMInterface)book.getData()).getTagCount();
                            myLogger.info((Object)("initSelectionListener: TOPM Tag Count: " + size));
                            if (size == 0) {
                                blankPanel = new JPanel();
                                blankPanel.setLayout(new BorderLayout());
                                blankPanel.add((Component)new JLabel("     No Tags"), "Center");
                                ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)blankPanel, "Center");
                            } else {
                                String name = book.getName();
                                if (name.endsWith("(Graphical)")) {
                                    SeqViewerPanel seqViewer = SeqViewerPanel.getInstance((TOPMInterface)book.getData(), DataTreePanel.this.getThis());
                                    ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)seqViewer, "Center");
                                } else {
                                    TableReportPanel theATP4 = TableReportPanel.getInstance((TOPMInterface)book.getData());
                                    ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)theATP4, "Center");
                                }
                            }
                        } else if (book.getData() instanceof TaxaList) {
                            int size = ((TaxaList)book.getData()).numberOfTaxa();
                            myLogger.info((Object)("initSelectionListener: Number of Taxa: " + size));
                            if (size == 0) {
                                blankPanel = new JPanel();
                                blankPanel.setLayout(new BorderLayout());
                                blankPanel.add((Component)new JLabel("     No Taxa"), "Center");
                                ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)blankPanel, "Center");
                            } else {
                                theATP = TableReportPanel.getInstance((TaxaList)book.getData());
                                ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)theATP, "Center");
                            }
                        } else if (book.getData() instanceof PositionList) {
                            int size = ((PositionList)book.getData()).numberOfSites();
                            myLogger.info((Object)("initSelectionListener: Number of Positions: " + size));
                            if (size == 0) {
                                blankPanel = new JPanel();
                                blankPanel.setLayout(new BorderLayout());
                                blankPanel.add((Component)new JLabel("     No Positions"), "Center");
                                ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)blankPanel, "Center");
                            } else {
                                theATP = TableReportPanel.getInstance((PositionList)book.getData());
                                ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)theATP, "Center");
                            }
                        } else if (book.getData() instanceof GenotypeTable) {
                            GenotypeTable align = (GenotypeTable)book.getData();
                            ArrayList<Object> masks = new ArrayList<Object>();
                            int n = node.getChildCount();
                            for (int i = 0; i < n; ++i) {
                                try {
                                    DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node.getChildAt(i);
                                    Datum currentDatum = (Datum)currentNode.getUserObject();
                                    Object currentMask = currentDatum.getData();
                                    if (currentMask == null || !(currentMask instanceof GenotypeTableMask)) continue;
                                    masks.add(currentMask);
                                    continue;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            SeqViewerPanel seqViewer = null;
                            if (masks.size() != 0) {
                                GenotypeTableMask[] masksArray = new GenotypeTableMask[masks.size()];
                                masks.toArray(masksArray);
                                seqViewer = SeqViewerPanel.getInstance(align, masksArray, DataTreePanel.this.getThis());
                            } else {
                                seqViewer = SeqViewerPanel.getInstance(align, DataTreePanel.this.getThis());
                            }
                            ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)seqViewer, "Center");
                        } else if (book.getData() instanceof GenotypeTableMask) {
                            Color tempColor;
                            GenotypeTableMask mask = (GenotypeTableMask)book.getData();
                            if (mask.getColor() != null && (tempColor = JColorChooser.showDialog(DataTreePanel.this.myTASSELMainFrame, "Select Mask Color...", mask.getColor())) != null) {
                                mask.setColor(tempColor);
                                book.setName(mask.toString());
                            }
                            DataTreePanel.this.myLastNode = null;
                            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                            TreeSelectionEvent event = new TreeSelectionEvent((Object)parentNode, null, false, null, null);
                            DataTreePanel.this.myTreeSelectionListener.valueChanged(event);
                        } else if (book.getData() instanceof SimpleTree) {
                            ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainPanelScrollPane, "Center");
                            SimpleTree tree = (SimpleTree)book.getData();
                            StringWriter writer = null;
                            try {
                                if (tree.getExternalNodeCount() < 300) {
                                    writer = new StringWriter();
                                    tree.report(writer);
                                    DataTreePanel.this.myTASSELMainFrame.setMainText(writer.toString());
                                }
                                DataTreePanel.this.myTASSELMainFrame.setMainText(tree.toString());
                            }
                            catch (Exception ex) {
                                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                            }
                            finally {
                                try {
                                    writer.close();
                                }
                                catch (Exception exception) {}
                            }
                        } else {
                            ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.add((Component)((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainPanelScrollPane, "Center");
                            String s = book.getData().toString();
                            if (s.length() > 2000000) {
                                s = s.substring(1, 2000000) + "\n Truncated view.  Too much to display.  Save it to a file.";
                            }
                            DataTreePanel.this.myTASSELMainFrame.setMainText(s);
                        }
                        DataTreePanel.this.myTASSELMainFrame.sendMessage(book.getData().getClass().toString());
                        ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.revalidate();
                        ((DataTreePanel)DataTreePanel.this).myTASSELMainFrame.mainDisplayPanel.repaint();
                    }
                    catch (Throwable e1) {
                        String userMessage = "TASSEL has experienced an error.  ";
                        if (e1 instanceof OutOfMemoryError) {
                            userMessage = "You have used up all of the memory allocated to the Java Virtual Machine.  \nIt is recommneded that you adjust your heap settings and possibly add more memory to the computer\nAdditionally, some operations are not recommended on a full dataset, i.e., select SNPs *before* determining LD";
                        }
                        JOptionPane.showMessageDialog(DataTreePanel.this.myTASSELMainFrame, userMessage, "Fatal Error", 0);
                        e1.printStackTrace();
                    }
                }
            }
        };
        this.myTree.addTreeSelectionListener(this.myTreeSelectionListener);
    }

    private void createNodes() {
        this.myDataNode = new DefaultMutableTreeNode(new Datum("Data", "Node on data tree", "Holds the basic data structures"));
        this.myTopNode.add(this.myDataNode);
        this.myNodeHash.put("Data", this.myDataNode);
        this.myResultNode = new DefaultMutableTreeNode(new Datum(NODE_TYPE_RESULT, "Node on data tree", "Holds the basic result structures"));
        this.myTopNode.add(this.myResultNode);
        this.myNodeHash.put(NODE_TYPE_RESULT, this.myResultNode);
    }

    private synchronized DefaultMutableTreeNode getTreeNode(String nodeString) {
        DefaultMutableTreeNode result = this.myNodeHash.get(nodeString);
        if (result == null) {
            if (NODE_TYPE_DATA_CHILDREN.contains(nodeString)) {
                result = new DefaultMutableTreeNode(new Datum(nodeString, nodeString, nodeString));
                int childIndex = this.getInsertLocation(this.myDataNode, nodeString);
                this.myTreeModel.insertNodeInto(result, this.myDataNode, childIndex);
                this.myNodeHash.put(nodeString, result);
            } else {
                result = new DefaultMutableTreeNode(new Datum(nodeString, nodeString, nodeString));
                int childIndex = this.getInsertLocation(this.myResultNode, nodeString);
                this.myTreeModel.insertNodeInto(result, this.myResultNode, childIndex);
                this.myNodeHash.put(nodeString, result);
            }
        }
        return result;
    }

    private int getInsertLocation(DefaultMutableTreeNode node, String newNode) {
        DefaultMutableTreeNode currentNode;
        Datum current;
        Enumeration<TreeNode> children = node.children();
        int result = 0;
        while (children.hasMoreElements() && (current = (Datum)(currentNode = (DefaultMutableTreeNode)children.nextElement()).getUserObject()).getName().compareTo(newNode) <= 0) {
            ++result;
        }
        return result;
    }

    private void jbInit() throws Exception {
        JScrollPane jScrollPane1 = new JScrollPane(this.myTree);
        jScrollPane1.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane1, "Center");
    }

    private void deleteDatumFromList(Datum datum) {
        Iterator itr = this.myDataSetList.keySet().iterator();
        while (itr.hasNext()) {
            Datum current = (Datum)itr.next();
            if (current != datum) continue;
            itr.remove();
            break;
        }
    }

    public void addDataSet(DataSet theDataSet, String defaultNode) {
        Plugin theCreator = theDataSet.getCreator();
        for (int i = 0; i < theDataSet.getSize(); ++i) {
            Datum d = theDataSet.getData(i);
            if (theCreator instanceof MLMPlugin || theCreator instanceof FixedEffectLMPlugin || theCreator instanceof FastMultithreadedAssociationPlugin || theCreator instanceof EqtlAssociationPlugin) {
                this.addDatum(NODE_TYPE_ASSOCIATIONS, d);
                continue;
            }
            if (theCreator instanceof GenotypeSummaryPlugin) {
                this.addDatum(NODE_TYPE_GENO_SUMMARY, d);
                continue;
            }
            if (theCreator instanceof SequenceDiversityPlugin) {
                this.addDatum(NODE_TYPE_DIVERSITY, d);
                continue;
            }
            if (theCreator instanceof LinkageDisequilibriumPlugin) {
                this.addDatum(NODE_TYPE_LD, d);
                continue;
            }
            if (d.getData() instanceof GenotypeTable) {
                this.addDatum(NODE_TYPE_SEQUENCE, d);
                continue;
            }
            if (d.getData() instanceof GenotypeTableMask) {
                this.addDatum(d);
                continue;
            }
            if (d.getData() instanceof IdentifierSynonymizer) {
                this.addDatum(NODE_TYPE_SYNONYMIZER, d);
                continue;
            }
            if (d.getData() instanceof Phenotype) {
                this.addDatum(NODE_TYPE_NUMERICAL, d);
                continue;
            }
            if (d.getData() instanceof DistanceMatrix) {
                this.addDatum(NODE_TYPE_MATRIX, d);
                continue;
            }
            if (d.getData() instanceof HDF5TableReport) {
                this.addDatum(NODE_TYPE_HDF5_SCHEMA, d);
                continue;
            }
            if (d.getData() instanceof TableReport) {
                this.addDatum(NODE_TYPE_NUMERICAL, d);
                continue;
            }
            if (d.getData() instanceof FilterList) {
                this.addDatum(NODE_TYPE_FILTERS, d);
                continue;
            }
            if (d.getData() instanceof Tree) {
                this.addDatum(NODE_TYPE_TREE, d);
                continue;
            }
            if (d.getData() instanceof TaxaList) {
                this.addDatum(NODE_TYPE_LISTS, d);
                continue;
            }
            if (d.getData() instanceof PositionList) {
                this.addDatum(NODE_TYPE_LISTS, d);
                continue;
            }
            if (d.getData() instanceof TOPMInterface) {
                this.addDatum(NODE_TYPE_TOPM, new Datum(d.getName() + " (Text)", d.getData(), null));
                this.addDatum(NODE_TYPE_TOPM, new Datum(d.getName() + " (Graphical)", d.getData(), null));
                continue;
            }
            if (defaultNode == null) {
                this.addDatum("Data", d);
                continue;
            }
            this.addDatum(defaultNode, d);
        }
    }

    public synchronized void addDatum(String dataParent, Datum theDatum) {
        if (theDatum.getData() instanceof GenotypeTableMask) {
            this.addDatum(theDatum);
            return;
        }
        DefaultMutableTreeNode temp = this.findOnTree(theDatum);
        if (temp != null) {
            this.myTree.scrollPathToVisible(new TreePath(temp.getPath()));
            this.myTree.validate();
            this.myTree.repaint();
            return;
        }
        DefaultMutableTreeNode parentNode = this.getTreeNode(dataParent);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(theDatum);
        this.myNodeHash.put(theDatum.getName(), childNode);
        this.myTreeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
        this.myTree.scrollPathToVisible(new TreePath(childNode.getPath()));
        if (theDatum instanceof Serializable) {
            this.myDataSetList.put(theDatum, dataParent);
        }
    }

    public synchronized void addDatum(Datum theDatum) {
        GenotypeTableMask mask = null;
        try {
            mask = (GenotypeTableMask)theDatum.getData();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DataTreePanel: addDatum: input must be AlignmentMask.");
        }
        GenotypeTable align = mask.getAlignment();
        for (DefaultMutableTreeNode parentNode : this.myNodeHash.values()) {
            Object current = ((Datum)parentNode.getUserObject()).getData();
            if (!(current instanceof GenotypeTable) || current != align) continue;
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(theDatum);
            this.myTreeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
            this.myTree.scrollPathToVisible(new TreePath(childNode.getPath()));
            this.myLastNode = null;
            this.myTree.setSelectionPath(new TreePath(parentNode.getPath()));
            this.myTree.scrollPathToVisible(new TreePath(parentNode.getPath()));
            this.myTreeSelectionListener.valueChanged(null);
            if (!(theDatum instanceof Serializable)) break;
            this.myDataSetList.put(theDatum, "NA");
            break;
        }
    }

    public void setSelectionPath(Datum theDatum) {
        DefaultMutableTreeNode temp = this.findOnTree(theDatum);
        if (temp != null) {
            this.myTree.scrollPathToVisible(new TreePath(temp.getPath()));
            this.myTree.setSelectionPath(new TreePath(temp.getPath()));
            this.myTree.validate();
            this.myTree.repaint();
        }
    }

    private DefaultMutableTreeNode findOnTree(Datum theDatum) {
        if (theDatum == null) {
            return null;
        }
        for (DefaultMutableTreeNode parentNode : this.myNodeHash.values()) {
            Datum current = (Datum)parentNode.getUserObject();
            if (current == null || !current.equals(theDatum)) continue;
            return parentNode;
        }
        return null;
    }

    public DataSet getSelectedTasselDataSet() {
        int n = this.myTree.getSelectionCount();
        String parentNodeName = null;
        ArrayList<Datum> data = new ArrayList<Datum>();
        TreePath[] tp = this.myTree.getSelectionPaths();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp[i].getLastPathComponent();
            if (node == null) {
                return null;
            }
            if (i == 0) {
                parentNodeName = node.getParent().toString();
            } else if (!node.getParent().toString().equals(parentNodeName)) {
                parentNodeName = null;
            }
            data.add((Datum)node.getUserObject());
        }
        return new DataSet(data, null);
    }

    public void deleteSelectedNodes() {
        TreePath[] currentSelection = this.myTree.getSelectionPaths();
        if (currentSelection != null) {
            for (int i = 0; i < currentSelection.length; ++i) {
                myLogger.info((Object)("Start Deleting at Selection: " + currentSelection[i]));
                if (currentSelection[i] == null) continue;
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelection[i].getLastPathComponent();
                myLogger.info((Object)("Deleting Node : " + currentNode));
                this.deleteNode(currentNode);
            }
        }
    }

    private void deleteNode(DefaultMutableTreeNode currentNode) {
        int size = currentNode.getChildCount();
        for (int i = size - 1; i >= 0; --i) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)currentNode.getChildAt(i);
            this.deleteNode(current);
        }
        if (currentNode == this.myDataNode || currentNode == this.myResultNode) {
            return;
        }
        MutableTreeNode parent = (MutableTreeNode)currentNode.getParent();
        if (parent != null && parent != this.myDataNode && parent != this.myResultNode) {
            this.myTreeModel.removeNodeFromParent(currentNode);
            Iterator<String> itr = this.myNodeHash.keySet().iterator();
            while (itr.hasNext()) {
                String key = itr.next();
                if (this.myNodeHash.get(key) != currentNode) continue;
                itr.remove();
            }
            try {
                Datum datum = (Datum)currentNode.getUserObject();
                this.deleteDatumFromList(datum);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (((Datum)currentNode.getUserObject()).getData() instanceof GenotypeTableMask) {
                    this.myLastNode = null;
                    this.myTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)parent).getPath()));
                    this.myTree.scrollPathToVisible(new TreePath(((DefaultMutableTreeNode)parent).getPath()));
                    this.myTreeSelectionListener.valueChanged(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (((Datum)currentNode.getUserObject()).getData() instanceof GenotypeTable) {
                    SeqViewerPanel.removeInstance((GenotypeTable)((Datum)currentNode.getUserObject()).getData());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map getDataList() {
        return Collections.unmodifiableMap(this.myDataSetList);
    }

    public JTree getTree() {
        return this.myTree;
    }

    @Override
    public void dataSetReturned(PluginEvent event) {
        DataSet tds = (DataSet)event.getSource();
        if (tds != null) {
            this.addDataSet(tds, "Data");
            this.setSelectionPath(tds.getData(0));
        }
    }

    @Override
    public void progress(PluginEvent event) {
    }

    static {
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_SEQUENCE);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_POLYMORPHISMS);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_NUMERICAL);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_HDF5_SCHEMA);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_MATRIX);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_TREE);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_FUSIONS);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_TOPM);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_LISTS);
        NODE_TYPE_DATA_CHILDREN.add(NODE_TYPE_FILTERS);
    }

    class MyTreeModelListener
    implements TreeModelListener {
        DataTreePanel theDTP;

        public MyTreeModelListener(DataTreePanel theDTP) {
            this.theDTP = theDTP;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            try {
                int index = e.getChildIndices()[0];
                node = (DefaultMutableTreeNode)node.getChildAt(index);
            }
            catch (NullPointerException index) {
                // empty catch block
            }
            String s = (String)node.getUserObject();
            this.theDTP.myLastBookSelected.setName(s);
            node.setUserObject(this.theDTP.myLastBookSelected);
            System.out.println("The user has finished editing the node.");
            System.out.println("New value: " + node.getUserObject());
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

