/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.Component;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.pipeline.TasselPipeline;
import net.maizegenetics.plugindef.ParameterCache;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.util.LoggingUtils;
import org.apache.log4j.Logger;

public class TASSELMainApp {
    private static final Logger myLogger = Logger.getLogger(TASSELMainApp.class);

    private TASSELMainApp() {
    }

    public static void main(String[] args) {
        TASSELMainFrame frame = null;
        try {
            TasselPrefs.setPersistPreferences(true);
            LoggingUtils.setupLogging();
            frame = new TASSELMainFrame();
            frame.validate();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            ParameterCache.load(TasselPrefs.getConfigFile());
            if (args.length > 0) {
                new TasselPipeline(args, frame);
            }
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append("Out of Memory: \n");
            long heapMaxSize = Runtime.getRuntime().maxMemory() / 0x100000L;
            builder.append("Current Max Heap Size: ");
            builder.append(heapMaxSize);
            builder.append(" Mb\n");
            builder.append("Use -Xmx option in start_tassel.pl or start_tassel.bat\n");
            builder.append("to increase heap size.");
            builder.append(" Included with tassel standalone zip.");
            myLogger.error((Object)builder.toString());
        }
        catch (Exception e) {
            myLogger.error((Object)e.getMessage(), (Throwable)e);
            DialogUtils.showError(e.getMessage() + "\n", (Component)frame);
        }
    }
}

